/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestGroupBy {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testCastDifferentCase() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT CAST(x AS bigint) FROM (VALUES 42) t(x) GROUP BY CAST(x AS BIGINT)")))).matches("VALUES BIGINT '42'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT CAST(row(x) AS row(\"A\" bigint)) FROM (VALUES 42) t(x) GROUP BY CAST(row(x) AS row(\"A\" bigint))")))).matches("SELECT CAST(row(BIGINT '42') AS row(\"A\" bigint))");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT CAST(row(x) AS row(abc bigint)) FROM (VALUES 42) t(x) GROUP BY CAST(row(x) AS row(ABC bigint))")))).matches("SELECT CAST(row(BIGINT '42') AS row(abc bigint))");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT CAST(row(x) AS row(\"A\" bigint)) FROM (VALUES 42) t(x) GROUP BY CAST(row(x) AS row(\"A\" BigINT))")))).matches("SELECT CAST(row(BIGINT '42') AS row(\"A\" bigint))");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT CAST(row(x) AS row(\"a\" bigint)) FROM (VALUES 42) t(x) GROUP BY CAST(row(x) AS row(\"A\" bigint))")).hasMessage("line 1:8: 'CAST(ROW (x) AS ROW(\"a\" bigint))' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testDuplicateComplexExpressions() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT a + 1, a + 1 FROM (VALUES 1) t(a) GROUP BY 1, 2")))).matches("VALUES (2, 2)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT 1 FROM (VALUES 1) t(a) GROUP BY a + 1, a + 1")))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT 1 FROM (VALUES 1) t(a) GROUP BY t.a + 1, a + 1")))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT 1 FROM (VALUES 1) t(a) GROUP BY A + 1, a + 1")))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT 1 FROM (VALUES 1) t(a) GROUP BY t.A + 1, a + 1")))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT a + 1 FROM (VALUES 1) t(a) GROUP BY t.A + 1, 1")))).matches("VALUES 2");
    }

    @Test
    public void testReferenceWithMixedStyle() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT a + 1 FROM (VALUES 1) t(a) GROUP BY A + 1")))).matches("VALUES 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT a + 1 FROM (VALUES 1) t(a) GROUP BY t.a + 1")))).matches("VALUES 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT a + 1 FROM (VALUES 1) t(a) GROUP BY t.A + 1")))).matches("VALUES 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.a + 1 FROM (VALUES 1) t(a) GROUP BY a + 1")))).matches("VALUES 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.a + 1 FROM (VALUES 1) t(a) GROUP BY A + 1")))).matches("VALUES 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.a + 1 FROM (VALUES 1) t(a) GROUP BY t.A + 1")))).matches("VALUES 2");
    }

    @Test
    public void testGroupByRepeatedOrdinals() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT null GROUP BY 1, 1")))).matches("VALUES null");
    }
}

