/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestInlineFunctions {
    private final QueryAssertions assertions;

    public TestInlineFunctions() {
        Session session = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("tiny").build();
        StandaloneQueryRunner runner = new StandaloneQueryRunner(session);
        runner.installPlugin((Plugin)new TpchPlugin());
        runner.createCatalog("test_catalog", "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
        this.assertions = new QueryAssertions((QueryRunner)runner);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testInlineFunction() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH FUNCTION my_func(x bigint)\n    RETURNS bigint\n    RETURN x * 2\nSELECT my_func(nationkey)\nFROM nation\nWHERE nationkey = 1\n")))).matches("VALUES BIGINT '2'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH FUNCTION my_func(x bigint)\n    RETURNS bigint\n    RETURN x * 2\nSELECT my_func(nationkey)\nFROM nation\nWHERE nationkey >= 1\n")))).matches("SELECT nationkey * 2 FROM nation WHERE nationkey >= 1");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH FUNCTION my_func(x bigint)\n    RETURNS bigint\n    RETURN x * 2\nSELECT my_func(nationkey)\nFROM nation\n")))).matches("SELECT nationkey * 2 FROM nation");
    }
}

