/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestIssue16101 {
    @Test
    public void test() {
        Session session = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").build();
        StandaloneQueryRunner runner = new StandaloneQueryRunner(session);
        runner.installPlugin((Plugin)new TpchPlugin());
        runner.createCatalog("local", "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
        try (QueryAssertions assertions = new QueryAssertions((QueryRunner)runner);){
            ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(assertions.query("SELECT orderkey, orderstatus, x\nFROM (\n    SELECT orderkey, orderstatus, orderstatus = 'O' AS x\n    FROM orders) a\nINNER JOIN ( VALUES 1, 2, 3, 4 ) b(k)\nON a.orderkey = b.k\nWHERE orderstatus = 'O'\n")))).matches("VALUES\n    (BIGINT '1', 'O', true),\n    (BIGINT '2', 'O', true),\n    (BIGINT '4', 'O', true)\n");
        }
    }
}

