/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.io.BaseEncoding;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestJsonQueryFunction {
    private static final String INPUT = "[\"a\", \"b\", \"c\"]";
    private static final String OBJECT_INPUT = "{\"key\" : 1}";
    private static final String INCORRECT_INPUT = "[...";
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testJsonQuery() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $')")))).matches("VALUES VARCHAR '[\"a\",\"b\",\"c\"]'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'strict $')")))).matches("VALUES VARCHAR '[\"a\",\"b\",\"c\"]'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'strict $[100]')")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'strict $[100]' NULL ON ERROR)")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'strict $[100]' EMPTY ARRAY ON ERROR)")))).matches("VALUES VARCHAR '[]'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'strict $[100]' EMPTY OBJECT ON ERROR)")))).matches("VALUES VARCHAR '{}'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'strict $[100]' ERROR ON ERROR)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PATH_EVALUATION_ERROR}).hasMessage("path evaluation failed: structural error: invalid array subscript: [100, 100] for array of size 3");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[100]')")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[100]' NULL ON EMPTY)")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[100]' EMPTY ARRAY ON EMPTY)")))).matches("VALUES VARCHAR '[]'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[100]' EMPTY OBJECT ON EMPTY)")))).matches("VALUES VARCHAR '{}'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[100]' ERROR ON EMPTY)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_OUTPUT_CONVERSION_ERROR}).hasMessage("conversion from JSON failed: JSON path found no items");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[0 to 2]')")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[0 to 2]' NULL ON ERROR)")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[0 to 2]' EMPTY ARRAY ON ERROR)")))).matches("VALUES VARCHAR '[]'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[0 to 2]' EMPTY OBJECT ON ERROR)")))).matches("VALUES VARCHAR '{}'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[0 to 2]' ERROR ON ERROR)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_OUTPUT_CONVERSION_ERROR}).hasMessage("conversion from JSON failed: JSON path found multiple items");
    }

    @Test
    public void testInputFormat() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[1]')")))).matches("VALUES VARCHAR '\"b\"'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]' FORMAT JSON, 'lax $[1]')")))).matches("VALUES VARCHAR '\"b\"'");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]' FORMAT JSON ENCODING UTF8, 'lax $[1]')")).hasMessage("line 1:19: Cannot read input of type varchar(15) as JSON using formatting JSON ENCODING UTF8");
        byte[] bytes = INPUT.getBytes(StandardCharsets.UTF_8);
        String varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query(" + varbinaryLiteral + ", 'lax $[1]')")))).matches("VALUES VARCHAR '\"b\"'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query(" + varbinaryLiteral + " FORMAT JSON, 'lax $[1]')")))).matches("VALUES VARCHAR '\"b\"'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query(" + varbinaryLiteral + " FORMAT JSON ENCODING UTF8, 'lax $[1]')")))).matches("VALUES VARCHAR '\"b\"'");
        bytes = INPUT.getBytes(StandardCharsets.UTF_16LE);
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query(" + varbinaryLiteral + " FORMAT JSON ENCODING UTF16, 'lax $[1]')")))).matches("VALUES VARCHAR '\"b\"'");
        bytes = INPUT.getBytes(Charset.forName("UTF-32LE"));
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query(" + varbinaryLiteral + " FORMAT JSON ENCODING UTF32, 'lax $[1]')")))).matches("VALUES VARCHAR '\"b\"'");
        String finalVarbinaryLiteral = varbinaryLiteral;
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT json_query(" + finalVarbinaryLiteral + " FORMAT JSON ENCODING UTF8, 'lax $[1]' ERROR ON ERROR)")).hasMessage("conversion to JSON failed: ");
    }

    @Test
    public void testInputConversionError() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[...', 'lax $[1]')")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[...', 'lax $[1]' NULL ON ERROR)")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[...', 'lax $[1]' EMPTY ARRAY ON ERROR)")))).matches("VALUES VARCHAR '[]'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[...', 'lax $[1]' EMPTY OBJECT ON ERROR)")))).matches("VALUES VARCHAR '{}'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_query('[...', 'lax $[1]' ERROR ON ERROR)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
    }

    @Test
    public void testPassingClause() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $number + 1' PASSING 2 AS number)")).hasMessage("line 1:38: no value passed for parameter number. Try quoting \"number\" in the PASSING clause to match case");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $number + 1' PASSING 5 AS \"number\")")))).matches("VALUES VARCHAR '6'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $array[0]' PASSING '[1, 2, 3]' FORMAT JSON AS \"array\")")))).matches("VALUES VARCHAR '1'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $array[0]' PASSING '[...' FORMAT JSON AS \"array\")")))).matches("VALUES cast(null AS varchar)");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $array[0]' PASSING '[...' FORMAT JSON AS \"array\" ERROR ON ERROR)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[$number]' PASSING 5 AS \"number\")")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $parameter' PASSING DATE '2001-01-31' AS \"parameter\")")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $parameter' PASSING INTERVAL '2' DAY AS \"parameter\")")))).matches("VALUES cast('\"2 00:00:00.000\"' AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $parameter' PASSING UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59' AS \"parameter\")")))).matches("VALUES cast('\"12151fd2-7586-11e9-8f9e-2a86e4085a59\"' AS varchar)");
    }

    @Test
    public void testOutput() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax 1')")))).matches("VALUES VARCHAR '1'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax true' RETURNING varchar FORMAT JSON)")))).matches("VALUES VARCHAR 'true'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax null' RETURNING varchar FORMAT JSON)")))).matches("VALUES VARCHAR 'null'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[1]' RETURNING char(10))")))).matches("VALUES cast('\"b\"' AS char(10))");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax \"text too long\"' RETURNING char(10))")))).matches("VALUES cast('\"text too ' AS char(10))");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax 1' RETURNING tinyint)")).hasMessage("line 1:8: Cannot output JSON value as tinyint using formatting JSON");
        String output = "[\"a\",\"b\",\"c\"]";
        byte[] bytes = output.getBytes(StandardCharsets.UTF_8);
        String varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $' RETURNING varbinary)")))).matches("VALUES " + varbinaryLiteral);
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $' RETURNING varbinary FORMAT JSON)")))).matches("VALUES " + varbinaryLiteral);
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $' RETURNING varbinary FORMAT JSON ENCODING UTF8)")))).matches("VALUES " + varbinaryLiteral);
        bytes = output.getBytes(StandardCharsets.UTF_16LE);
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $' RETURNING varbinary FORMAT JSON ENCODING UTF16)")))).matches("VALUES " + varbinaryLiteral);
        bytes = output.getBytes(Charset.forName("UTF_32LE"));
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $' RETURNING varbinary FORMAT JSON ENCODING UTF32)")))).matches("VALUES " + varbinaryLiteral);
    }

    @Test
    public void testWrapperBehavior() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[0 to 1]')")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[0 to 1]' WITH CONDITIONAL ARRAY WRAPPER)")))).matches("VALUES cast('[\"a\",\"b\"]' AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[0]' WITH CONDITIONAL ARRAY WRAPPER)")))).matches("VALUES cast('[\"a\"]' AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $' WITH CONDITIONAL ARRAY WRAPPER)")))).matches("VALUES cast('[\"a\",\"b\",\"c\"]' AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('{\"key\" : 1}', 'lax $' WITH CONDITIONAL ARRAY WRAPPER)")))).matches("VALUES cast('{\"key\":1}' AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[0 to 1]' WITH UNCONDITIONAL ARRAY WRAPPER)")))).matches("VALUES cast('[\"a\",\"b\"]' AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $[0]' WITH UNCONDITIONAL ARRAY WRAPPER)")))).matches("VALUES cast('[\"a\"]' AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $' WITH UNCONDITIONAL ARRAY WRAPPER)")))).matches("VALUES cast('[[\"a\",\"b\",\"c\"]]' AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('{\"key\" : 1}', 'lax $' WITH UNCONDITIONAL ARRAY WRAPPER)")))).matches("VALUES cast('[{\"key\":1}]' AS varchar)");
    }

    @Test
    public void testQuotesBehavior() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax \"some scalar text value\"')")))).matches("VALUES cast('\"some scalar text value\"' AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax \"some scalar text value\"' KEEP QUOTES ON SCALAR STRING)")))).matches("VALUES cast('\"some scalar text value\"' AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax \"some scalar text value\"' OMIT QUOTES ON SCALAR STRING)")))).matches("VALUES cast('some scalar text value' AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $' OMIT QUOTES ON SCALAR STRING)")))).matches("VALUES cast('[\"a\",\"b\",\"c\"]' AS varchar)");
    }

    @Test
    public void testIncorrectPath() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'certainly not a valid path')")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:39: mismatched input 'certainly' expecting {'lax', 'strict'}");
    }

    @Test
    public void testNullInput() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query(null, 'lax $')")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $var' PASSING null AS \"var\")")))).matches("VALUES cast('null' AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query('[\"a\", \"b\", \"c\"]', 'lax $var' PASSING null FORMAT JSON AS \"var\" EMPTY ARRAY ON EMPTY)")))).matches("VALUES cast('[]' AS  varchar)");
    }

    @Test
    public void testDescendantMemberAccessor() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_query(\n                '{\"a\" : {\"b\" : 1}, \"c\" :  [true, {\"c\" : {\"c\" : null}}]}',\n                'lax $..c'\n                WITH ARRAY WRAPPER)\n")))).matches("VALUES cast('[[true,{\"c\":{\"c\":null}}],{\"c\":null},null]'AS varchar)\n");
    }
}

