/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.io.BaseEncoding;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestJsonValueFunction {
    private static final String INPUT = "[\"a\", \"b\", \"c\"]";
    private static final String INCORRECT_INPUT = "[...";
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testJsonValue() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $[1]')")))).matches("VALUES VARCHAR 'b'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'strict $[1]')")))).matches("VALUES VARCHAR 'b'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $[2 to 100]')")))).matches("VALUES VARCHAR 'c'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'strict $[100]')")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'strict $[100]' NULL ON ERROR)")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'strict $[100]' DEFAULT 'x' ON ERROR)")))).matches("VALUES VARCHAR 'x'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'strict $[100]' ERROR ON ERROR)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PATH_EVALUATION_ERROR}).hasMessage("path evaluation failed: structural error: invalid array subscript: [100, 100] for array of size 3");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $[100]')")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $[100]' NULL ON EMPTY)")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $[100]' DEFAULT 'x' ON EMPTY)")))).matches("VALUES VARCHAR 'x'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $[100]' ERROR ON EMPTY)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_VALUE_RESULT_ERROR}).hasMessage("cannot extract SQL scalar from JSON: JSON path found no items");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $[0 to 2]')")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $[0 to 2]' NULL ON ERROR)")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $[0 to 2]' DEFAULT 'x' ON ERROR)")))).matches("VALUES VARCHAR 'x'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $[0 to 2]' ERROR ON ERROR)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_VALUE_RESULT_ERROR}).hasMessage("cannot extract SQL scalar from JSON: JSON path found multiple items");
    }

    @Test
    public void testInputFormat() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $[1]')")))).matches("VALUES VARCHAR 'b'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]' FORMAT JSON, 'lax $[1]')")))).matches("VALUES VARCHAR 'b'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]' FORMAT JSON ENCODING UTF8, 'lax $[1]')")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:19: Cannot read input of type varchar(15) as JSON using formatting JSON ENCODING UTF8");
        byte[] bytes = INPUT.getBytes(StandardCharsets.UTF_8);
        String varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value(" + varbinaryLiteral + ", 'lax $[1]')")))).matches("VALUES VARCHAR 'b'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value(" + varbinaryLiteral + " FORMAT JSON, 'lax $[1]')")))).matches("VALUES VARCHAR 'b'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value(" + varbinaryLiteral + " FORMAT JSON ENCODING UTF8, 'lax $[1]')")))).matches("VALUES VARCHAR 'b'");
        bytes = INPUT.getBytes(StandardCharsets.UTF_16LE);
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value(" + varbinaryLiteral + " FORMAT JSON ENCODING UTF16, 'lax $[1]')")))).matches("VALUES VARCHAR 'b'");
        bytes = INPUT.getBytes(Charset.forName("UTF-32LE"));
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value(" + varbinaryLiteral + " FORMAT JSON ENCODING UTF32, 'lax $[1]')")))).matches("VALUES VARCHAR 'b'");
        String finalVarbinaryLiteral = varbinaryLiteral;
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_value(" + finalVarbinaryLiteral + " FORMAT JSON ENCODING UTF8, 'lax $[1]' ERROR ON ERROR)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
    }

    @Test
    public void testInputConversionError() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[...', 'lax $[1]')")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[...', 'lax $[1]' NULL ON ERROR)")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[...', 'lax $[1]' DEFAULT 'x' ON ERROR)")))).matches("VALUES VARCHAR 'x'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_value('[...', 'lax $[1]' ERROR ON ERROR)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
    }

    @Test
    public void testPassingClause() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $number + 1' PASSING 2 AS number)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PATH}).hasMessage("line 1:38: no value passed for parameter number. Try quoting \"number\" in the PASSING clause to match case");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $number + 1' PASSING 5 AS \"number\")")))).matches("VALUES VARCHAR '6'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $array[0]' PASSING '[1, 2, 3]' FORMAT JSON AS \"array\")")))).matches("VALUES VARCHAR '1'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $array[0]' PASSING '[...' FORMAT JSON AS \"array\")")))).matches("VALUES cast(null AS varchar)");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $array[0]' PASSING '[...' FORMAT JSON AS \"array\" ERROR ON ERROR)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_INPUT_CONVERSION_ERROR}).hasMessage("conversion to JSON failed: ");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $[$number]' PASSING 5 AS \"number\")")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $parameter' PASSING INTERVAL '2' DAY AS \"parameter\")")))).matches("VALUES cast('2 00:00:00.000' AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $parameter' PASSING UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59' AS \"parameter\")")))).matches("VALUES cast('12151fd2-7586-11e9-8f9e-2a86e4085a59' AS varchar)");
    }

    @Test
    public void testReturnedType() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax 1')")))).matches("VALUES VARCHAR '1'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax true')")))).matches("VALUES VARCHAR 'true'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax null')")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $[1]' RETURNING char(10))")))).matches("VALUES cast('b' AS char(10))");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax 1000' RETURNING tinyint)")))).matches("VALUES cast(null AS tinyint)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax 1000' RETURNING tinyint DEFAULT TINYINT '-1' ON ERROR)")))).matches("VALUES TINYINT '-1'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax 1000000000000 * 1000000000000' RETURNING bigint DEFAULT TINYINT '-1' ON ERROR)")))).matches("VALUES BIGINT '-1'");
    }

    @Test
    public void testPathResultNonScalar() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $')")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $' NULL ON ERROR)")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $' DEFAULT 'x' ON ERROR)")))).matches("VALUES VARCHAR 'x'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $' ERROR ON ERROR)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.JSON_VALUE_RESULT_ERROR}).hasMessage("cannot extract SQL scalar from JSON: JSON path found an item that cannot be converted to an SQL value");
    }

    @Test
    public void testIncorrectPath() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'certainly not a valid path')")).hasMessage("line 1:39: mismatched input 'certainly' expecting {'lax', 'strict'}");
    }

    @Test
    public void testNullInput() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value(null, 'lax $')")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $var' PASSING null AS \"var\")")))).matches("VALUES cast(null AS varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $var' PASSING null FORMAT JSON AS \"var\" DEFAULT 'was empty...' ON EMPTY)")))).matches("VALUES cast('was empty...' AS  varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax 1' DEFAULT null ON EMPTY DEFAULT null ON ERROR)")))).matches("VALUES cast(1 AS  varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax $[100]' DEFAULT null ON EMPTY)")))).matches("VALUES cast(null AS  varchar)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_value('[\"a\", \"b\", \"c\"]', 'lax 1 + $[0]' DEFAULT null ON ERROR)")))).matches("VALUES cast(null AS  varchar)");
    }
}

