/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestLateral {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testUncorrelatedLateral() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM LATERAL (VALUES 1, 2, 3)")))).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM LATERAL (VALUES 1), (VALUES 'a')")))).matches("VALUES (1, 'a')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM LATERAL (VALUES 1) CROSS JOIN (VALUES 'a')")))).matches("VALUES (1, 'a')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM LATERAL (VALUES 1) t(a)")))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1) t(a), LATERAL (SELECT * FROM LATERAL (SELECT a))")))).matches("VALUES (1, 1)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (SELECT * FROM LATERAL (SELECT a)) FROM (VALUES 1) t(a)")))).matches("VALUES 1");
    }

    @Test
    public void testNotInScope() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1) t(a), (SELECT * FROM LATERAL (SELECT a))")).hasMessage("line 1:63: Column 'a' cannot be resolved");
    }
}

