/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type.setdigest;

import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.trino.spi.block.SqlMap;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.type.setdigest.SetDigest;
import io.trino.type.setdigest.SetDigestFunctions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSetDigest {
    @Test
    public void testIntersectionCardinality() {
        TestSetDigest.testIntersectionCardinality(8192, 2048, 8192, 2048);
    }

    @Test
    public void testUnevenIntersectionCardinality() {
        TestSetDigest.testIntersectionCardinality(2048, 2048, 8192, 2048);
    }

    private static void testIntersectionCardinality(int maxHashes1, int numBuckets1, int maxHashes2, int numBuckets2) {
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        Random rand = new Random(0L);
        for (int i = 10; i < 100000000; i *= 10) {
            sizes.add(rand.nextInt(i) + 10);
        }
        Iterator iterator = sizes.iterator();
        while (iterator.hasNext()) {
            int size = (Integer)iterator.next();
            int expectedCardinality = 0;
            SetDigest digest1 = new SetDigest(maxHashes1, numBuckets1);
            SetDigest digest2 = new SetDigest(maxHashes2, numBuckets2);
            for (int j = 0; j < size; ++j) {
                int added = 0;
                long value = rand.nextLong();
                if (rand.nextDouble() < 0.5) {
                    digest1.add(value);
                    ++added;
                }
                if (rand.nextDouble() < 0.5) {
                    digest2.add(value);
                    ++added;
                }
                if (added != 2) continue;
                ++expectedCardinality;
            }
            long estimatedCardinality = SetDigestFunctions.intersectionCardinality((Slice)digest1.serialize(), (Slice)digest2.serialize());
            ((AbstractBooleanAssert)Assertions.assertThat(((double)Math.abs((long)expectedCardinality - estimatedCardinality) / (double)expectedCardinality < 0.1 ? 1 : 0) != 0).describedAs(String.format("Expected intersection cardinality %d +/- 10%%, got %d, for set of size %d", expectedCardinality, estimatedCardinality, size), new Object[0])).isTrue();
        }
    }

    @Test
    public void testHashCounts() {
        SetDigest digest1 = new SetDigest();
        digest1.add(0L);
        digest1.add(0L);
        digest1.add(1L);
        SetDigest digest2 = new SetDigest();
        digest2.add(0L);
        digest2.add(0L);
        digest2.add(2L);
        digest2.add(2L);
        MapType mapType = new MapType((Type)BigintType.BIGINT, (Type)SmallintType.SMALLINT, new TypeOperators());
        SqlMap sqlMap = SetDigestFunctions.hashCounts((Type)mapType, (Slice)digest1.serialize());
        HashSet<Short> blockValues = new HashSet<Short>();
        for (int i = 0; i < sqlMap.getSize(); ++i) {
            blockValues.add(sqlMap.getRawValueBlock().getShort(sqlMap.getRawOffset() + i, 0));
        }
        ImmutableSet expected = ImmutableSet.of((Object)1, (Object)2);
        Assertions.assertThat(blockValues).isEqualTo((Object)expected);
        digest1.mergeWith(digest2);
        sqlMap = SetDigestFunctions.hashCounts((Type)mapType, (Slice)digest1.serialize());
        expected = ImmutableSet.of((Object)1, (Object)2, (Object)4);
        blockValues = new HashSet();
        for (int i = 0; i < sqlMap.getSize(); ++i) {
            blockValues.add(sqlMap.getRawValueBlock().getShort(sqlMap.getRawOffset() + i, 0));
        }
        Assertions.assertThat(blockValues).isEqualTo((Object)expected);
    }

    @Test
    public void testSmallLargeIntersections() {
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        Random rand = new Random(0L);
        for (int i = 1000; i < 1000000; i *= 10) {
            sizes.add(rand.nextInt(i) + 10);
        }
        Iterator iterator = sizes.iterator();
        while (iterator.hasNext()) {
            int n;
            int size1 = (Integer)iterator.next();
            SetDigest digest1 = new SetDigest(8192, 2048);
            HashMap<SetDigest, Integer> smallerSets = new HashMap<SetDigest, Integer>();
            Iterator<Object> iterator2 = sizes.iterator();
            while (iterator2.hasNext() && (n = ((Integer)iterator2.next()).intValue()) < size1) {
                for (int overlap = 2; overlap <= 10; overlap += 2) {
                    int expectedCardinality = 0;
                    SetDigest digest2 = new SetDigest(8192, 2048);
                    for (int j = 0; j < size1; ++j) {
                        long value = rand.nextLong();
                        digest1.add(value);
                        if (!(rand.nextDouble() < (double)n / (double)size1)) continue;
                        if (rand.nextDouble() * 10.0 < (double)overlap) {
                            digest2.add(value);
                            ++expectedCardinality;
                            continue;
                        }
                        digest2.add(rand.nextLong());
                    }
                    smallerSets.put(digest2, expectedCardinality);
                }
            }
            for (Map.Entry entry : smallerSets.entrySet()) {
                double size22;
                SetDigest digest2 = (SetDigest)entry.getKey();
                long estIntersectionCardinality = SetDigestFunctions.intersectionCardinality((Slice)digest1.serialize(), (Slice)digest2.serialize());
                Assertions.assertThat(((double)estIntersectionCardinality <= (size22 = (double)digest2.cardinality()) ? 1 : 0) != 0).isTrue();
                int expectedCardinality = (Integer)entry.getValue();
                Assertions.assertThat(((double)Math.abs((long)expectedCardinality - estIntersectionCardinality) / (double)size1 < 0.05 ? 1 : 0) != 0).isTrue();
            }
        }
    }
}

