/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import io.airlift.log.Logger;
import io.trino.metadata.FunctionBinding;
import io.trino.operator.ParametricImplementation;
import io.trino.operator.ParametricImplementationsGroup;
import io.trino.operator.aggregation.AggregationHeader;
import io.trino.operator.aggregation.ParametricAggregation;
import io.trino.operator.aggregation.ParametricAggregationImplementation;
import io.trino.operator.aggregation.TypeSignatureMapping;
import io.trino.operator.aggregation.state.InOutStateSerializer;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.operator.annotations.FunctionsParserHelper;
import io.trino.operator.annotations.ImplementationDependency;
import io.trino.operator.annotations.TypeImplementationDependency;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.AccumulatorStateMetadata;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationImplementation;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionDependency;
import io.trino.spi.function.InOut;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.RemoveInputFunction;
import io.trino.spi.function.Signature;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class AggregationFromAnnotationsParser {
    private static final Logger log = Logger.get(AggregationFromAnnotationsParser.class);

    private AggregationFromAnnotationsParser() {
    }

    public static List<ParametricAggregation> parseFunctionDefinitions(Class<?> aggregationDefinition) {
        AggregationFunction aggregationAnnotation = aggregationDefinition.getAnnotation(AggregationFunction.class);
        Objects.requireNonNull(aggregationAnnotation, "aggregationAnnotation is null");
        ImmutableList.Builder functions = ImmutableList.builder();
        List<AccumulatorStateDetails<?>> stateDetails = AggregationFromAnnotationsParser.getStateDetails(aggregationDefinition);
        Optional<Method> combineFunction = AggregationFromAnnotationsParser.getCombineFunction(aggregationDefinition, stateDetails);
        for (Method outputFunction : AggregationFromAnnotationsParser.getOutputFunctions(aggregationDefinition, stateDetails)) {
            AggregationHeader header = AggregationFromAnnotationsParser.parseHeader(aggregationDefinition, outputFunction);
            if (header.isDecomposable()) {
                Preconditions.checkArgument((boolean)combineFunction.isPresent(), (String)"Decomposable method %s does not have a combine method", (Object)header.getName());
            } else if (combineFunction.isPresent()) {
                log.warn("Aggregation function %s is not decomposable, but has combine method", new Object[]{header.getName()});
            }
            ArrayList<ParametricAggregationImplementation> exactImplementations = new ArrayList<ParametricAggregationImplementation>();
            ArrayList<ParametricAggregationImplementation> nonExactImplementations = new ArrayList<ParametricAggregationImplementation>();
            for (Method inputFunction : AggregationFromAnnotationsParser.getInputFunctions(aggregationDefinition, stateDetails)) {
                Optional<Method> removeInputFunction;
                ParametricAggregationImplementation implementation = ParametricAggregationImplementation.Parser.parseImplementation(aggregationDefinition, stateDetails, inputFunction, removeInputFunction = AggregationFromAnnotationsParser.getRemoveInputFunction(aggregationDefinition, inputFunction), outputFunction, combineFunction.filter(function -> header.isDecomposable()));
                if (AggregationFromAnnotationsParser.isGenericOrCalculated(implementation.getSignature())) {
                    exactImplementations.add(implementation);
                    continue;
                }
                nonExactImplementations.add(implementation);
            }
            functions.addAll(AggregationFromAnnotationsParser.buildFunctions(header, stateDetails, exactImplementations, nonExactImplementations));
        }
        return functions.build();
    }

    private static List<ParametricAggregation> buildFunctions(AggregationHeader header, List<AccumulatorStateDetails<?>> stateDetails, List<ParametricAggregationImplementation> exactImplementations, List<ParametricAggregationImplementation> nonExactImplementations) {
        ImmutableList.Builder functions = ImmutableList.builder();
        for (ParametricAggregationImplementation exactImplementation : exactImplementations) {
            functions.add((Object)new ParametricAggregation(exactImplementation.getSignature(), header, stateDetails, ParametricImplementationsGroup.of((ParametricImplementation[])new ParametricAggregationImplementation[]{exactImplementation})));
        }
        if (!nonExactImplementations.isEmpty()) {
            ParametricImplementationsGroup.Builder implementationsBuilder = ParametricImplementationsGroup.builder();
            nonExactImplementations.forEach(implementationsBuilder::addImplementation);
            ParametricImplementationsGroup<ParametricAggregationImplementation> implementations = implementationsBuilder.build();
            functions.add((Object)new ParametricAggregation(implementations.getSignature(), header, stateDetails, implementations));
        }
        return functions.build();
    }

    private static boolean isGenericOrCalculated(Signature signature) {
        return signature.getTypeVariableConstraints().isEmpty() && signature.getArgumentTypes().stream().noneMatch(TypeSignature::isCalculated) && !signature.getReturnType().isCalculated();
    }

    private static AggregationHeader parseHeader(AnnotatedElement aggregationDefinition, AnnotatedElement outputFunction) {
        AggregationFunction aggregationAnnotation = aggregationDefinition.getAnnotation(AggregationFunction.class);
        Objects.requireNonNull(aggregationAnnotation, "aggregationAnnotation is null");
        return new AggregationHeader(AggregationFromAnnotationsParser.getName(aggregationAnnotation, outputFunction), AggregationFromAnnotationsParser.getAliases(aggregationAnnotation, outputFunction), FunctionsParserHelper.parseDescription(aggregationDefinition, outputFunction), aggregationAnnotation.decomposable(), aggregationAnnotation.isOrderSensitive(), aggregationAnnotation.hidden(), ((Deprecated[])aggregationDefinition.getAnnotationsByType(Deprecated.class)).length > 0);
    }

    private static String getName(AggregationFunction aggregationAnnotation, AnnotatedElement outputFunction) {
        AggregationFunction annotation = outputFunction.getAnnotation(AggregationFunction.class);
        if (annotation != null && !annotation.value().isEmpty()) {
            return Strings.emptyToNull((String)annotation.value());
        }
        return Strings.emptyToNull((String)aggregationAnnotation.value());
    }

    private static Set<String> getAliases(AggregationFunction aggregationAnnotation, AnnotatedElement outputFunction) {
        AggregationFunction annotation = outputFunction.getAnnotation(AggregationFunction.class);
        if (annotation != null && annotation.alias().length > 0) {
            return ImmutableSet.copyOf((Object[])annotation.alias());
        }
        return ImmutableSet.copyOf((Object[])aggregationAnnotation.alias());
    }

    private static Optional<Method> getCombineFunction(Class<?> clazz, List<AccumulatorStateDetails<?>> stateDetails) {
        List<Method> combineFunctions = FunctionsParserHelper.findPublicStaticMethodsWithAnnotation(clazz, CombineFunction.class);
        if (combineFunctions.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkArgument((combineFunctions.size() == 1 ? 1 : 0) != 0, (String)"There must be only one @CombineFunction in class %s", (Object)clazz.toGenericString());
        Method combineFunction = (Method)Iterables.getOnlyElement(combineFunctions);
        List<Class<?>> parameterTypes = AggregationFromAnnotationsParser.getNonDependencyParameterTypes(combineFunction);
        List expectedParameterTypes = (List)Stream.concat(stateDetails.stream(), stateDetails.stream()).map(AccumulatorStateDetails::getStateClass).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((boolean)parameterTypes.equals(expectedParameterTypes), (String)"Expected combine function non-dependency parameters to be %s: %s", (Object)expectedParameterTypes, (Object)combineFunction);
        if (stateDetails.size() > 1) {
            List<List<Annotation>> parameterAnnotations = AggregationFromAnnotationsParser.getNonDependencyParameterAnnotations(combineFunction);
            ArrayList<AccumulatorStateDetails<AccumulatorState>> actualStateDetails = new ArrayList<AccumulatorStateDetails<AccumulatorState>>();
            for (int parameterIndex = 0; parameterIndex < parameterTypes.size(); ++parameterIndex) {
                actualStateDetails.add(AggregationFromAnnotationsParser.toAccumulatorStateDetails(parameterTypes.get(parameterIndex).asSubclass(AccumulatorState.class), parameterAnnotations.get(parameterIndex), combineFunction, true));
            }
            ImmutableList expectedStateDetails = ImmutableList.builder().addAll(stateDetails).addAll(stateDetails).build();
            Preconditions.checkArgument((boolean)actualStateDetails.equals(expectedStateDetails), (String)"Expected combine function to have state parameters %s, but has %s", stateDetails, (Object)expectedStateDetails);
        }
        return Optional.of(combineFunction);
    }

    private static List<Method> getOutputFunctions(Class<?> clazz, List<AccumulatorStateDetails<?>> stateDetails) {
        List<Method> outputFunctions = FunctionsParserHelper.findPublicStaticMethodsWithAnnotation(clazz, OutputFunction.class);
        for (Method outputFunction : outputFunctions) {
            List<Class<?>> parameterTypes = AggregationFromAnnotationsParser.getNonDependencyParameterTypes(outputFunction);
            ImmutableList expectedParameterTypes = ImmutableList.builder().addAll((Iterable)stateDetails.stream().map(AccumulatorStateDetails::getStateClass).collect(ImmutableList.toImmutableList())).add(BlockBuilder.class).build();
            Preconditions.checkArgument((boolean)parameterTypes.equals(expectedParameterTypes), (String)"Expected output function non-dependency parameters to be %s: %s", expectedParameterTypes.stream().map(Class::getSimpleName).collect(ImmutableList.toImmutableList()), (Object)outputFunction);
            if (stateDetails.size() <= 1) continue;
            List<List<Annotation>> parameterAnnotations = AggregationFromAnnotationsParser.getNonDependencyParameterAnnotations(outputFunction);
            ArrayList<AccumulatorStateDetails<AccumulatorState>> actualStateDetails = new ArrayList<AccumulatorStateDetails<AccumulatorState>>();
            for (int parameterIndex = 0; parameterIndex < stateDetails.size(); ++parameterIndex) {
                actualStateDetails.add(AggregationFromAnnotationsParser.toAccumulatorStateDetails(parameterTypes.get(parameterIndex).asSubclass(AccumulatorState.class), parameterAnnotations.get(parameterIndex), outputFunction, true));
            }
            Preconditions.checkArgument((boolean)actualStateDetails.equals(stateDetails), (String)"Expected output function to have state parameters %s, but has %s", stateDetails, actualStateDetails);
        }
        Preconditions.checkArgument((!outputFunctions.isEmpty() ? 1 : 0) != 0, (Object)"Aggregation has no output functions");
        return outputFunctions;
    }

    private static List<Method> getInputFunctions(Class<?> clazz, List<AccumulatorStateDetails<?>> stateDetails) {
        List<Method> inputFunctions = FunctionsParserHelper.findPublicStaticMethodsWithAnnotation(clazz, InputFunction.class);
        for (Method inputFunction : inputFunctions) {
            List<Class<?>> parameterTypes = AggregationFromAnnotationsParser.getNonDependencyParameterTypes(inputFunction).subList(0, stateDetails.size());
            List expectedParameterTypes = (List)stateDetails.stream().map(AccumulatorStateDetails::getStateClass).collect(ImmutableList.toImmutableList());
            Preconditions.checkArgument((boolean)parameterTypes.equals(expectedParameterTypes), (String)"Expected input function non-dependency parameters to begin with state types %s: %s", expectedParameterTypes.stream().map(Class::getSimpleName).collect(ImmutableList.toImmutableList()), (Object)inputFunction);
            if (stateDetails.size() <= 1) continue;
            List<List<Annotation>> parameterAnnotations = AggregationFromAnnotationsParser.getNonDependencyParameterAnnotations(inputFunction).subList(0, stateDetails.size());
            ArrayList<AccumulatorStateDetails<AccumulatorState>> actualStateDetails = new ArrayList<AccumulatorStateDetails<AccumulatorState>>();
            for (int parameterIndex = 0; parameterIndex < stateDetails.size(); ++parameterIndex) {
                actualStateDetails.add(AggregationFromAnnotationsParser.toAccumulatorStateDetails(parameterTypes.get(parameterIndex).asSubclass(AccumulatorState.class), parameterAnnotations.get(parameterIndex), inputFunction, false));
            }
            Preconditions.checkArgument((boolean)actualStateDetails.equals(stateDetails), (String)"Expected input function to have state parameters %s, but has %s", stateDetails, actualStateDetails);
        }
        Preconditions.checkArgument((!inputFunctions.isEmpty() ? 1 : 0) != 0, (Object)"Aggregation has no input functions");
        return inputFunctions;
    }

    private static IntStream getNonDependencyParameters(Method function) {
        Annotation[][] parameterAnnotations = function.getParameterAnnotations();
        return IntStream.range(0, function.getParameterCount()).filter(i -> Arrays.stream(parameterAnnotations[i]).noneMatch(TypeParameter.class::isInstance)).filter(i -> Arrays.stream(parameterAnnotations[i]).noneMatch(LiteralParameter.class::isInstance)).filter(i -> Arrays.stream(parameterAnnotations[i]).noneMatch(OperatorDependency.class::isInstance)).filter(i -> Arrays.stream(parameterAnnotations[i]).noneMatch(FunctionDependency.class::isInstance));
    }

    private static List<Class<?>> getNonDependencyParameterTypes(Method function) {
        Class[] parameterTypes = function.getParameterTypes();
        return (List)AggregationFromAnnotationsParser.getNonDependencyParameters(function).mapToObj(index -> parameterTypes[index]).collect(ImmutableList.toImmutableList());
    }

    private static List<List<Annotation>> getNonDependencyParameterAnnotations(Method function) {
        Annotation[][] parameterAnnotations = function.getParameterAnnotations();
        return (List)AggregationFromAnnotationsParser.getNonDependencyParameters(function).mapToObj(index -> ImmutableList.copyOf((Object[])parameterAnnotations[index])).collect(ImmutableList.toImmutableList());
    }

    private static Optional<Method> getRemoveInputFunction(Class<?> clazz, Method inputFunction) {
        return (Optional)FunctionsParserHelper.findPublicStaticMethodsWithAnnotation(clazz, RemoveInputFunction.class).stream().filter(method -> Arrays.equals(method.getParameterTypes(), inputFunction.getParameterTypes())).filter(method -> Arrays.deepEquals((Object[])method.getParameterAnnotations(), (Object[])inputFunction.getParameterAnnotations())).collect(MoreCollectors.toOptional());
    }

    private static List<AccumulatorStateDetails<?>> getStateDetails(Class<?> clazz) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Method inputFunction : FunctionsParserHelper.findPublicStaticMethodsWithAnnotation(clazz, InputFunction.class)) {
            List<Class<?>> parameterTypes = AggregationFromAnnotationsParser.getNonDependencyParameterTypes(inputFunction);
            Preconditions.checkArgument((!parameterTypes.isEmpty() ? 1 : 0) != 0, (Object)"Input function has no parameters");
            List<List<Annotation>> parameterAnnotations = AggregationFromAnnotationsParser.getNonDependencyParameterAnnotations(inputFunction);
            ImmutableList.Builder stateParameters = ImmutableList.builder();
            for (int parameterIndex = 0; parameterIndex < parameterTypes.size(); ++parameterIndex) {
                Class<?> parameterType = parameterTypes.get(parameterIndex);
                if (!AccumulatorState.class.isAssignableFrom(parameterType)) continue;
                stateParameters.add(AggregationFromAnnotationsParser.toAccumulatorStateDetails(parameterType.asSubclass(AccumulatorState.class), parameterAnnotations.get(parameterIndex), inputFunction, false));
            }
            ImmutableList states = stateParameters.build();
            Preconditions.checkArgument((!states.isEmpty() ? 1 : 0) != 0, (Object)"Input function must have at least one state parameter");
            builder.add((Object)states);
        }
        ImmutableSet functionStateClasses = builder.build();
        Preconditions.checkArgument((!functionStateClasses.isEmpty() ? 1 : 0) != 0, (Object)"No input functions found");
        Preconditions.checkArgument((functionStateClasses.size() == 1 ? 1 : 0) != 0, (String)"There must be exactly one set of @AccumulatorState in class %s", (Object)clazz.toGenericString());
        return (List)Iterables.getOnlyElement((Iterable)functionStateClasses);
    }

    private static <T extends AccumulatorState> AccumulatorStateDetails<T> toAccumulatorStateDetails(Class<T> stateClass, List<Annotation> parameterAnnotations, Method method, boolean requireAnnotation) {
        Optional<AggregationState> state = parameterAnnotations.stream().filter(AggregationState.class::isInstance).map(AggregationState.class::cast).findFirst();
        if (requireAnnotation) {
            Preconditions.checkArgument((boolean)state.isPresent(), (String)"AggregationState must be present on AccumulatorState parameters: %s", (Object)method);
        }
        List declaredTypeParameters = (List)state.map(AggregationState::value).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        return AggregationFromAnnotationsParser.toAccumulatorStateDetails(stateClass, declaredTypeParameters);
    }

    @VisibleForTesting
    public static <T extends AccumulatorState> AccumulatorStateDetails<T> toAccumulatorStateDetails(Class<T> stateClass, List<String> declaredTypeParameters) {
        BiFunction factoryGenerator;
        TypeSignature serializedType;
        BiFunction<FunctionBinding, FunctionDependencies, AccumulatorStateSerializer<Object>> serializerGenerator;
        StateMetadata metadata = new StateMetadata(StateCompiler.getMetadataAnnotation(stateClass));
        TypeSignatureMapping typeParameterMapping = AggregationFromAnnotationsParser.getTypeParameterMapping(stateClass, declaredTypeParameters, metadata);
        if (stateClass.equals(InOut.class)) {
            String typeVariable = typeParameterMapping.mapTypeSignature(new TypeSignature("T", new TypeSignatureParameter[0])).toString();
            AccumulatorStateDetails<InOut> stateDetails = AggregationFromAnnotationsParser.getInOutAccumulatorStateDetails(typeVariable);
            return stateDetails;
        }
        ArrayList<ImplementationDependency> allDependencies = new ArrayList<ImplementationDependency>();
        if (metadata.getStateSerializerClass().isPresent()) {
            Constructor<?> constructor = AggregationFromAnnotationsParser.getOnlyConstructor(metadata.getStateSerializerClass().get());
            List<ImplementationDependency> dependencies = AggregationFromAnnotationsParser.parseImplementationDependencies(typeParameterMapping, constructor);
            serializerGenerator = new TypedFactory<AccumulatorStateSerializer>(constructor, dependencies);
            allDependencies.addAll(dependencies);
        } else {
            serializerGenerator = (functionBinding, functionDependencies) -> StateCompiler.generateStateSerializer(stateClass);
        }
        if (metadata.getSerializedType().isPresent()) {
            serializedType = typeParameterMapping.mapTypeSignature(TypeSignatureTranslator.parseTypeSignature(metadata.getSerializedType().get(), (Set<String>)ImmutableSet.of()));
        } else {
            Preconditions.checkArgument((boolean)allDependencies.isEmpty(), (String)"serializedType must be set for state %s with dependencies", stateClass);
            AccumulatorStateSerializer serializer = serializerGenerator.apply(null, null);
            serializedType = serializer.getSerializedType().getTypeSignature();
            serializerGenerator = (functionBinding, functionDependencies) -> serializer;
        }
        if (metadata.getStateFactoryClass().isPresent()) {
            Constructor<?> constructor = AggregationFromAnnotationsParser.getOnlyConstructor(metadata.getStateFactoryClass().get());
            List<ImplementationDependency> dependencies = AggregationFromAnnotationsParser.parseImplementationDependencies(typeParameterMapping, constructor);
            factoryGenerator = new TypedFactory(constructor, dependencies);
            allDependencies.addAll(dependencies);
        } else {
            factoryGenerator = (functionBinding, functionDependencies) -> StateCompiler.generateStateFactory(stateClass);
        }
        return new AccumulatorStateDetails<T>(stateClass, declaredTypeParameters, serializedType, serializerGenerator, factoryGenerator, allDependencies);
    }

    private static Constructor<?> getOnlyConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Preconditions.checkArgument((constructors.length == 1 ? 1 : 0) != 0, (String)"Expected %s to have only one public constructor", (Object)clazz.getSimpleName());
        return constructors[0];
    }

    private static AccumulatorStateDetails<InOut> getInOutAccumulatorStateDetails(String typeVariable) {
        TypeSignature serializedType = TypeSignatureTranslator.parseTypeSignature(typeVariable, (Set<String>)ImmutableSet.of());
        return new AccumulatorStateDetails<InOut>(InOut.class, (List<String>)ImmutableList.of((Object)typeVariable), serializedType, (functionBinding, functionDependencies) -> new InOutStateSerializer(functionBinding.getTypeVariable(typeVariable)), (functionBinding, functionDependencies) -> StateCompiler.generateInOutStateFactory(functionBinding.getTypeVariable(typeVariable)), (List<ImplementationDependency>)ImmutableList.of((Object)new TypeImplementationDependency(TypeSignatureTranslator.parseTypeSignature(typeVariable, (Set<String>)ImmutableSet.of()))));
    }

    private static TypeSignatureMapping getTypeParameterMapping(Class<?> stateClass, List<String> declaredTypeParameters, StateMetadata metadata) {
        List<String> expectedTypeParameters = metadata.getTypeParameters();
        if (expectedTypeParameters.isEmpty()) {
            return new TypeSignatureMapping((Map<String, String>)ImmutableMap.of());
        }
        Preconditions.checkArgument((declaredTypeParameters.size() == expectedTypeParameters.size() ? 1 : 0) != 0, (String)"AggregationState %s requires %s type parameters", stateClass, (int)expectedTypeParameters.size());
        ImmutableMap.Builder mapping = ImmutableMap.builder();
        for (int parameterIndex = 0; parameterIndex < declaredTypeParameters.size(); ++parameterIndex) {
            String declaredTypeParameter = declaredTypeParameters.get(parameterIndex);
            String expectedTypeParameter = expectedTypeParameters.get(parameterIndex);
            mapping.put((Object)expectedTypeParameter, (Object)declaredTypeParameter);
        }
        return new TypeSignatureMapping((Map<String, String>)mapping.buildOrThrow());
    }

    private static List<ImplementationDependency> parseImplementationDependencies(TypeSignatureMapping typeSignatureMapping, Executable inputFunction) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter parameter : inputFunction.getParameters()) {
            ImplementationDependency.getImplementationDependencyAnnotation(parameter).ifPresent(annotation -> {
                ImplementationDependency.validateImplementationDependencyAnnotation(inputFunction, annotation, typeSignatureMapping.getTypeParameters(), (Collection<String>)ImmutableSet.of());
                ImplementationDependency dependency = ImplementationDependency.Factory.createDependency(annotation, (Set<String>)ImmutableSet.of(), parameter.getType());
                dependency = typeSignatureMapping.mapTypes(dependency);
                builder.add((Object)dependency);
            });
        }
        return builder.build();
    }

    public static class AccumulatorStateDetails<T extends AccumulatorState> {
        private final Class<T> stateClass;
        private final List<String> typeParameters;
        private final TypeSignature serializedType;
        private final BiFunction<FunctionBinding, FunctionDependencies, AccumulatorStateSerializer<T>> serializerGenerator;
        private final BiFunction<FunctionBinding, FunctionDependencies, AccumulatorStateFactory<T>> factoryGenerator;
        private final List<ImplementationDependency> dependencies;

        public AccumulatorStateDetails(Class<T> stateClass, List<String> typeParameters, TypeSignature serializedType, BiFunction<FunctionBinding, FunctionDependencies, AccumulatorStateSerializer<T>> serializerGenerator, BiFunction<FunctionBinding, FunctionDependencies, AccumulatorStateFactory<T>> factoryGenerator, List<ImplementationDependency> dependencies) {
            this.stateClass = Objects.requireNonNull(stateClass, "stateClass is null");
            this.typeParameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(typeParameters, "typeParameters is null"));
            this.serializedType = Objects.requireNonNull(serializedType, "serializedType is null");
            this.serializerGenerator = Objects.requireNonNull(serializerGenerator, "serializerGenerator is null");
            this.factoryGenerator = Objects.requireNonNull(factoryGenerator, "factoryGenerator is null");
            this.dependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(dependencies, "dependencies is null"));
        }

        public Class<T> getStateClass() {
            return this.stateClass;
        }

        public TypeSignature getSerializedType() {
            return this.serializedType;
        }

        public List<ImplementationDependency> getDependencies() {
            return this.dependencies;
        }

        public AggregationImplementation.AccumulatorStateDescriptor<T> createAccumulatorStateDescriptor(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
            return AggregationImplementation.AccumulatorStateDescriptor.builder(this.stateClass).serializer(this.serializerGenerator.apply(functionBinding, functionDependencies)).factory(this.factoryGenerator.apply(functionBinding, functionDependencies)).build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AccumulatorStateDetails that = (AccumulatorStateDetails)o;
            return Objects.equals(this.stateClass, that.stateClass) && Objects.equals(this.typeParameters, that.typeParameters);
        }

        public int hashCode() {
            return Objects.hash(this.stateClass, this.typeParameters);
        }
    }

    private static class StateMetadata {
        private final Optional<Class<? extends AccumulatorStateSerializer<?>>> stateSerializerClass;
        private final Optional<Class<? extends AccumulatorStateFactory<?>>> stateFactoryClass;
        private final List<String> typeParameters;
        private final Optional<String> serializedType;

        public StateMetadata(AccumulatorStateMetadata metadata) {
            if (metadata == null) {
                this.stateSerializerClass = Optional.empty();
                this.stateFactoryClass = Optional.empty();
                this.typeParameters = ImmutableList.of();
                this.serializedType = Optional.empty();
            } else {
                this.stateSerializerClass = Optional.of(metadata.stateSerializerClass()).filter(Predicate.not(AccumulatorStateSerializer.class::equals)).map(type -> type);
                this.stateFactoryClass = Optional.of(metadata.stateFactoryClass()).filter(Predicate.not(AccumulatorStateFactory.class::equals)).map(type -> type);
                this.typeParameters = ImmutableList.copyOf((Object[])metadata.typeParameters());
                this.serializedType = Optional.of(metadata.serializedType()).filter(Predicate.not(String::isEmpty));
            }
        }

        public Optional<Class<? extends AccumulatorStateSerializer<?>>> getStateSerializerClass() {
            return this.stateSerializerClass;
        }

        public Optional<Class<? extends AccumulatorStateFactory<?>>> getStateFactoryClass() {
            return this.stateFactoryClass;
        }

        public List<String> getTypeParameters() {
            return this.typeParameters;
        }

        public Optional<String> getSerializedType() {
            return this.serializedType;
        }
    }

    private static class TypedFactory<T>
    implements BiFunction<FunctionBinding, FunctionDependencies, T> {
        private final Constructor<T> constructor;
        private final List<ImplementationDependency> dependencies;

        public TypedFactory(Constructor<?> constructor, List<ImplementationDependency> dependencies) {
            this.constructor = constructor;
            this.dependencies = dependencies;
        }

        @Override
        public T apply(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
            List values = (List)this.dependencies.stream().map(dependency -> dependency.resolve(functionBinding, functionDependencies)).collect(ImmutableList.toImmutableList());
            try {
                return this.constructor.newInstance(values.toArray());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

