/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.SqlTypeBytecodeExpression;
import io.trino.util.CompilerUtils;
import io.trino.util.Failures;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;

public final class ArrayConstructor
extends SqlScalarFunction {
    public static final String NAME = "$array";
    public static final ArrayConstructor ARRAY_CONSTRUCTOR = new ArrayConstructor();

    public ArrayConstructor() {
        super(FunctionMetadata.scalarBuilder((String)NAME).signature(Signature.builder().typeVariable("E").returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))).argumentType(new TypeSignature("E", new TypeSignatureParameter[0])).argumentType(new TypeSignature("E", new TypeSignatureParameter[0])).variableArity().build()).nullable().argumentNullability(new boolean[]{true, true}).hidden().noDescription().build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Type type = (Type)boundSignature.getArgumentTypes().get(0);
        for (int i = 0; i < boundSignature.getArity(); ++i) {
            if (type.getJavaType().isPrimitive()) {
                builder.add((Object)Primitives.wrap((Class)type.getJavaType()));
                continue;
            }
            builder.add((Object)type.getJavaType());
        }
        ImmutableList stackTypes = builder.build();
        Class<?> clazz = ArrayConstructor.generateArrayConstructor(stackTypes, type);
        MethodHandle methodHandle = Reflection.methodHandle(clazz, "arrayConstructor", (Class[])stackTypes.toArray((Object[])new Class[stackTypes.size()]));
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, Collections.nCopies(stackTypes.size(), InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE), methodHandle);
    }

    private static Class<?> generateArrayConstructor(List<Class<?>> stackTypes, Type elementType) {
        Failures.checkCondition(stackTypes.size() <= 254, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for array constructor", new Object[0]);
        List stackTypeNames = (List)stackTypes.stream().map(Class::getSimpleName).collect(ImmutableList.toImmutableList());
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(Joiner.on((String)"").join((Iterable)stackTypeNames) + "ArrayConstructor"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int i = 0; i < stackTypes.size(); ++i) {
            Class<?> stackType = stackTypes.get(i);
            parameters.add((Object)Parameter.arg((String)("arg" + i), stackType));
        }
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "arrayConstructor", ParameterizedType.type(Block.class), (Iterable)parameters.build());
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable blockBuilderVariable = scope.declareVariable(BlockBuilder.class, "blockBuilder");
        CallSiteBinder binder = new CallSiteBinder();
        BytecodeExpression createBlockBuilder = blockBuilderVariable.set(SqlTypeBytecodeExpression.constantType(binder, elementType).invoke("createBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantNull(BlockBuilderStatus.class), BytecodeExpressions.constantInt((int)stackTypes.size())}));
        body.append((BytecodeNode)createBlockBuilder);
        for (int i = 0; i < stackTypes.size(); ++i) {
            Variable argument = scope.getVariable("arg" + i);
            IfStatement ifStatement = new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)argument, (BytecodeExpression)BytecodeExpressions.constantNull(stackTypes.get(i)))).ifTrue((BytecodeNode)blockBuilderVariable.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, elementType).writeValue((BytecodeExpression)blockBuilderVariable, argument.cast(elementType.getJavaType())));
            body.append((BytecodeNode)ifStatement);
        }
        body.append((BytecodeNode)blockBuilderVariable.invoke("build", Block.class, new BytecodeExpression[0]).ret());
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), (ClassLoader)new DynamicClassLoader(ArrayConstructor.class.getClassLoader()));
    }
}

