/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.BlockSet;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BufferedMapValueBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.gen.VarArgsToArrayAdapterGenerator;
import io.trino.type.BlockTypeOperators;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public final class MapConcatFunction
extends SqlScalarFunction {
    private static final String FUNCTION_NAME = "map_concat";
    private static final String DESCRIPTION = "Concatenates given maps";
    private static final MethodHandle USER_STATE_FACTORY = Reflection.methodHandle(MapConcatFunction.class, "createMapState", MapType.class);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapConcatFunction.class, "mapConcat", MapType.class, BlockTypeOperators.BlockPositionIsDistinctFrom.class, BlockTypeOperators.BlockPositionHashCode.class, Object.class, SqlMap[].class);
    private final BlockTypeOperators blockTypeOperators;

    public MapConcatFunction(BlockTypeOperators blockTypeOperators) {
        super(FunctionMetadata.scalarBuilder((String)FUNCTION_NAME).signature(Signature.builder().typeVariable("K").typeVariable("V").returnType(TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0]))).argumentType(TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0]))).variableArity().build()).description(DESCRIPTION).build());
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        if (boundSignature.getArity() < 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "There must be two or more concatenation arguments to map_concat");
        }
        MapType mapType = (MapType)boundSignature.getReturnType();
        Type keyType = mapType.getKeyType();
        BlockTypeOperators.BlockPositionIsDistinctFrom keysDistinctOperator = this.blockTypeOperators.getDistinctFromOperator(keyType);
        BlockTypeOperators.BlockPositionHashCode keyHashCode = this.blockTypeOperators.getHashCodeOperator(keyType);
        VarArgsToArrayAdapterGenerator.MethodHandleAndConstructor methodHandleAndConstructor = VarArgsToArrayAdapterGenerator.generateVarArgsToArrayAdapter(SqlMap.class, SqlMap.class, boundSignature.getArity(), MethodHandles.insertArguments(METHOD_HANDLE, 0, mapType, keysDistinctOperator, keyHashCode), USER_STATE_FACTORY.bindTo(mapType));
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, Collections.nCopies(boundSignature.getArity(), InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandleAndConstructor.getMethodHandle(), Optional.of(methodHandleAndConstructor.getConstructor()));
    }

    @UsedByGeneratedCode
    public static Object createMapState(MapType mapType) {
        return BufferedMapValueBuilder.createBuffered((MapType)mapType);
    }

    @UsedByGeneratedCode
    public static SqlMap mapConcat(MapType mapType, BlockTypeOperators.BlockPositionIsDistinctFrom keysDistinctOperator, BlockTypeOperators.BlockPositionHashCode keyHashCode, Object state, SqlMap[] maps) {
        int lastMapIndex;
        int maxEntries = 0;
        int firstMapIndex = lastMapIndex = maps.length - 1;
        for (int i = 0; i < maps.length; ++i) {
            int size = maps[i].getSize();
            if (size <= 0) continue;
            maxEntries += size;
            lastMapIndex = i;
            firstMapIndex = Math.min(firstMapIndex, i);
        }
        if (lastMapIndex == firstMapIndex) {
            return maps[lastMapIndex];
        }
        int last = lastMapIndex;
        int first = firstMapIndex;
        BufferedMapValueBuilder mapValueBuilder = (BufferedMapValueBuilder)state;
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        BlockSet set = new BlockSet(keyType, keysDistinctOperator, keyHashCode, maxEntries);
        return mapValueBuilder.build(maxEntries, (keyBuilder, valueBuilder) -> {
            int i;
            SqlMap map = maps[last];
            int rawOffset = map.getRawOffset();
            Block rawKeyBlock = map.getRawKeyBlock();
            Block rawValueBlock = map.getRawValueBlock();
            for (i = 0; i < map.getSize(); ++i) {
                set.add(rawKeyBlock, rawOffset + i);
                MapConcatFunction.writeEntry(keyType, valueType, keyBuilder, valueBuilder, rawKeyBlock, rawValueBlock, rawOffset + i);
            }
            for (int idx = last - 1; idx > first; --idx) {
                map = maps[idx];
                rawOffset = map.getRawOffset();
                rawKeyBlock = map.getRawKeyBlock();
                rawValueBlock = map.getRawValueBlock();
                for (int i2 = 0; i2 < map.getSize(); ++i2) {
                    if (!set.add(rawKeyBlock, rawOffset + i2)) continue;
                    MapConcatFunction.writeEntry(keyType, valueType, keyBuilder, valueBuilder, rawKeyBlock, rawValueBlock, rawOffset + i2);
                }
            }
            map = maps[first];
            rawOffset = map.getRawOffset();
            rawKeyBlock = map.getRawKeyBlock();
            rawValueBlock = map.getRawValueBlock();
            for (i = 0; i < map.getSize(); ++i) {
                if (set.contains(rawKeyBlock, rawOffset + i)) continue;
                MapConcatFunction.writeEntry(keyType, valueType, keyBuilder, valueBuilder, rawKeyBlock, rawValueBlock, rawOffset + i);
            }
        });
    }

    private static void writeEntry(Type keyType, Type valueType, BlockBuilder keyBuilder, BlockBuilder valueBuilder, Block rawKeyBlock, Block rawValueBlock, int rawIndex) {
        keyType.appendTo(rawKeyBlock, rawIndex, keyBuilder);
        valueType.appendTo(rawValueBlock, rawIndex, valueBuilder);
    }
}

