/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.table.json.execution;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.json.JsonInputErrorNode;
import io.trino.json.JsonPathEvaluator;
import io.trino.json.PathEvaluationException;
import io.trino.json.ir.SqlJsonLiteralConverter;
import io.trino.json.ir.TypedValue;
import io.trino.operator.scalar.json.JsonOutputConversionException;
import java.util.List;
import java.util.Optional;

public class SequenceEvaluator {
    private SequenceEvaluator() {
    }

    public static List<JsonNode> getSequence(JsonNode item, Object[] pathParameters, JsonPathEvaluator pathEvaluator, boolean errorOnError) {
        List<Object> pathResult;
        if (item == null) {
            return ImmutableList.of();
        }
        if (item.equals((Object)JsonInputErrorNode.JSON_ERROR)) {
            Preconditions.checkState((!errorOnError ? 1 : 0) != 0, (Object)"input conversion error should have been thrown in the input function");
            return ImmutableList.of();
        }
        for (Object parameter : pathParameters) {
            if (!parameter.equals((Object)JsonInputErrorNode.JSON_ERROR)) continue;
            Preconditions.checkState((!errorOnError ? 1 : 0) != 0, (Object)"input conversion error should have been thrown in the input function");
            return ImmutableList.of();
        }
        try {
            pathResult = pathEvaluator.evaluate(item, pathParameters);
        }
        catch (PathEvaluationException e) {
            if (errorOnError) {
                throw e;
            }
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object element : pathResult) {
            if (element instanceof TypedValue) {
                TypedValue typedValue = (TypedValue)element;
                Optional<JsonNode> jsonNode = SqlJsonLiteralConverter.getJsonNode(typedValue);
                if (jsonNode.isEmpty()) {
                    if (errorOnError) {
                        throw new JsonOutputConversionException(String.format("JSON path returned a scalar SQL value of type %s that cannot be represented as JSON", ((TypedValue)element).getType()));
                    }
                    return ImmutableList.of();
                }
                builder.add((Object)jsonNode.get());
                continue;
            }
            builder.add((Object)((JsonNode)element));
        }
        return builder.build();
    }
}

