/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.connector.CatalogFactory;
import io.trino.eventlistener.EventListenerManager;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.resourcegroups.ResourceGroupManager;
import io.trino.metadata.BlockEncodingManager;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.HandleResolver;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.TypeRegistry;
import io.trino.security.AccessControlManager;
import io.trino.security.GroupProviderManager;
import io.trino.server.PluginClassLoader;
import io.trino.server.PluginInstaller;
import io.trino.server.SessionPropertyDefaults;
import io.trino.server.security.CertificateAuthenticatorManager;
import io.trino.server.security.HeaderAuthenticatorManager;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.spi.Plugin;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.eventlistener.EventListenerFactory;
import io.trino.spi.exchange.ExchangeManagerFactory;
import io.trino.spi.resourcegroups.ResourceGroupConfigurationManagerFactory;
import io.trino.spi.security.CertificateAuthenticatorFactory;
import io.trino.spi.security.GroupProviderFactory;
import io.trino.spi.security.HeaderAuthenticatorFactory;
import io.trino.spi.security.PasswordAuthenticatorFactory;
import io.trino.spi.security.SystemAccessControlFactory;
import io.trino.spi.session.SessionPropertyConfigurationManagerFactory;
import io.trino.spi.type.ParametricType;
import io.trino.spi.type.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

@ThreadSafe
public class PluginManager
implements PluginInstaller {
    private static final ImmutableList<String> SPI_PACKAGES = ImmutableList.builder().add((Object)"io.trino.spi.").add((Object)"com.fasterxml.jackson.annotation.").add((Object)"io.airlift.slice.").add((Object)"org.openjdk.jol.").add((Object)"io.opentelemetry.api.").add((Object)"io.opentelemetry.context.").build();
    private static final Logger log = Logger.get(PluginManager.class);
    private final PluginsProvider pluginsProvider;
    private final CatalogFactory connectorFactory;
    private final GlobalFunctionCatalog globalFunctionCatalog;
    private final ResourceGroupManager<?> resourceGroupManager;
    private final AccessControlManager accessControlManager;
    private final Optional<PasswordAuthenticatorManager> passwordAuthenticatorManager;
    private final CertificateAuthenticatorManager certificateAuthenticatorManager;
    private final Optional<HeaderAuthenticatorManager> headerAuthenticatorManager;
    private final EventListenerManager eventListenerManager;
    private final GroupProviderManager groupProviderManager;
    private final ExchangeManagerRegistry exchangeManagerRegistry;
    private final SessionPropertyDefaults sessionPropertyDefaults;
    private final TypeRegistry typeRegistry;
    private final BlockEncodingManager blockEncodingManager;
    private final HandleResolver handleResolver;
    private final AtomicBoolean pluginsLoading = new AtomicBoolean();

    @Inject
    public PluginManager(PluginsProvider pluginsProvider, CatalogFactory connectorFactory, GlobalFunctionCatalog globalFunctionCatalog, ResourceGroupManager<?> resourceGroupManager, AccessControlManager accessControlManager, Optional<PasswordAuthenticatorManager> passwordAuthenticatorManager, CertificateAuthenticatorManager certificateAuthenticatorManager, Optional<HeaderAuthenticatorManager> headerAuthenticatorManager, EventListenerManager eventListenerManager, GroupProviderManager groupProviderManager, SessionPropertyDefaults sessionPropertyDefaults, TypeRegistry typeRegistry, BlockEncodingManager blockEncodingManager, HandleResolver handleResolver, ExchangeManagerRegistry exchangeManagerRegistry) {
        this.pluginsProvider = Objects.requireNonNull(pluginsProvider, "pluginsProvider is null");
        this.connectorFactory = Objects.requireNonNull(connectorFactory, "connectorFactory is null");
        this.globalFunctionCatalog = Objects.requireNonNull(globalFunctionCatalog, "globalFunctionCatalog is null");
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
        this.accessControlManager = Objects.requireNonNull(accessControlManager, "accessControlManager is null");
        this.passwordAuthenticatorManager = Objects.requireNonNull(passwordAuthenticatorManager, "passwordAuthenticatorManager is null");
        this.certificateAuthenticatorManager = Objects.requireNonNull(certificateAuthenticatorManager, "certificateAuthenticatorManager is null");
        this.headerAuthenticatorManager = Objects.requireNonNull(headerAuthenticatorManager, "headerAuthenticatorManager is null");
        this.eventListenerManager = Objects.requireNonNull(eventListenerManager, "eventListenerManager is null");
        this.groupProviderManager = Objects.requireNonNull(groupProviderManager, "groupProviderManager is null");
        this.sessionPropertyDefaults = Objects.requireNonNull(sessionPropertyDefaults, "sessionPropertyDefaults is null");
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry is null");
        this.blockEncodingManager = Objects.requireNonNull(blockEncodingManager, "blockEncodingManager is null");
        this.handleResolver = Objects.requireNonNull(handleResolver, "handleResolver is null");
        this.exchangeManagerRegistry = Objects.requireNonNull(exchangeManagerRegistry, "exchangeManagerRegistry is null");
    }

    @Override
    public void loadPlugins() {
        if (!this.pluginsLoading.compareAndSet(false, true)) {
            return;
        }
        this.pluginsProvider.loadPlugins(this::loadPlugin, PluginManager::createClassLoader);
        this.typeRegistry.verifyTypes();
    }

    private void loadPlugin(String plugin, Supplier<PluginClassLoader> createClassLoader) {
        log.info("-- Loading plugin %s --", new Object[]{plugin});
        PluginClassLoader pluginClassLoader = createClassLoader.get();
        log.debug("Classpath for plugin:");
        for (URL url : pluginClassLoader.getURLs()) {
            log.debug("    %s", new Object[]{url.getPath()});
        }
        this.handleResolver.registerClassLoader(pluginClassLoader);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader((ClassLoader)pluginClassLoader);){
            this.loadPlugin(pluginClassLoader);
        }
        log.info("-- Finished loading plugin %s --", new Object[]{plugin});
    }

    private void loadPlugin(PluginClassLoader pluginClassLoader) {
        ServiceLoader<Plugin> serviceLoader = ServiceLoader.load(Plugin.class, pluginClassLoader);
        ImmutableList plugins = ImmutableList.copyOf(serviceLoader);
        Preconditions.checkState((!plugins.isEmpty() ? 1 : 0) != 0, (String)"No service providers of type %s in the classpath: %s", (Object)Plugin.class.getName(), Arrays.asList(pluginClassLoader.getURLs()));
        for (Plugin plugin : plugins) {
            log.info("Installing %s", new Object[]{plugin.getClass().getName()});
            this.installPlugin(plugin);
        }
    }

    @Override
    public void installPlugin(Plugin plugin) {
        this.installPluginInternal(plugin);
        this.typeRegistry.verifyTypes();
    }

    private void installPluginInternal(Plugin plugin) {
        for (BlockEncoding blockEncoding : plugin.getBlockEncodings()) {
            log.info("Registering block encoding %s", new Object[]{blockEncoding.getName()});
            this.blockEncodingManager.addBlockEncoding(blockEncoding);
        }
        for (Type type : plugin.getTypes()) {
            log.info("Registering type %s", new Object[]{type.getTypeSignature()});
            this.typeRegistry.addType(type);
        }
        for (ParametricType parametricType : plugin.getParametricTypes()) {
            log.info("Registering parametric type %s", new Object[]{parametricType.getName()});
            this.typeRegistry.addParametricType(parametricType);
        }
        for (ConnectorFactory connectorFactory : plugin.getConnectorFactories()) {
            log.info("Registering connector %s", new Object[]{connectorFactory.getName()});
            this.connectorFactory.addConnectorFactory(connectorFactory);
        }
        Set functions = plugin.getFunctions();
        if (!functions.isEmpty()) {
            log.info("Registering functions from %s", new Object[]{plugin.getClass().getSimpleName()});
            InternalFunctionBundle.InternalFunctionBundleBuilder builder = InternalFunctionBundle.builder();
            functions.forEach(builder::functions);
            this.globalFunctionCatalog.addFunctions(builder.build());
        }
        for (SessionPropertyConfigurationManagerFactory sessionConfigFactory : plugin.getSessionPropertyConfigurationManagerFactories()) {
            log.info("Registering session property configuration manager %s", new Object[]{sessionConfigFactory.getName()});
            this.sessionPropertyDefaults.addConfigurationManagerFactory(sessionConfigFactory);
        }
        for (ResourceGroupConfigurationManagerFactory configurationManagerFactory : plugin.getResourceGroupConfigurationManagerFactories()) {
            log.info("Registering resource group configuration manager %s", new Object[]{configurationManagerFactory.getName()});
            this.resourceGroupManager.addConfigurationManagerFactory(configurationManagerFactory);
        }
        for (SystemAccessControlFactory accessControlFactory : plugin.getSystemAccessControlFactories()) {
            log.info("Registering system access control %s", new Object[]{accessControlFactory.getName()});
            this.accessControlManager.addSystemAccessControlFactory(accessControlFactory);
        }
        this.passwordAuthenticatorManager.ifPresent(authenticationManager -> {
            for (PasswordAuthenticatorFactory authenticatorFactory : plugin.getPasswordAuthenticatorFactories()) {
                log.info("Registering password authenticator %s", new Object[]{authenticatorFactory.getName()});
                authenticationManager.addPasswordAuthenticatorFactory(authenticatorFactory);
            }
        });
        for (CertificateAuthenticatorFactory authenticatorFactory : plugin.getCertificateAuthenticatorFactories()) {
            log.info("Registering certificate authenticator %s", new Object[]{authenticatorFactory.getName()});
            this.certificateAuthenticatorManager.addCertificateAuthenticatorFactory(authenticatorFactory);
        }
        this.headerAuthenticatorManager.ifPresent(authenticationManager -> {
            for (HeaderAuthenticatorFactory authenticatorFactory : plugin.getHeaderAuthenticatorFactories()) {
                log.info("Registering header authenticator %s", new Object[]{authenticatorFactory.getName()});
                authenticationManager.addHeaderAuthenticatorFactory(authenticatorFactory);
            }
        });
        for (EventListenerFactory eventListenerFactory : plugin.getEventListenerFactories()) {
            log.info("Registering event listener %s", new Object[]{eventListenerFactory.getName()});
            this.eventListenerManager.addEventListenerFactory(eventListenerFactory);
        }
        for (GroupProviderFactory groupProviderFactory : plugin.getGroupProviderFactories()) {
            log.info("Registering group provider %s", new Object[]{groupProviderFactory.getName()});
            this.groupProviderManager.addGroupProviderFactory(groupProviderFactory);
        }
        for (ExchangeManagerFactory exchangeManagerFactory : plugin.getExchangeManagerFactories()) {
            log.info("Registering exchange manager %s", new Object[]{exchangeManagerFactory.getName()});
            this.exchangeManagerRegistry.addExchangeManagerFactory(exchangeManagerFactory);
        }
    }

    public static PluginClassLoader createClassLoader(String pluginName, List<URL> urls) {
        ClassLoader parent = PluginManager.class.getClassLoader();
        return new PluginClassLoader(pluginName, urls, parent, (List<String>)SPI_PACKAGES);
    }

    public static interface PluginsProvider {
        public void loadPlugins(Loader var1, ClassLoaderFactory var2);

        public static interface ClassLoaderFactory {
            public PluginClassLoader create(String var1, List<URL> var2);
        }

        public static interface Loader {
            public void load(String var1, Supplier<PluginClassLoader> var2);
        }
    }
}

