/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import io.airlift.bootstrap.ApplicationConfigurationException;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.event.client.EventModule;
import io.airlift.event.client.JsonEventModule;
import io.airlift.http.server.HttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.JmxHttpModule;
import io.airlift.jmx.JmxModule;
import io.airlift.json.JsonModule;
import io.airlift.log.LogJmxModule;
import io.airlift.log.Logger;
import io.airlift.node.NodeModule;
import io.airlift.openmetrics.JmxOpenMetricsModule;
import io.airlift.tracetoken.TraceTokenModule;
import io.airlift.tracing.TracingModule;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogManagerConfig;
import io.trino.connector.CatalogManagerModule;
import io.trino.connector.ConnectorServices;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.eventlistener.EventListenerManager;
import io.trino.eventlistener.EventListenerModule;
import io.trino.exchange.ExchangeManagerModule;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.resourcegroups.ResourceGroupManager;
import io.trino.execution.warnings.WarningCollectorModule;
import io.trino.metadata.Catalog;
import io.trino.metadata.CatalogManager;
import io.trino.security.AccessControlManager;
import io.trino.security.AccessControlModule;
import io.trino.security.GroupProviderManager;
import io.trino.server.CoordinatorDiscoveryModule;
import io.trino.server.GracefulShutdownModule;
import io.trino.server.PluginInstaller;
import io.trino.server.PrefixObjectNameGeneratorModule;
import io.trino.server.ServerMainModule;
import io.trino.server.SessionPropertyDefaults;
import io.trino.server.StartupStatus;
import io.trino.server.TrinoSystemRequirements;
import io.trino.server.security.CertificateAuthenticatorManager;
import io.trino.server.security.HeaderAuthenticatorManager;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.server.security.ServerSecurityModule;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.spi.connector.CatalogHandle;
import io.trino.transaction.TransactionManagerModule;
import io.trino.util.EmbedVersion;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.weakref.jmx.guice.MBeanModule;

public class Server {
    public final void start(String trinoVersion) {
        new EmbedVersion(trinoVersion).embedVersion(() -> this.doStart(trinoVersion)).run();
    }

    private void doStart(String trinoVersion) {
        TrinoSystemRequirements.verifyJvmRequirements();
        TrinoSystemRequirements.verifySystemTimeIsReasonable();
        Logger log = Logger.get(Server.class);
        log.info("Java version: %s", new Object[]{StandardSystemProperty.JAVA_VERSION.value()});
        ImmutableList.Builder modules = ImmutableList.builder();
        modules.add((Object[])new Module[]{new NodeModule(), new DiscoveryModule(), new HttpServerModule(), new JsonModule(), new JaxrsModule(), new MBeanModule(), new PrefixObjectNameGeneratorModule("io.trino"), new JmxModule(), new JmxHttpModule(), new JmxOpenMetricsModule(), new LogJmxModule(), new TraceTokenModule(), new TracingModule("trino", trinoVersion), new EventModule(), new JsonEventModule(), new ServerSecurityModule(), new AccessControlModule(), new EventListenerModule(), new ExchangeManagerModule(), new CoordinatorDiscoveryModule(), new CatalogManagerModule(), new TransactionManagerModule(), new ServerMainModule(trinoVersion), new GracefulShutdownModule(), new WarningCollectorModule()});
        modules.addAll(this.getAdditionalModules());
        Bootstrap app = new Bootstrap((Iterable)modules.build());
        try {
            Injector injector = app.initialize();
            log.info("Trino version: %s", new Object[]{((NodeVersion)injector.getInstance(NodeVersion.class)).getVersion()});
            Server.logLocation(log, "Working directory", Paths.get(".", new String[0]));
            Server.logLocation(log, "Etc directory", Paths.get("etc", new String[0]));
            ((PluginInstaller)injector.getInstance(PluginInstaller.class)).loadPlugins();
            ConnectorServicesProvider connectorServicesProvider = (ConnectorServicesProvider)injector.getInstance(ConnectorServicesProvider.class);
            connectorServicesProvider.loadInitialCatalogs();
            if (((CatalogManagerConfig)injector.getInstance(CatalogManagerConfig.class)).getCatalogMangerKind() == CatalogManagerConfig.CatalogMangerKind.STATIC) {
                CatalogManager catalogManager = (CatalogManager)injector.getInstance(CatalogManager.class);
                Server.addConnectorEventListeners(catalogManager, (ConnectorServicesProvider)injector.getInstance(ConnectorServicesProvider.class), (EventListenerManager)injector.getInstance(EventListenerManager.class));
                Server.updateConnectorIds((Announcer)injector.getInstance(Announcer.class), catalogManager);
            }
            ((SessionPropertyDefaults)injector.getInstance(SessionPropertyDefaults.class)).loadConfigurationManager();
            ((ResourceGroupManager)injector.getInstance(ResourceGroupManager.class)).loadConfigurationManager();
            ((AccessControlManager)injector.getInstance(AccessControlManager.class)).loadSystemAccessControl();
            ((Optional)injector.getInstance(Server.optionalKey(PasswordAuthenticatorManager.class))).ifPresent(PasswordAuthenticatorManager::loadPasswordAuthenticator);
            ((EventListenerManager)injector.getInstance(EventListenerManager.class)).loadEventListeners();
            ((GroupProviderManager)injector.getInstance(GroupProviderManager.class)).loadConfiguredGroupProvider();
            ((ExchangeManagerRegistry)injector.getInstance(ExchangeManagerRegistry.class)).loadExchangeManager();
            ((CertificateAuthenticatorManager)injector.getInstance(CertificateAuthenticatorManager.class)).loadCertificateAuthenticator();
            ((Optional)injector.getInstance(Server.optionalKey(HeaderAuthenticatorManager.class))).ifPresent(HeaderAuthenticatorManager::loadHeaderAuthenticator);
            ((Optional)injector.getInstance(Server.optionalKey(OAuth2Client.class))).ifPresent(OAuth2Client::load);
            ((Announcer)injector.getInstance(Announcer.class)).start();
            ((StartupStatus)injector.getInstance(StartupStatus.class)).startupComplete();
            log.info("======== SERVER STARTED ========");
        }
        catch (ApplicationConfigurationException e) {
            StringBuilder message = new StringBuilder();
            message.append("Configuration is invalid\n");
            message.append("==========\n");
            Server.addMessages(message, "Errors", (List<Object>)ImmutableList.copyOf((Collection)e.getErrors()));
            Server.addMessages(message, "Warnings", (List<Object>)ImmutableList.copyOf((Collection)e.getWarnings()));
            message.append("\n");
            message.append("==========");
            log.error("%s", new Object[]{message});
            System.exit(100);
        }
        catch (Throwable e) {
            log.error(e);
            System.exit(100);
        }
    }

    @VisibleForTesting
    public static void addConnectorEventListeners(CatalogManager catalogManager, ConnectorServicesProvider connectorServicesProvider, EventListenerManager eventListenerManager) {
        catalogManager.getCatalogNames().stream().map(catalogManager::getCatalog).flatMap(Optional::stream).filter(Predicate.not(Catalog::isFailed)).map(Catalog::getCatalogHandle).map(connectorServicesProvider::getConnectorServices).map(ConnectorServices::getEventListeners).flatMap(Collection::stream).forEach(eventListenerManager::addEventListener);
    }

    private static <T> Key<Optional<T>> optionalKey(Class<T> type) {
        return Key.get((TypeLiteral)TypeLiteral.get((Type)Types.newParameterizedType(Optional.class, (Type[])new Type[]{type})));
    }

    private static void addMessages(StringBuilder output, String type, List<Object> messages) {
        if (messages.isEmpty()) {
            return;
        }
        output.append("\n").append(type).append(":\n\n");
        for (int index = 0; index < messages.size(); ++index) {
            output.append(String.format("%s) %s\n", index + 1, messages.get(index)));
        }
    }

    protected Iterable<? extends Module> getAdditionalModules() {
        return ImmutableList.of();
    }

    private static void updateConnectorIds(Announcer announcer, CatalogManager catalogManager) {
        ServiceAnnouncement announcement = Server.getTrinoAnnouncement(announcer.getServiceAnnouncements());
        String catalogHandleIds = catalogManager.getCatalogNames().stream().map(catalogManager::getCatalog).flatMap(Optional::stream).map(Catalog::getCatalogHandle).map(CatalogHandle::getId).distinct().sorted().collect(Collectors.joining(","));
        ServiceAnnouncement.ServiceAnnouncementBuilder builder = ServiceAnnouncement.serviceAnnouncement((String)announcement.getType());
        builder.addProperties(announcement.getProperties());
        builder.addProperty("catalogHandleIds", catalogHandleIds);
        announcer.removeServiceAnnouncement(announcement.getId());
        announcer.addServiceAnnouncement(builder.build());
    }

    private static ServiceAnnouncement getTrinoAnnouncement(Set<ServiceAnnouncement> announcements) {
        for (ServiceAnnouncement announcement : announcements) {
            if (!announcement.getType().equals("trino")) continue;
            return announcement;
        }
        throw new IllegalArgumentException("Trino announcement not found: " + String.valueOf(announcements));
    }

    private static void logLocation(Logger log, String name, Path path) {
        if (!Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            log.info("%s: [does not exist]", new Object[]{name});
            return;
        }
        try {
            path = path.toAbsolutePath().toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            log.info("%s: [not accessible]", new Object[]{name});
            return;
        }
        log.info("%s: %s", new Object[]{name, path});
    }
}

