/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.MergeProcessorNode;
import io.trino.sql.planner.plan.MergeWriterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableUpdateNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PushMergeWriterUpdateIntoConnector
implements Rule<TableFinishNode> {
    private static final Capture<MergeWriterNode> MERGE_WRITER_NODE_CAPTURE = Capture.newCapture();
    private static final Capture<MergeProcessorNode> MERGE_PROCESSOR_NODE_CAPTURE = Capture.newCapture();
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Capture<ProjectNode> PROJECT_NODE_CAPTURE = Capture.newCapture();
    private static final Pattern<TableFinishNode> PATTERN = Patterns.tableFinish().with(Patterns.source().matching(Patterns.mergeWriter().capturedAs(MERGE_WRITER_NODE_CAPTURE).with(Patterns.source().matching(Patterns.mergeProcessor().capturedAs(MERGE_PROCESSOR_NODE_CAPTURE).with(Patterns.source().matching(Patterns.project().capturedAs(PROJECT_NODE_CAPTURE).with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)))))))));
    private final Metadata metadata;
    private final PlannerContext plannerContext;
    private final TypeAnalyzer typeAnalyzer;

    public PushMergeWriterUpdateIntoConnector(PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<TableFinishNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableFinishNode node, Captures captures, Rule.Context context) {
        List mergeAssignments;
        MergeWriterNode mergeWriter = (MergeWriterNode)captures.get(MERGE_WRITER_NODE_CAPTURE);
        MergeProcessorNode mergeProcessor = (MergeProcessorNode)captures.get(MERGE_PROCESSOR_NODE_CAPTURE);
        ProjectNode project = (ProjectNode)captures.get(PROJECT_NODE_CAPTURE);
        TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(context.getSession(), mergeWriter.getTarget().getHandle());
        List<String> orderedColumnNames = mergeWriter.getTarget().getMergeParadigmAndTypes().getColumnNames();
        Map<ColumnHandle, Constant> assignments = this.buildAssignments(orderedColumnNames, mergeAssignments = project.getAssignments().get(mergeProcessor.getMergeRowSymbol()).getChildren(), columnHandles, context);
        if (assignments.isEmpty()) {
            return Rule.Result.empty();
        }
        return this.metadata.applyUpdate(context.getSession(), tableScan.getTable(), assignments).map(newHandle -> new TableUpdateNode(context.getIdAllocator().getNextId(), (TableHandle)newHandle, (Symbol)Iterables.getOnlyElement(node.getOutputSymbols()))).map(Rule.Result::ofPlanNode).orElseGet(Rule.Result::empty);
    }

    private Map<ColumnHandle, Constant> buildAssignments(List<String> orderedColumnNames, List<? extends Node> mergeAssignments, Map<String, ColumnHandle> columnHandles, Rule.Context context) {
        ImmutableMap.Builder assignmentsBuilder = ImmutableMap.builder();
        for (int i = 0; i < orderedColumnNames.size(); ++i) {
            String columnName = orderedColumnNames.get(i);
            Node assigmentNode = mergeAssignments.get(i);
            if (assigmentNode instanceof SymbolReference) continue;
            Optional<ConnectorExpression> connectorExpression = ConnectorExpressionTranslator.translate(context.getSession(), (Expression)assigmentNode, context.getSymbolAllocator().getTypes(), this.plannerContext, this.typeAnalyzer);
            if (connectorExpression.isEmpty() || !(connectorExpression.get() instanceof Constant)) {
                return ImmutableMap.of();
            }
            assignmentsBuilder.put((Object)columnHandles.get(columnName), (Object)((Constant)connectorExpression.get()));
        }
        return assignmentsBuilder.buildOrThrow();
    }
}

