/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import io.opentelemetry.api.trace.Span;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.dispatcher.DispatchManager;
import io.trino.dispatcher.DispatchQuery;
import io.trino.exchange.DirectExchangeInput;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManager;
import io.trino.execution.QueryState;
import io.trino.execution.buffer.CompressionCodec;
import io.trino.execution.buffer.PageDeserializer;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.SimpleLocalMemoryContext;
import io.trino.operator.DirectExchangeClient;
import io.trino.operator.DirectExchangeClientSupplier;
import io.trino.server.SessionContext;
import io.trino.server.protocol.ProtocolUtil;
import io.trino.server.protocol.Slug;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.exchange.ExchangeId;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryFailedException;
import io.trino.util.MoreLists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.intellij.lang.annotations.Language;

class DirectTrinoClient {
    private final DispatchManager dispatchManager;
    private final QueryManager queryManager;
    private final DirectExchangeClientSupplier directExchangeClientSupplier;
    private final BlockEncodingSerde blockEncodingSerde;

    public DirectTrinoClient(DispatchManager dispatchManager, QueryManager queryManager, DirectExchangeClientSupplier directExchangeClientSupplier, BlockEncodingSerde blockEncodingSerde) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.directExchangeClientSupplier = Objects.requireNonNull(directExchangeClientSupplier, "directExchangeClientSupplier is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
    }

    public MaterializedResultWithQueryId execute(Session session, @Language(value="SQL") String sql) {
        return this.execute(SessionContext.fromSession(session), sql);
    }

    public MaterializedResultWithQueryId execute(SessionContext sessionContext, @Language(value="SQL") String sql) {
        QueryId queryId = this.dispatchManager.createQueryId();
        DirectTrinoClient.getQueryFuture(this.dispatchManager.createQuery(queryId, Span.getInvalid(), Slug.createNew(), sessionContext, sql));
        DirectTrinoClient.getQueryFuture(this.dispatchManager.waitForDispatched(queryId));
        DispatchQuery dispatchQuery = this.dispatchManager.getQuery(queryId);
        if (dispatchQuery.getState().isDone()) {
            return new MaterializedResultWithQueryId(queryId, DirectTrinoClient.toMaterializedRows(dispatchQuery, (List<Type>)ImmutableList.of(), (List<String>)ImmutableList.of(), (List<Page>)ImmutableList.of()));
        }
        AtomicReference columnNames = new AtomicReference();
        AtomicReference columnTypes = new AtomicReference();
        ArrayList<Page> pages = new ArrayList<Page>();
        try (DirectExchangeClient exchangeClient = this.createExchangeClient(dispatchQuery);){
            this.queryManager.setOutputInfoListener(queryId, outputInfo -> {
                DirectTrinoClient directTrinoClient = this;
                synchronized (directTrinoClient) {
                    columnNames.compareAndSet(null, outputInfo.getColumnNames());
                    columnTypes.compareAndSet(null, outputInfo.getColumnTypes());
                    outputInfo.drainInputs(input -> {
                        DirectExchangeInput exchangeInput = (DirectExchangeInput)input;
                        exchangeClient.addLocation(exchangeInput.getTaskId(), URI.create(exchangeInput.getLocation()));
                    });
                    if (outputInfo.isNoMoreInputs()) {
                        exchangeClient.noMoreLocations();
                    }
                }
            });
            PageDeserializer pageDeserializer = new PagesSerdeFactory(this.blockEncodingSerde, CompressionCodec.NONE).createDeserializer(Optional.empty());
            QueryState state = this.queryManager.getQueryState(queryId);
            while (state != QueryState.FAILED && !exchangeClient.isFinished()) {
                Slice serializedPage = exchangeClient.pollPage();
                while (serializedPage != null) {
                    Page page = pageDeserializer.deserialize(serializedPage);
                    pages.add(page);
                    serializedPage = exchangeClient.pollPage();
                }
                DirectTrinoClient.getQueryFuture(MoreFutures.whenAnyComplete((Iterable)ImmutableList.of(this.queryManager.getStateChange(queryId, state), exchangeClient.isBlocked())));
                state = this.queryManager.getQueryState(queryId);
            }
        }
        this.queryManager.resultsConsumed(queryId);
        QueryState queryState = this.queryManager.getQueryState(queryId);
        while (!queryState.isDone()) {
            DirectTrinoClient.getQueryFuture(this.queryManager.getStateChange(queryId, queryState));
            queryState = this.queryManager.getQueryState(queryId);
        }
        return new MaterializedResultWithQueryId(queryId, DirectTrinoClient.toMaterializedRows(dispatchQuery, (List)columnTypes.get(), (List)columnNames.get(), pages));
    }

    private DirectExchangeClient createExchangeClient(DispatchQuery dispatchQuery) {
        return this.directExchangeClientSupplier.get(dispatchQuery.getQueryId(), new ExchangeId("direct-exchange-query-results"), Span.current(), (LocalMemoryContext)new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "Query"), this.queryManager::outputTaskFailed, SystemSessionProperties.getRetryPolicy(dispatchQuery.getSession()));
    }

    private static MaterializedResult toMaterializedRows(DispatchQuery dispatchQuery, List<Type> columnTypes, List<String> columnNames, List<Page> pages) {
        Number value;
        QueryInfo queryInfo = dispatchQuery.getFullQueryInfo();
        ConnectorSession session = dispatchQuery.getSession().toConnectorSession();
        if (queryInfo.getState() != QueryState.FINISHED) {
            if (queryInfo.getFailureInfo() == null) {
                throw new QueryFailedException(queryInfo.getQueryId(), "Query failed with failure info");
            }
            RuntimeException remoteException = queryInfo.getFailureInfo().toException();
            throw new QueryFailedException(queryInfo.getQueryId(), Optional.ofNullable(remoteException.getMessage()).orElseGet(remoteException::toString), remoteException);
        }
        List<MaterializedRow> materializedRows = DirectTrinoClient.toMaterializedRows(session, columnTypes, pages);
        OptionalLong updateCount = OptionalLong.empty();
        if (queryInfo.getUpdateType() != null && materializedRows.size() == 1 && columnTypes.size() == 1 && columnTypes.get(0).equals((Object)BigintType.BIGINT) && (value = (Number)materializedRows.get(0).getField(0)) != null) {
            updateCount = OptionalLong.of(value.longValue());
        }
        return new MaterializedResult(materializedRows, columnTypes, columnNames, queryInfo.getSetSessionProperties(), queryInfo.getResetSessionProperties(), Optional.ofNullable(queryInfo.getUpdateType()), updateCount, MoreLists.mappedCopy(queryInfo.getWarnings(), ProtocolUtil::toClientWarning), Optional.of(ProtocolUtil.toStatementStats(queryInfo)));
    }

    private static List<MaterializedRow> toMaterializedRows(ConnectorSession session, List<Type> types, List<Page> pages) {
        ImmutableList.Builder rows = ImmutableList.builder();
        for (Page page : pages) {
            Preconditions.checkArgument((page.getChannelCount() == types.size() ? 1 : 0) != 0, (String)"Expected a page with %s columns, but got %s columns", (int)types.size(), (int)page.getChannelCount());
            for (int position = 0; position < page.getPositionCount(); ++position) {
                ArrayList<Object> values = new ArrayList(page.getChannelCount());
                for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                    Type type = types.get(channel);
                    Block block = page.getBlock(channel);
                    values.add(type.getObjectValue(session, block, position));
                }
                values = Collections.unmodifiableList(values);
                rows.add((Object)new MaterializedRow(5, values));
            }
        }
        return rows.build();
    }

    private static <T> void getQueryFuture(ListenableFuture<T> future) {
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Thread interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error processing query", e.getCause());
        }
    }

    record MaterializedResultWithQueryId(QueryId queryId, MaterializedResult result) {
        MaterializedResultWithQueryId {
            Objects.requireNonNull(queryId, "queryId is null");
            Objects.requireNonNull(result, "result is null");
        }
    }
}

