/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import io.trino.Session;
import io.trino.cost.StatsCalculator;
import io.trino.execution.FailureInjector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.SessionPropertyManager;
import io.trino.spi.ErrorType;
import io.trino.spi.Plugin;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.Plan;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingGroupProviderManager;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;

public interface QueryRunner
extends Closeable {
    @Override
    public void close();

    public int getNodeCount();

    public Session getDefaultSession();

    public TransactionManager getTransactionManager();

    public PlannerContext getPlannerContext();

    public QueryExplainer getQueryExplainer();

    public SessionPropertyManager getSessionPropertyManager();

    public SplitManager getSplitManager();

    public PageSourceManager getPageSourceManager();

    public NodePartitioningManager getNodePartitioningManager();

    public StatsCalculator getStatsCalculator();

    public TestingGroupProviderManager getGroupProvider();

    public TestingAccessControlManager getAccessControl();

    public MaterializedResult execute(@Language(value="SQL") String var1);

    public MaterializedResult execute(Session var1, @Language(value="SQL") String var2);

    public MaterializedResultWithPlan executeWithPlan(Session var1, @Language(value="SQL") String var2, WarningCollector var3);

    default public <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return this.inTransaction(this.getDefaultSession(), transactionSessionConsumer);
    }

    default public <T> T inTransaction(Session session, Function<Session, T> transactionSessionConsumer) {
        return TransactionBuilder.transaction(this.getTransactionManager(), this.getPlannerContext().getMetadata(), this.getAccessControl()).singleStatement().execute(session, transactionSessionConsumer);
    }

    public Plan createPlan(Session var1, @Language(value="SQL") String var2);

    public List<QualifiedObjectName> listTables(Session var1, String var2, String var3);

    public boolean tableExists(Session var1, String var2);

    public void installPlugin(Plugin var1);

    public void addFunctions(FunctionBundle var1);

    public void createCatalog(String var1, String var2, Map<String, String> var3);

    public Lock getExclusiveLock();

    public void injectTaskFailure(String var1, int var2, int var3, int var4, FailureInjector.InjectedFailureType var5, Optional<ErrorType> var6);

    public void loadExchangeManager(String var1, Map<String, String> var2);

    public static class MaterializedResultWithPlan {
        private final MaterializedResult materializedResult;
        private final Plan queryPlan;

        public MaterializedResultWithPlan(MaterializedResult materializedResult, Plan queryPlan) {
            this.materializedResult = materializedResult;
            this.queryPlan = queryPlan;
        }

        public MaterializedResult getMaterializedResult() {
            return this.materializedResult;
        }

        public Plan getQueryPlan() {
            return this.queryPlan;
        }
    }
}

