/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.assertions;

import io.trino.client.FailureException;
import io.trino.client.FailureInfo;
import io.trino.execution.Failure;
import io.trino.spi.TrinoException;
import io.trino.testing.QueryFailedException;
import io.trino.util.Failures;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class TestUtil {
    private TestUtil() {
    }

    public static Optional<FailureInfo> getFailureInfo(Throwable throwable) {
        if (throwable instanceof QueryFailedException) {
            QueryFailedException queryFailedException = (QueryFailedException)throwable;
            return TestUtil.getFailureInfo(queryFailedException.getCause());
        }
        if (throwable instanceof Failure) {
            Failure failure = (Failure)throwable;
            return Optional.of(failure.getFailureInfo().toFailureInfo());
        }
        if (throwable instanceof FailureException) {
            FailureException failureException = (FailureException)throwable;
            return Optional.of(failureException.getFailureInfo());
        }
        if (throwable instanceof TrinoException) {
            TrinoException trinoException = (TrinoException)throwable;
            return Optional.of(Failures.toFailure(trinoException).toFailureInfo());
        }
        return Optional.empty();
    }

    public static <T> void verifyResultOrFailure(Supplier<T> callback, Consumer<T> verifyResults, Consumer<Throwable> verifyFailure) {
        T result;
        Objects.requireNonNull(callback, "callback is null");
        Objects.requireNonNull(verifyResults, "verifyResults is null");
        Objects.requireNonNull(verifyFailure, "verifyFailure is null");
        try {
            result = callback.get();
        }
        catch (Throwable t) {
            verifyFailure.accept(t);
            return;
        }
        verifyResults.accept(result);
    }
}

