/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.assertions;

import io.trino.client.ErrorInfo;
import io.trino.client.FailureInfo;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.ErrorType;
import io.trino.spi.Location;
import io.trino.spi.TrinoException;
import io.trino.testing.assertions.TestUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.error.ShouldContainCharSequence;
import org.assertj.core.error.ShouldHaveMessageMatchingRegex;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.CheckReturnValue;

public final class TrinoExceptionAssert
extends AbstractThrowableAssert<TrinoExceptionAssert, Throwable> {
    private final FailureInfo failureInfo;

    @CheckReturnValue
    public static TrinoExceptionAssert assertTrinoExceptionThrownBy(ThrowableAssert.ThrowingCallable throwingCallable) {
        Throwable throwable = Assertions.catchThrowable((ThrowableAssert.ThrowingCallable)throwingCallable);
        if (throwable == null) {
            Assertions.failBecauseExceptionWasNotThrown(TrinoException.class);
        }
        return TrinoExceptionAssert.assertThatTrinoException(throwable);
    }

    @CheckReturnValue
    public static TrinoExceptionAssert assertThatTrinoException(Throwable throwable) {
        Optional<FailureInfo> failureInfo = TestUtil.getFailureInfo(throwable);
        if (failureInfo.isEmpty()) {
            throw new AssertionError((Object)("Expected TrinoException or wrapper, but got: " + throwable.getClass().getName() + " " + String.valueOf(throwable)));
        }
        return new TrinoExceptionAssert(throwable, failureInfo.get());
    }

    private TrinoExceptionAssert(Throwable actual, FailureInfo failureInfo) {
        super(actual, TrinoExceptionAssert.class);
        this.failureInfo = Objects.requireNonNull(failureInfo, "failureInfo is null");
    }

    public TrinoExceptionAssert hasErrorCode(ErrorCodeSupplier ... errorCodeSupplier) {
        ErrorCode errorCode = null;
        ErrorInfo errorInfo = this.failureInfo.getErrorInfo();
        if (errorInfo != null) {
            errorCode = new ErrorCode(errorInfo.getCode(), errorInfo.getName(), ErrorType.valueOf((String)errorInfo.getType()));
        }
        try {
            Assertions.assertThat(errorCode).isIn((Iterable)Stream.of(errorCodeSupplier).map(ErrorCodeSupplier::toErrorCode).collect(Collectors.toSet()));
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).addSuppressed((Throwable)this.actual);
            throw e;
        }
        return (TrinoExceptionAssert)this.myself;
    }

    public TrinoExceptionAssert hasLocation(int lineNumber, int columnNumber) {
        try {
            Optional<Location> location = Optional.ofNullable(this.failureInfo.getErrorLocation()).map(errorLocation -> new Location(errorLocation.getLineNumber(), errorLocation.getColumnNumber()));
            Assertions.assertThat(location).hasValue((Object)new Location(lineNumber, columnNumber));
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).addSuppressed((Throwable)this.actual);
            throw e;
        }
        return (TrinoExceptionAssert)this.myself;
    }

    public TrinoExceptionAssert hasCauseMessageMatching(String regex) {
        for (Throwable cause = (Throwable)this.actual; cause != null; cause = cause.getCause()) {
            if (!cause.getMessage().matches(regex)) continue;
            return (TrinoExceptionAssert)this.myself;
        }
        throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveMessageMatchingRegex.shouldHaveMessageMatchingRegex((Throwable)((Throwable)this.actual), (CharSequence)regex));
    }

    public TrinoExceptionAssert hasCauseMessageContaining(String message) {
        for (Throwable cause = (Throwable)this.actual; cause != null; cause = cause.getCause()) {
            if (!cause.getMessage().contains(message)) continue;
            return (TrinoExceptionAssert)this.myself;
        }
        throw Failures.instance().failure((AssertionInfo)this.info, ShouldContainCharSequence.shouldContain((Throwable)((Throwable)this.actual), (CharSequence)message));
    }
}

