/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.execution.AddColumnTask;
import io.trino.execution.CallTask;
import io.trino.execution.CommentTask;
import io.trino.execution.CommitTask;
import io.trino.execution.CreateCatalogTask;
import io.trino.execution.CreateFunctionTask;
import io.trino.execution.CreateMaterializedViewTask;
import io.trino.execution.CreateRoleTask;
import io.trino.execution.CreateSchemaTask;
import io.trino.execution.CreateTableTask;
import io.trino.execution.CreateViewTask;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.DeallocateTask;
import io.trino.execution.DenyTask;
import io.trino.execution.DropCatalogTask;
import io.trino.execution.DropColumnTask;
import io.trino.execution.DropFunctionTask;
import io.trino.execution.DropMaterializedViewTask;
import io.trino.execution.DropRoleTask;
import io.trino.execution.DropSchemaTask;
import io.trino.execution.DropTableTask;
import io.trino.execution.DropViewTask;
import io.trino.execution.GrantRolesTask;
import io.trino.execution.GrantTask;
import io.trino.execution.PrepareTask;
import io.trino.execution.RenameColumnTask;
import io.trino.execution.RenameMaterializedViewTask;
import io.trino.execution.RenameSchemaTask;
import io.trino.execution.RenameTableTask;
import io.trino.execution.RenameViewTask;
import io.trino.execution.ResetSessionAuthorizationTask;
import io.trino.execution.ResetSessionTask;
import io.trino.execution.RevokeRolesTask;
import io.trino.execution.RevokeTask;
import io.trino.execution.RollbackTask;
import io.trino.execution.SetColumnTypeTask;
import io.trino.execution.SetPathTask;
import io.trino.execution.SetPropertiesTask;
import io.trino.execution.SetRoleTask;
import io.trino.execution.SetSchemaAuthorizationTask;
import io.trino.execution.SetSessionAuthorizationTask;
import io.trino.execution.SetSessionTask;
import io.trino.execution.SetTableAuthorizationTask;
import io.trino.execution.SetTimeZoneTask;
import io.trino.execution.SetViewAuthorizationTask;
import io.trino.execution.StartTransactionTask;
import io.trino.execution.TruncateTableTask;
import io.trino.execution.UseTask;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.Analyze;
import io.trino.sql.tree.Call;
import io.trino.sql.tree.Comment;
import io.trino.sql.tree.Commit;
import io.trino.sql.tree.CreateCatalog;
import io.trino.sql.tree.CreateFunction;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.CreateRole;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateTableAsSelect;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.Deallocate;
import io.trino.sql.tree.Delete;
import io.trino.sql.tree.Deny;
import io.trino.sql.tree.DescribeInput;
import io.trino.sql.tree.DescribeOutput;
import io.trino.sql.tree.DropCatalog;
import io.trino.sql.tree.DropColumn;
import io.trino.sql.tree.DropFunction;
import io.trino.sql.tree.DropMaterializedView;
import io.trino.sql.tree.DropRole;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.DropTable;
import io.trino.sql.tree.DropView;
import io.trino.sql.tree.Explain;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.Grant;
import io.trino.sql.tree.GrantRoles;
import io.trino.sql.tree.Insert;
import io.trino.sql.tree.Merge;
import io.trino.sql.tree.Prepare;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.RefreshMaterializedView;
import io.trino.sql.tree.RenameColumn;
import io.trino.sql.tree.RenameMaterializedView;
import io.trino.sql.tree.RenameSchema;
import io.trino.sql.tree.RenameTable;
import io.trino.sql.tree.RenameView;
import io.trino.sql.tree.ResetSession;
import io.trino.sql.tree.ResetSessionAuthorization;
import io.trino.sql.tree.Revoke;
import io.trino.sql.tree.RevokeRoles;
import io.trino.sql.tree.Rollback;
import io.trino.sql.tree.SetColumnType;
import io.trino.sql.tree.SetPath;
import io.trino.sql.tree.SetProperties;
import io.trino.sql.tree.SetRole;
import io.trino.sql.tree.SetSchemaAuthorization;
import io.trino.sql.tree.SetSession;
import io.trino.sql.tree.SetSessionAuthorization;
import io.trino.sql.tree.SetTableAuthorization;
import io.trino.sql.tree.SetTimeZone;
import io.trino.sql.tree.SetViewAuthorization;
import io.trino.sql.tree.ShowCatalogs;
import io.trino.sql.tree.ShowColumns;
import io.trino.sql.tree.ShowCreate;
import io.trino.sql.tree.ShowFunctions;
import io.trino.sql.tree.ShowGrants;
import io.trino.sql.tree.ShowRoleGrants;
import io.trino.sql.tree.ShowRoles;
import io.trino.sql.tree.ShowSchemas;
import io.trino.sql.tree.ShowSession;
import io.trino.sql.tree.ShowStats;
import io.trino.sql.tree.ShowTables;
import io.trino.sql.tree.StartTransaction;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.TableExecute;
import io.trino.sql.tree.TruncateTable;
import io.trino.sql.tree.Update;
import io.trino.sql.tree.Use;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public final class StatementUtils {
    private static final Map<Class<? extends Statement>, StatementTypeInfo<? extends Statement>> STATEMENT_QUERY_TYPES = (Map)ImmutableList.builder().add(StatementUtils.basicStatement(Query.class, QueryType.SELECT)).add(StatementUtils.basicStatement(Explain.class, QueryType.EXPLAIN)).add(StatementUtils.basicStatement(DescribeInput.class, QueryType.DESCRIBE)).add(StatementUtils.basicStatement(DescribeOutput.class, QueryType.DESCRIBE)).add(StatementUtils.basicStatement(ShowCatalogs.class, QueryType.DESCRIBE)).add(StatementUtils.basicStatement(ShowColumns.class, QueryType.DESCRIBE)).add(StatementUtils.basicStatement(ShowCreate.class, QueryType.DESCRIBE)).add(StatementUtils.basicStatement(ShowFunctions.class, QueryType.DESCRIBE)).add(StatementUtils.basicStatement(ShowGrants.class, QueryType.DESCRIBE)).add(StatementUtils.basicStatement(ShowRoleGrants.class, QueryType.DESCRIBE)).add(StatementUtils.basicStatement(ShowRoles.class, QueryType.DESCRIBE)).add(StatementUtils.basicStatement(ShowSchemas.class, QueryType.DESCRIBE)).add(StatementUtils.basicStatement(ShowSession.class, QueryType.DESCRIBE)).add(StatementUtils.basicStatement(ShowStats.class, QueryType.DESCRIBE)).add(StatementUtils.basicStatement(ShowTables.class, QueryType.DESCRIBE)).add(StatementUtils.basicStatement(TableExecute.class, QueryType.ALTER_TABLE_EXECUTE)).add(StatementUtils.basicStatement(CreateTableAsSelect.class, QueryType.INSERT)).add(StatementUtils.basicStatement(RefreshMaterializedView.class, QueryType.INSERT)).add(StatementUtils.basicStatement(Insert.class, QueryType.INSERT)).add(StatementUtils.basicStatement(Update.class, QueryType.UPDATE)).add(StatementUtils.basicStatement(Delete.class, QueryType.DELETE)).add(StatementUtils.basicStatement(Merge.class, QueryType.MERGE)).add(StatementUtils.basicStatement(Analyze.class, QueryType.ANALYZE)).add(StatementUtils.dataDefinitionStatement(AddColumn.class, AddColumnTask.class)).add(StatementUtils.dataDefinitionStatement(Call.class, CallTask.class)).add(StatementUtils.dataDefinitionStatement(Comment.class, CommentTask.class)).add(StatementUtils.dataDefinitionStatement(Commit.class, CommitTask.class)).add(StatementUtils.dataDefinitionStatement(CreateMaterializedView.class, CreateMaterializedViewTask.class)).add(StatementUtils.dataDefinitionStatement(CreateCatalog.class, CreateCatalogTask.class)).add(StatementUtils.dataDefinitionStatement(CreateFunction.class, CreateFunctionTask.class)).add(StatementUtils.dataDefinitionStatement(CreateRole.class, CreateRoleTask.class)).add(StatementUtils.dataDefinitionStatement(CreateSchema.class, CreateSchemaTask.class)).add(StatementUtils.dataDefinitionStatement(CreateTable.class, CreateTableTask.class)).add(StatementUtils.dataDefinitionStatement(CreateView.class, CreateViewTask.class)).add(StatementUtils.dataDefinitionStatement(Deallocate.class, DeallocateTask.class)).add(StatementUtils.dataDefinitionStatement(Deny.class, DenyTask.class)).add(StatementUtils.dataDefinitionStatement(DropCatalog.class, DropCatalogTask.class)).add(StatementUtils.dataDefinitionStatement(DropColumn.class, DropColumnTask.class)).add(StatementUtils.dataDefinitionStatement(DropFunction.class, DropFunctionTask.class)).add(StatementUtils.dataDefinitionStatement(DropMaterializedView.class, DropMaterializedViewTask.class)).add(StatementUtils.dataDefinitionStatement(DropRole.class, DropRoleTask.class)).add(StatementUtils.dataDefinitionStatement(DropSchema.class, DropSchemaTask.class)).add(StatementUtils.dataDefinitionStatement(DropTable.class, DropTableTask.class)).add(StatementUtils.dataDefinitionStatement(DropView.class, DropViewTask.class)).add(StatementUtils.dataDefinitionStatement(TruncateTable.class, TruncateTableTask.class)).add(StatementUtils.dataDefinitionStatement(Grant.class, GrantTask.class)).add(StatementUtils.dataDefinitionStatement(GrantRoles.class, GrantRolesTask.class)).add(StatementUtils.dataDefinitionStatement(Prepare.class, PrepareTask.class)).add(StatementUtils.dataDefinitionStatement(RenameColumn.class, RenameColumnTask.class)).add(StatementUtils.dataDefinitionStatement(RenameMaterializedView.class, RenameMaterializedViewTask.class)).add(StatementUtils.dataDefinitionStatement(RenameSchema.class, RenameSchemaTask.class)).add(StatementUtils.dataDefinitionStatement(RenameTable.class, RenameTableTask.class)).add(StatementUtils.dataDefinitionStatement(RenameView.class, RenameViewTask.class)).add(StatementUtils.dataDefinitionStatement(ResetSession.class, ResetSessionTask.class)).add(StatementUtils.dataDefinitionStatement(ResetSessionAuthorization.class, ResetSessionAuthorizationTask.class)).add(StatementUtils.dataDefinitionStatement(Revoke.class, RevokeTask.class)).add(StatementUtils.dataDefinitionStatement(RevokeRoles.class, RevokeRolesTask.class)).add(StatementUtils.dataDefinitionStatement(Rollback.class, RollbackTask.class)).add(StatementUtils.dataDefinitionStatement(SetColumnType.class, SetColumnTypeTask.class)).add(StatementUtils.dataDefinitionStatement(SetPath.class, SetPathTask.class)).add(StatementUtils.dataDefinitionStatement(SetRole.class, SetRoleTask.class)).add(StatementUtils.dataDefinitionStatement(SetSchemaAuthorization.class, SetSchemaAuthorizationTask.class)).add(StatementUtils.dataDefinitionStatement(SetSession.class, SetSessionTask.class)).add(StatementUtils.dataDefinitionStatement(SetSessionAuthorization.class, SetSessionAuthorizationTask.class)).add(StatementUtils.dataDefinitionStatement(SetProperties.class, SetPropertiesTask.class)).add(StatementUtils.dataDefinitionStatement(SetTableAuthorization.class, SetTableAuthorizationTask.class)).add(StatementUtils.dataDefinitionStatement(SetTimeZone.class, SetTimeZoneTask.class)).add(StatementUtils.dataDefinitionStatement(SetViewAuthorization.class, SetViewAuthorizationTask.class)).add(StatementUtils.dataDefinitionStatement(StartTransaction.class, StartTransactionTask.class)).add(StatementUtils.dataDefinitionStatement(Use.class, UseTask.class)).build().stream().collect(ImmutableMap.toImmutableMap(StatementTypeInfo::getStatementType, Function.identity()));

    private StatementUtils() {
    }

    public static Optional<QueryType> getQueryType(Statement statement) {
        if (statement instanceof ExplainAnalyze) {
            return StatementUtils.getQueryType(((ExplainAnalyze)statement).getStatement());
        }
        return Optional.ofNullable(STATEMENT_QUERY_TYPES.get(statement.getClass())).map(StatementTypeInfo::getQueryType);
    }

    public static Set<Class<? extends Statement>> getNonDataDefinitionStatements() {
        return (Set)Stream.concat(Stream.of(ExplainAnalyze.class), STATEMENT_QUERY_TYPES.entrySet().stream().filter(entry -> ((StatementTypeInfo)entry.getValue()).getQueryType() != QueryType.DATA_DEFINITION).map(Map.Entry::getKey)).collect(ImmutableSet.toImmutableSet());
    }

    public static boolean isDataDefinitionStatement(Class<? extends Statement> statement) {
        StatementTypeInfo<? extends Statement> info = STATEMENT_QUERY_TYPES.get(statement);
        return info != null && info.getQueryType() == QueryType.DATA_DEFINITION;
    }

    public static boolean isTransactionControlStatement(Statement statement) {
        return statement instanceof StartTransaction || statement instanceof Commit || statement instanceof Rollback;
    }

    private static <T extends Statement> StatementTypeInfo<T> basicStatement(Class<T> statementType, QueryType queryType) {
        return new StatementTypeInfo<T>(statementType, queryType, Optional.empty());
    }

    private static <T extends Statement> StatementTypeInfo<T> dataDefinitionStatement(Class<T> statementType, Class<? extends DataDefinitionTask<T>> taskType) {
        Objects.requireNonNull(taskType, "taskType is null");
        StatementUtils.verifyTaskInterfaceType(statementType, taskType, DataDefinitionTask.class);
        return new StatementTypeInfo<T>(statementType, QueryType.DATA_DEFINITION, Optional.of(taskType));
    }

    private static <T extends Statement> void verifyTaskInterfaceType(Class<T> statementType, Class<?> taskType, Class<?> expectedInterfaceType) {
        for (Type genericInterface : taskType.getGenericInterfaces()) {
            ParameterizedType parameterizedInterface;
            if (!(genericInterface instanceof ParameterizedType) || !(parameterizedInterface = (ParameterizedType)genericInterface).getRawType().equals(expectedInterfaceType)) continue;
            Type actualStatementType = parameterizedInterface.getActualTypeArguments()[0];
            Preconditions.checkArgument((boolean)actualStatementType.equals(statementType), (String)"Expected %s statement type to be %s", (Object)statementType.getSimpleName(), (Object)taskType.getSimpleName());
            return;
        }
        throw new VerifyException(String.format("%s does not implement %s", taskType.getSimpleName(), DataDefinitionTask.class.getName()));
    }

    private static class StatementTypeInfo<T extends Statement> {
        private final Class<T> statementType;
        private final QueryType queryType;
        private final Optional<Class<? extends DataDefinitionTask<T>>> taskType;

        private StatementTypeInfo(Class<T> statementType, QueryType queryType, Optional<Class<? extends DataDefinitionTask<T>>> taskType) {
            this.statementType = Objects.requireNonNull(statementType, "statementType is null");
            this.queryType = Objects.requireNonNull(queryType, "queryType is null");
            this.taskType = Objects.requireNonNull(taskType, "taskType is null");
            if (queryType == QueryType.DATA_DEFINITION) {
                Preconditions.checkArgument((boolean)taskType.isPresent(), (String)"taskType is required for %s", (Object)QueryType.DATA_DEFINITION);
            } else {
                Preconditions.checkArgument((boolean)taskType.isEmpty(), (String)"taskType is not allowed for %s", (Object)queryType);
            }
        }

        public Class<T> getStatementType() {
            return this.statementType;
        }

        public QueryType getQueryType() {
            return this.queryType;
        }

        public Class<? extends DataDefinitionTask<T>> getTaskType() {
            return this.taskType.orElseThrow(() -> new IllegalStateException(String.valueOf(this.queryType) + " does not have a task type"));
        }
    }
}

