/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.DropNotNullConstraint;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import java.util.List;
import java.util.Objects;

public class DropNotNullConstraintTask
implements DataDefinitionTask<DropNotNullConstraint> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public DropNotNullConstraintTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "DROP NOT NULL";
    }

    @Override
    public ListenableFuture<Void> execute(DropNotNullConstraint statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        RedirectionAwareTableHandle redirectionAwareTableHandle = this.metadata.getRedirectionAwareTableHandle(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTable()));
        if (redirectionAwareTableHandle.tableHandle().isEmpty()) {
            Object exceptionMessage = "Table '%s' does not exist".formatted(tableName);
            if (this.metadata.getMaterializedView(session, tableName).isPresent()) {
                exceptionMessage = (String)exceptionMessage + ", but a materialized view with that name exists.";
            } else if (this.metadata.getView(session, tableName).isPresent()) {
                exceptionMessage = (String)exceptionMessage + ", but a view with that name exists.";
            }
            if (!statement.isTableExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "%s", exceptionMessage);
            }
            return Futures.immediateVoidFuture();
        }
        this.accessControl.checkCanAlterColumn(session.toSecurityContext(), tableName);
        TableHandle tableHandle = redirectionAwareTableHandle.tableHandle().get();
        String column = statement.getColumn().toString();
        ColumnHandle columnHandle = this.metadata.getColumnHandles(session, tableHandle).get(column);
        if (columnHandle == null) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Column '%s' does not exist", column);
        }
        ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(session, tableHandle, columnHandle);
        if (columnMetadata.isHidden()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot modify hidden column", new Object[0]);
        }
        if (columnMetadata.isNullable()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Column is already nullable", new Object[0]);
        }
        this.metadata.dropNotNullConstraint(session, tableHandle, columnHandle);
        return Futures.immediateVoidFuture();
    }
}

