/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor.dedicated;

import com.google.common.base.Ticker;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.SetThreadName;
import io.airlift.log.Logger;
import io.airlift.stats.CpuTimer;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.trino.execution.SplitRunner;
import io.trino.execution.TaskId;
import io.trino.execution.executor.scheduler.Schedulable;
import io.trino.execution.executor.scheduler.SchedulerContext;
import io.trino.tracing.TrinoAttributes;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

class SplitProcessor
implements Schedulable {
    private static final Logger LOG = Logger.get(SplitProcessor.class);
    private static final Duration SPLIT_RUN_QUANTA = new Duration(1.0, TimeUnit.SECONDS);
    private final TaskId taskId;
    private final int splitId;
    private final SplitRunner split;
    private final Tracer tracer;

    public SplitProcessor(TaskId taskId, int splitId, SplitRunner split, Tracer tracer) {
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.splitId = splitId;
        this.split = Objects.requireNonNull(split, "split is null");
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run(SchedulerContext context) {
        Span splitSpan = this.tracer.spanBuilder("split").setParent(Context.current().with((ImplicitContextKeyed)this.split.getPipelineSpan())).setAttribute(TrinoAttributes.QUERY_ID, (Object)this.taskId.getQueryId().toString()).setAttribute(TrinoAttributes.STAGE_ID, (Object)this.taskId.getStageId().toString()).setAttribute(TrinoAttributes.TASK_ID, (Object)this.taskId.toString()).setAttribute(TrinoAttributes.PIPELINE_ID, (Object)(String.valueOf(this.taskId.getStageId()) + "-" + this.split.getPipelineId())).setAttribute(TrinoAttributes.SPLIT_ID, (Object)(String.valueOf(this.taskId) + "-" + this.splitId)).startSpan();
        Span processSpan = this.newSpan(splitSpan, null);
        CpuTimer timer = new CpuTimer(Ticker.systemTicker(), false);
        long previousCpuNanos = 0L;
        long previousScheduledNanos = 0L;
        try (SetThreadName ignored = new SetThreadName("SplitRunner-%s-%s", new Object[]{this.taskId, this.splitId});){
            while (!this.split.isFinished()) {
                ListenableFuture<Void> blocked = this.split.processFor(SPLIT_RUN_QUANTA);
                CpuTimer.CpuDuration elapsed = timer.elapsedTime();
                long scheduledNanos = elapsed.getWall().roundTo(TimeUnit.NANOSECONDS);
                processSpan.setAttribute(TrinoAttributes.SPLIT_SCHEDULED_TIME_NANOS, (Object)(scheduledNanos - previousScheduledNanos));
                previousScheduledNanos = scheduledNanos;
                long cpuNanos = elapsed.getCpu().roundTo(TimeUnit.NANOSECONDS);
                processSpan.setAttribute(TrinoAttributes.SPLIT_CPU_TIME_NANOS, (Object)(cpuNanos - previousCpuNanos));
                previousCpuNanos = cpuNanos;
                if (this.split.isFinished()) continue;
                if (blocked.isDone()) {
                    processSpan.addEvent("yield");
                    processSpan.end();
                    if (!context.maybeYield()) {
                        processSpan = null;
                        return;
                    }
                } else {
                    processSpan.addEvent("blocked");
                    processSpan.end();
                    if (!context.block(blocked)) {
                        processSpan = null;
                        return;
                    }
                }
                processSpan = this.newSpan(splitSpan, processSpan);
            }
            return;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return;
        }
        finally {
            if (processSpan != null) {
                processSpan.end();
            }
            splitSpan.setAttribute(TrinoAttributes.SPLIT_CPU_TIME_NANOS, (Object)timer.elapsedTime().getCpu().roundTo(TimeUnit.NANOSECONDS));
            splitSpan.setAttribute(TrinoAttributes.SPLIT_SCHEDULED_TIME_NANOS, (Object)context.getScheduledNanos());
            splitSpan.setAttribute(TrinoAttributes.SPLIT_BLOCK_TIME_NANOS, (Object)context.getBlockedNanos());
            splitSpan.setAttribute(TrinoAttributes.SPLIT_WAIT_TIME_NANOS, (Object)context.getWaitNanos());
            splitSpan.setAttribute(TrinoAttributes.SPLIT_START_TIME_NANOS, (Object)context.getStartNanos());
            splitSpan.end();
        }
    }

    private Span newSpan(Span parent, Span previous) {
        SpanBuilder builder = this.tracer.spanBuilder("process").setParent(Context.current().with((ImplicitContextKeyed)parent));
        if (previous != null) {
            builder.addLink(previous.getSpanContext());
        }
        return builder.startSpan();
    }
}

