/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.ThreadSafe;
import io.trino.operator.ChannelSet;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Objects;
import java.util.Optional;

@ThreadSafe
public class SetBuilderOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final SetSupplier setSupplier;
    private final int setChannel;
    private final int hashChannel;
    private final ChannelSet.ChannelSetBuilder channelSetBuilder;
    private boolean finished;

    public SetBuilderOperator(OperatorContext operatorContext, SetSupplier setSupplier, int setChannel, Optional<Integer> hashChannel, int expectedPositions, JoinCompiler joinCompiler, TypeOperators typeOperators) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.setSupplier = Objects.requireNonNull(setSupplier, "setSupplier is null");
        this.setChannel = setChannel;
        this.hashChannel = hashChannel.orElse(-1);
        this.channelSetBuilder = new ChannelSet.ChannelSetBuilder(setSupplier.getType(), Objects.requireNonNull(typeOperators, "typeOperators is null"), operatorContext.localUserMemoryContext());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        ChannelSet channelSet = this.channelSetBuilder.build();
        this.setSupplier.setChannelSet(channelSet);
        this.operatorContext.recordOutput(channelSet.getEstimatedSizeInBytes(), channelSet.size());
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        this.channelSetBuilder.addAll(page.getBlock(this.setChannel), this.hashChannel == -1 ? null : page.getBlock(this.hashChannel));
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class SetSupplier {
        private final Type type;
        private final SettableFuture<ChannelSet> channelSetFuture = SettableFuture.create();

        public SetSupplier(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public Type getType() {
            return this.type;
        }

        public ListenableFuture<ChannelSet> getChannelSet() {
            return this.channelSetFuture;
        }

        void setChannelSet(ChannelSet channelSet) {
            boolean wasSet = this.channelSetFuture.set((Object)Objects.requireNonNull(channelSet, "channelSet is null"));
            Preconditions.checkState((boolean)wasSet, (Object)"ChannelSet already set");
        }
    }

    public static class SetBuilderOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Optional<Integer> hashChannel;
        private final SetSupplier setProvider;
        private final int setChannel;
        private final int expectedPositions;
        private boolean closed;
        private final JoinCompiler joinCompiler;
        private final TypeOperators typeOperators;

        public SetBuilderOperatorFactory(int operatorId, PlanNodeId planNodeId, Type type, int setChannel, Optional<Integer> hashChannel, int expectedPositions, JoinCompiler joinCompiler, TypeOperators typeOperators) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            Preconditions.checkArgument((setChannel >= 0 ? 1 : 0) != 0, (Object)"setChannel is negative");
            this.setProvider = new SetSupplier(Objects.requireNonNull(type, "type is null"));
            this.setChannel = setChannel;
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.expectedPositions = expectedPositions;
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
            this.typeOperators = Objects.requireNonNull(typeOperators, "blockTypeOperators is null");
        }

        public SetSupplier getSetProvider() {
            return this.setProvider;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, SetBuilderOperator.class.getSimpleName());
            return new SetBuilderOperator(operatorContext, this.setProvider, this.setChannel, this.hashChannel, this.expectedPositions, this.joinCompiler, this.typeOperators);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new SetBuilderOperatorFactory(this.operatorId, this.planNodeId, this.setProvider.getType(), this.setChannel, this.hashChannel, this.expectedPositions, this.joinCompiler, this.typeOperators);
        }
    }
}

