/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxbyn;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.array.ObjectBigArray;
import io.trino.operator.aggregation.minmaxbyn.MinMaxByNState;
import io.trino.operator.aggregation.minmaxbyn.TypedKeyValueHeap;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.GroupedAccumulatorState;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import java.util.function.LongFunction;

public final class MinMaxByNStateFactory {

    public static abstract class SingleMinMaxByNState
    extends AbstractMinMaxByNState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(SingleMinMaxByNState.class);
        private final LongFunction<TypedKeyValueHeap> heapFactory;
        private TypedKeyValueHeap typedHeap;
        private SqlRow tempSerializedState;

        public SingleMinMaxByNState(LongFunction<TypedKeyValueHeap> heapFactory) {
            this.heapFactory = heapFactory;
        }

        protected SingleMinMaxByNState(SingleMinMaxByNState state) {
            Preconditions.checkArgument((state.tempSerializedState == null ? 1 : 0) != 0);
            this.tempSerializedState = null;
            this.heapFactory = state.heapFactory;
            this.typedHeap = state.typedHeap != null ? new TypedKeyValueHeap(state.typedHeap) : null;
        }

        public abstract AccumulatorState copy();

        public final long getEstimatedSize() {
            return (long)INSTANCE_SIZE + (this.typedHeap == null ? 0L : this.typedHeap.getEstimatedSize());
        }

        @Override
        public final void initialize(long n) {
            if (this.typedHeap == null) {
                this.typedHeap = this.heapFactory.apply(n);
            }
        }

        @Override
        public final void add(ValueBlock keyBlock, int keyPosition, ValueBlock valueBlock, int valuePosition) {
            this.typedHeap.add(keyBlock, keyPosition, valueBlock, valuePosition);
        }

        @Override
        public final void popAll(BlockBuilder out) {
            if (this.typedHeap == null || this.typedHeap.isEmpty()) {
                out.appendNull();
                return;
            }
            ((ArrayBlockBuilder)out).buildEntry(this.typedHeap::writeValuesSorted);
        }

        @Override
        final TypedKeyValueHeap getTypedKeyValueHeap() {
            return this.typedHeap;
        }

        void setTempSerializedState(SqlRow tempSerializedState) {
            this.tempSerializedState = tempSerializedState;
        }

        SqlRow removeTempSerializedState() {
            SqlRow sqlRow = this.tempSerializedState;
            Preconditions.checkState((sqlRow != null ? 1 : 0) != 0, (Object)"tempDeserializeBlock is null");
            this.tempSerializedState = null;
            return sqlRow;
        }
    }

    public static abstract class GroupedMinMaxByNState
    extends AbstractMinMaxByNState
    implements GroupedAccumulatorState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(GroupedMinMaxByNState.class);
        private final LongFunction<TypedKeyValueHeap> heapFactory;
        private final ObjectBigArray<TypedKeyValueHeap> heaps = new ObjectBigArray();
        private long groupId;
        private long size;

        public GroupedMinMaxByNState(LongFunction<TypedKeyValueHeap> heapFactory) {
            this.heapFactory = heapFactory;
        }

        public final void setGroupId(long groupId) {
            this.groupId = groupId;
        }

        public final void ensureCapacity(long size) {
            this.heaps.ensureCapacity(size);
        }

        public final long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.heaps.sizeOf() + this.size;
        }

        @Override
        public final void initialize(long n) {
            if (this.getTypedKeyValueHeap() == null) {
                TypedKeyValueHeap typedHeap = this.heapFactory.apply(n);
                this.setTypedKeyValueHeapNew(typedHeap);
                this.size += typedHeap.getEstimatedSize();
            }
        }

        @Override
        public final void add(ValueBlock keyBlock, int keyPosition, ValueBlock valueBlock, int valuePosition) {
            TypedKeyValueHeap typedHeap = this.getTypedKeyValueHeap();
            this.size -= typedHeap.getEstimatedSize();
            typedHeap.add(keyBlock, keyPosition, valueBlock, valuePosition);
            this.size += typedHeap.getEstimatedSize();
        }

        @Override
        public final void popAll(BlockBuilder out) {
            TypedKeyValueHeap typedHeap = this.getTypedKeyValueHeap();
            if (typedHeap == null || typedHeap.isEmpty()) {
                out.appendNull();
                return;
            }
            this.size -= typedHeap.getEstimatedSize();
            ((ArrayBlockBuilder)out).buildEntry(typedHeap::writeValuesSorted);
            this.size += typedHeap.getEstimatedSize();
        }

        @Override
        final TypedKeyValueHeap getTypedKeyValueHeap() {
            return (TypedKeyValueHeap)this.heaps.get(this.groupId);
        }

        private void setTypedKeyValueHeapNew(TypedKeyValueHeap value) {
            this.heaps.set(this.groupId, (Object)value);
        }
    }

    private static abstract class AbstractMinMaxByNState
    implements MinMaxByNState {
        private AbstractMinMaxByNState() {
        }

        abstract TypedKeyValueHeap getTypedKeyValueHeap();

        @Override
        public final void merge(MinMaxByNState other) {
            SqlRow sqlRow = ((SingleMinMaxByNState)other).removeTempSerializedState();
            int rawIndex = sqlRow.getRawIndex();
            int capacity = Math.toIntExact(BigintType.BIGINT.getLong(sqlRow.getRawFieldBlock(0), rawIndex));
            this.initialize(capacity);
            TypedKeyValueHeap typedKeyValueHeap = this.getTypedKeyValueHeap();
            Block keys = new ArrayType(typedKeyValueHeap.getKeyType()).getObject(sqlRow.getRawFieldBlock(1), rawIndex);
            Block values = new ArrayType(typedKeyValueHeap.getValueType()).getObject(sqlRow.getRawFieldBlock(2), rawIndex);
            ValueBlock rawKeyValues = keys.getUnderlyingValueBlock();
            ValueBlock rawValueValues = values.getUnderlyingValueBlock();
            for (int i = 0; i < keys.getPositionCount(); ++i) {
                typedKeyValueHeap.add(rawKeyValues, keys.getUnderlyingValuePosition(i), rawValueValues, values.getUnderlyingValuePosition(i));
            }
        }

        @Override
        public final void serialize(BlockBuilder out) {
            TypedKeyValueHeap typedHeap = this.getTypedKeyValueHeap();
            if (typedHeap == null) {
                out.appendNull();
            } else {
                ((RowBlockBuilder)out).buildEntry(fieldBuilders -> {
                    BigintType.BIGINT.writeLong((BlockBuilder)fieldBuilders.get(0), (long)typedHeap.getCapacity());
                    ArrayBlockBuilder keysColumn = (ArrayBlockBuilder)fieldBuilders.get(1);
                    ArrayBlockBuilder valuesColumn = (ArrayBlockBuilder)fieldBuilders.get(2);
                    keysColumn.buildEntry(keyBuilder -> valuesColumn.buildEntry(valueBuilder -> typedHeap.writeAllUnsorted(keyBuilder, valueBuilder)));
                });
            }
        }
    }
}

