/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.operator.output.PositionsAppender;
import io.trino.operator.output.PositionsAppenderFactory;
import io.trino.operator.output.PositionsAppenderUtil;
import io.trino.operator.output.UnnestingPositionsAppender;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.RowType;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RowPositionsAppender
implements PositionsAppender {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(RowPositionsAppender.class);
    private final RowType type;
    private final UnnestingPositionsAppender[] fieldAppenders;
    private int initialEntryCount;
    private boolean initialized;
    private int positionCount;
    private boolean hasNullRow;
    private boolean hasNonNullRow;
    private boolean[] rowIsNull = new boolean[0];
    private long retainedSizeInBytes = -1L;
    private long sizeInBytes = -1L;

    public static RowPositionsAppender createRowAppender(PositionsAppenderFactory positionsAppenderFactory, RowType type, int expectedPositions, long maxPageSizeInBytes) {
        UnnestingPositionsAppender[] fields = new UnnestingPositionsAppender[type.getFields().size()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = positionsAppenderFactory.create(((RowType.Field)type.getFields().get(i)).getType(), expectedPositions, maxPageSizeInBytes);
        }
        return new RowPositionsAppender(type, fields, expectedPositions);
    }

    private RowPositionsAppender(RowType type, UnnestingPositionsAppender[] fieldAppenders, int expectedPositions) {
        this.type = type;
        this.fieldAppenders = Objects.requireNonNull(fieldAppenders, "fields is null");
        this.initialEntryCount = expectedPositions;
        this.resetSize();
    }

    @Override
    public void append(IntArrayList positions, ValueBlock block) {
        int i;
        Preconditions.checkArgument((boolean)(block instanceof RowBlock), (String)"Block must be instance of %s", RowBlock.class);
        if (positions.isEmpty()) {
            return;
        }
        this.ensureCapacity(positions.size());
        RowBlock sourceRowBlock = (RowBlock)block;
        for (i = 0; i < this.fieldAppenders.length; ++i) {
            this.fieldAppenders[i].append(positions, sourceRowBlock.getFieldBlock(i));
        }
        if (sourceRowBlock.mayHaveNull()) {
            for (i = 0; i < positions.size(); ++i) {
                boolean positionIsNull;
                this.rowIsNull[this.positionCount + i] = positionIsNull = sourceRowBlock.isNull(positions.getInt(i));
                this.hasNullRow |= positionIsNull;
                this.hasNonNullRow |= !positionIsNull;
            }
        } else {
            this.hasNonNullRow = true;
        }
        this.positionCount += positions.size();
        this.resetSize();
    }

    @Override
    public void appendRle(ValueBlock value, int rlePositionCount) {
        Preconditions.checkArgument((boolean)(value instanceof RowBlock), (String)"Block must be instance of %s", RowBlock.class);
        this.ensureCapacity(rlePositionCount);
        RowBlock sourceRowBlock = (RowBlock)value;
        List fieldBlocks = sourceRowBlock.getFieldBlocks();
        for (int i = 0; i < this.fieldAppenders.length; ++i) {
            this.fieldAppenders[i].appendRle(((Block)fieldBlocks.get(i)).getSingleValueBlock(0), rlePositionCount);
        }
        if (sourceRowBlock.isNull(0)) {
            Arrays.fill(this.rowIsNull, this.positionCount, this.positionCount + rlePositionCount, true);
            this.hasNullRow = true;
        } else {
            this.hasNonNullRow = true;
        }
        this.positionCount += rlePositionCount;
        this.resetSize();
    }

    @Override
    public void append(int position, ValueBlock value) {
        Preconditions.checkArgument((boolean)(value instanceof RowBlock), (String)"Block must be instance of %s", RowBlock.class);
        this.ensureCapacity(1);
        RowBlock sourceRowBlock = (RowBlock)value;
        List fieldBlocks = sourceRowBlock.getChildren();
        for (int i = 0; i < this.fieldAppenders.length; ++i) {
            this.fieldAppenders[i].append(position, (Block)fieldBlocks.get(i));
        }
        if (sourceRowBlock.isNull(position)) {
            this.rowIsNull[this.positionCount] = true;
            this.hasNullRow = true;
        } else {
            this.hasNonNullRow = true;
        }
        ++this.positionCount;
        this.resetSize();
    }

    @Override
    public Block build() {
        RowBlock result;
        if (this.hasNonNullRow) {
            Block[] fieldBlocks = new Block[this.fieldAppenders.length];
            for (int i = 0; i < this.fieldAppenders.length; ++i) {
                fieldBlocks[i] = this.fieldAppenders[i].build();
            }
            result = RowBlock.fromNotNullSuppressedFieldBlocks((int)this.positionCount, this.hasNullRow ? Optional.of(this.rowIsNull) : Optional.empty(), (Block[])fieldBlocks);
        } else {
            for (UnnestingPositionsAppender fieldAppender : this.fieldAppenders) {
                fieldAppender.reset();
            }
            if (this.hasNullRow) {
                Block nullRowBlock = this.type.createBlockBuilder(null, 0).appendNull().build();
                result = RunLengthEncodedBlock.create((Block)nullRowBlock, (int)this.positionCount);
            } else {
                result = this.type.createBlockBuilder(null, 0).build();
            }
        }
        this.reset();
        return result;
    }

    @Override
    public long getRetainedSizeInBytes() {
        if (this.retainedSizeInBytes != -1L) {
            return this.retainedSizeInBytes;
        }
        long size = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.rowIsNull);
        for (UnnestingPositionsAppender field : this.fieldAppenders) {
            size += field.getRetainedSizeInBytes();
        }
        this.retainedSizeInBytes = size;
        return size;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes != -1L) {
            return this.sizeInBytes;
        }
        long size = 5L * (long)this.positionCount;
        for (UnnestingPositionsAppender field : this.fieldAppenders) {
            size += field.getSizeInBytes();
        }
        this.sizeInBytes = size;
        return this.sizeInBytes;
    }

    @Override
    public void reset() {
        for (UnnestingPositionsAppender field : this.fieldAppenders) {
            field.reset();
        }
        this.initialEntryCount = PositionsAppenderUtil.calculateBlockResetSize(this.positionCount);
        this.initialized = false;
        this.rowIsNull = new boolean[0];
        this.positionCount = 0;
        this.hasNonNullRow = false;
        this.hasNullRow = false;
        this.resetSize();
    }

    private void ensureCapacity(int additionalCapacity) {
        if (this.rowIsNull.length <= this.positionCount + additionalCapacity) {
            int newSize;
            if (this.initialized) {
                newSize = PositionsAppenderUtil.calculateNewArraySize(this.rowIsNull.length);
            } else {
                newSize = this.initialEntryCount;
                this.initialized = true;
            }
            int newCapacity = Math.max(newSize, this.positionCount + additionalCapacity);
            this.rowIsNull = Arrays.copyOf(this.rowIsNull, newCapacity);
            this.resetSize();
        }
    }

    private void resetSize() {
        this.sizeInBytes = -1L;
        this.retainedSizeInBytes = -1L;
    }
}

