/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.List;

public class ArraySubscriptOperator
extends SqlScalarFunction {
    public static final ArraySubscriptOperator ARRAY_SUBSCRIPT = new ArraySubscriptOperator();
    private static final MethodHandle GET_POSITION;
    private static final MethodHandle IS_POSITION_NULL;

    private ArraySubscriptOperator() {
        super(FunctionMetadata.operatorBuilder((OperatorType)OperatorType.SUBSCRIPT).signature(Signature.builder().typeVariable("E").returnType(new TypeSignature("E", new TypeSignatureParameter[0])).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))).argumentType((Type)BigintType.BIGINT).build()).nullable().build());
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        return FunctionDependencyDeclaration.builder().addOperatorSignature(OperatorType.READ_VALUE, (List)ImmutableList.of((Object)new TypeSignature("E", new TypeSignatureParameter[0]))).build();
    }

    @Override
    public SpecializedSqlScalarFunction specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        Type elementType = boundSignature.getReturnType();
        MethodHandle methodHandle = functionDependencies.getOperatorImplementation(OperatorType.READ_VALUE, (List)ImmutableList.of((Object)elementType), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL})).getMethodHandle();
        TypeDescriptor.OfField expectedReturnType = MethodType.methodType(elementType.getJavaType()).wrap().returnType();
        methodHandle = MethodHandles.explicitCastArguments(methodHandle, methodHandle.type().changeReturnType((Class<?>)expectedReturnType));
        methodHandle = MethodHandles.guardWithTest(IS_POSITION_NULL, MethodHandles.empty(methodHandle.type()), methodHandle);
        methodHandle = MethodHandles.collectArguments(methodHandle, 1, GET_POSITION);
        methodHandle = MethodHandles.permuteArguments(methodHandle, methodHandle.type().dropParameterTypes(1, 2), 0, 0, 1);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    private static int getPosition(Block array, long index) {
        ArraySubscriptOperator.checkArrayIndex(index);
        if (index > (long)array.getPositionCount()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Array subscript must be less than or equal to array length: %s > %s", index, array.getPositionCount()));
        }
        int position = Math.toIntExact(index - 1L);
        return position;
    }

    public static void checkArrayIndex(long index) {
        if (index == 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "SQL array indices start at 1");
        }
        if (index < 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array subscript is negative: " + index);
        }
    }

    static {
        try {
            GET_POSITION = MethodHandles.lookup().findStatic(ArraySubscriptOperator.class, "getPosition", MethodType.methodType(Integer.TYPE, Block.class, Long.TYPE));
            IS_POSITION_NULL = MethodHandles.lookup().findVirtual(Block.class, "isNull", MethodType.methodType(Boolean.TYPE, Integer.TYPE));
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

