/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.re2j.Matcher;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedArrayValueBuilder;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.lambda.UnaryFunctionInterface;
import io.trino.type.Re2JRegexp;

@ScalarFunction(value="regexp_replace")
@Description(value="Replaces substrings matching a regular expression using a lambda function")
public final class Re2JRegexpReplaceLambdaFunction {
    private final BufferedArrayValueBuilder arrayValueBuilder = BufferedArrayValueBuilder.createBuffered((ArrayType)new ArrayType((Type)VarcharType.VARCHAR));

    @LiteralParameters(value={"x"})
    @SqlType(value="varchar")
    @SqlNullable
    public Slice regexpReplace(@SqlType(value="varchar") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern, @SqlType(value="function(array(varchar), varchar(x))") UnaryFunctionInterface replaceFunction) {
        Matcher matcher = pattern.matcher(source);
        if (!matcher.find()) {
            return source;
        }
        DynamicSliceOutput output = new DynamicSliceOutput(source.length());
        int groupCount = matcher.groupCount();
        int appendPosition = 0;
        do {
            int start = matcher.start();
            int end = matcher.end();
            if (appendPosition < start) {
                output.writeBytes(source, appendPosition, start - appendPosition);
            }
            appendPosition = end;
            Block target = this.arrayValueBuilder.build(groupCount, elementBuilder -> {
                for (int i = 1; i <= groupCount; ++i) {
                    Slice matchedGroupSlice = matcher.group(i);
                    if (matchedGroupSlice != null) {
                        VarcharType.VARCHAR.writeSlice(elementBuilder, matchedGroupSlice);
                        continue;
                    }
                    elementBuilder.appendNull();
                }
            });
            Slice replaced = (Slice)replaceFunction.apply(target);
            if (replaced == null) {
                return null;
            }
            output.appendBytes(replaced);
        } while (matcher.find());
        output.writeBytes(source, appendPosition, source.length() - appendPosition);
        return output.slice();
    }
}

