/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.type.UnknownType;
import java.util.Map;
import java.util.Set;

public final class Coercer {
    private Coercer() {
    }

    public static Expression addCoercions(Expression expression, Analysis analysis) {
        return Coercer.addCoercions(expression, analysis.getCoercions(), analysis.getTypeOnlyCoercions());
    }

    public static Expression addCoercions(Expression expression, Map<NodeRef<Expression>, Type> coercions, Set<NodeRef<Expression>> typeOnlyCoercions) {
        Preconditions.checkArgument((boolean)coercions.values().stream().noneMatch(arg_0 -> ((UnknownType)UnknownType.UNKNOWN).equals(arg_0)), (Object)"Cannot add coercion to UNKNOWN");
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Rewriter(coercions, typeOnlyCoercions), (Expression)expression);
    }

    private static class Rewriter
    extends ExpressionRewriter<Void> {
        private final Map<NodeRef<Expression>, Type> coercions;
        private final Set<NodeRef<Expression>> typeOnlyCoercions;

        public Rewriter(Map<NodeRef<Expression>, Type> coercions, Set<NodeRef<Expression>> typeOnlyCoercions) {
            this.coercions = coercions;
            this.typeOnlyCoercions = typeOnlyCoercions;
        }

        protected Expression rewriteExpression(Expression expression, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Type target = this.coercions.get(NodeRef.of((Node)expression));
            Expression rewritten = treeRewriter.defaultRewrite(expression, null);
            if (target != null) {
                rewritten = new Cast(rewritten, TypeSignatureTranslator.toSqlType(target), false, this.typeOnlyCoercions.contains(NodeRef.of((Node)expression)));
            }
            return rewritten;
        }
    }
}

