/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableLayout;
import io.trino.metadata.TableMetadata;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarbinaryType;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.NodeUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.FieldId;
import io.trino.sql.analyzer.RelationType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.GroupingOperationRewriter;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.MergePartitioningHandle;
import io.trino.sql.planner.NodeAndMappings;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanBuilder;
import io.trino.sql.planner.PlanCopier;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.RelationPlan;
import io.trino.sql.planner.RelationPlanner;
import io.trino.sql.planner.ScopeAware;
import io.trino.sql.planner.SubqueryPlanner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TranslationMap;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.MergeProcessorNode;
import io.trino.sql.planner.plan.MergeWriterNode;
import io.trino.sql.planner.plan.OffsetNode;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.plan.SimplePlanRewriter;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.Delete;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FetchFirst;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.GroupBy;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.Join;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.Merge;
import io.trino.sql.tree.MergeCase;
import io.trino.sql.tree.MergeDelete;
import io.trino.sql.tree.MergeInsert;
import io.trino.sql.tree.MergeUpdate;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Offset;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.QuerySpecification;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.Union;
import io.trino.sql.tree.Update;
import io.trino.sql.tree.UpdateAssignment;
import io.trino.sql.tree.VariableDefinition;
import io.trino.sql.tree.WhenClause;
import io.trino.sql.tree.WindowFrame;
import io.trino.sql.tree.WindowOperation;
import io.trino.type.IntervalDayTimeType;
import io.trino.type.IntervalYearMonthType;
import io.trino.type.TypeCoercion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class QueryPlanner {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap;
    private final PlannerContext plannerContext;
    private final TypeCoercion typeCoercion;
    private final Session session;
    private final SubqueryPlanner subqueryPlanner;
    private final Optional<TranslationMap> outerContext;
    private final Map<NodeRef<Node>, RelationPlan> recursiveSubqueries;

    QueryPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap, PlannerContext plannerContext, Optional<TranslationMap> outerContext, Session session, Map<NodeRef<Node>, RelationPlan> recursiveSubqueries) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(lambdaDeclarationToSymbolMap, "lambdaDeclarationToSymbolMap is null");
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(outerContext, "outerContext is null");
        Objects.requireNonNull(recursiveSubqueries, "recursiveSubqueries is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.lambdaDeclarationToSymbolMap = lambdaDeclarationToSymbolMap;
        this.plannerContext = plannerContext;
        this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0));
        this.session = session;
        this.outerContext = outerContext;
        this.subqueryPlanner = new SubqueryPlanner(analysis, symbolAllocator, idAllocator, lambdaDeclarationToSymbolMap, plannerContext, this.typeCoercion, outerContext, session, recursiveSubqueries);
        this.recursiveSubqueries = recursiveSubqueries;
    }

    public RelationPlan plan(Query query) {
        PlanBuilder builder = this.planQueryBody(query);
        List<Expression> orderBy = this.analysis.getOrderByExpressions((Node)query);
        builder = this.subqueryPlanner.handleSubqueries(builder, orderBy, this.analysis.getSubqueries((Node)query));
        List<Analysis.SelectExpression> selectExpressions = this.analysis.getSelectExpressions((Node)query);
        List outputs = (List)selectExpressions.stream().map(Analysis.SelectExpression::getExpression).collect(ImmutableList.toImmutableList());
        builder = builder.appendProjections(Iterables.concat(orderBy, (Iterable)outputs), this.symbolAllocator, this.idAllocator);
        Optional<OrderingScheme> orderingScheme = this.orderingScheme(builder, query.getOrderBy(), this.analysis.getOrderByExpressions((Node)query));
        builder = this.sort(builder, orderingScheme);
        builder = this.offset(builder, query.getOffset());
        builder = this.limit(builder, query.getLimit(), orderingScheme);
        builder = builder.appendProjections(outputs, this.symbolAllocator, this.idAllocator);
        return new RelationPlan(builder.getRoot(), this.analysis.getScope((Node)query), QueryPlanner.computeOutputs(builder, outputs), this.outerContext);
    }

    public RelationPlan planExpand(Query query) {
        Preconditions.checkArgument((boolean)this.analysis.isExpandableQuery(query), (Object)"query is not registered as expandable");
        Union union = (Union)query.getQueryBody();
        ImmutableList.Builder recursionSteps = ImmutableList.builder();
        Relation anchorNode = (Relation)union.getRelations().get(0);
        RelationPlan anchorPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).process((Node)anchorNode, null);
        NodeAndMappings prunedAnchorPlan = QueryPlanner.pruneInvisibleFields(anchorPlan, this.idAllocator);
        NodeAndMappings disambiguatedAnchorPlan = QueryPlanner.disambiguateOutputs(prunedAnchorPlan, this.symbolAllocator, this.idAllocator);
        anchorPlan = new RelationPlan(disambiguatedAnchorPlan.getNode(), this.analysis.getScope((Node)query), disambiguatedAnchorPlan.getFields(), this.outerContext);
        recursionSteps.add((Object)this.copy(anchorPlan.getRoot(), anchorPlan.getFieldMappings()));
        Relation recursionStepRelation = (Relation)union.getRelations().get(1);
        RelationPlan recursionStepPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, (Map<NodeRef<Node>, RelationPlan>)ImmutableMap.of((Object)NodeRef.of((Node)this.analysis.getRecursiveReference(query)), (Object)anchorPlan)).process((Node)recursionStepRelation, null);
        List<Type> types = this.analysis.getRelationCoercion(recursionStepRelation);
        NodeAndMappings coercedRecursionStep = types == null ? QueryPlanner.pruneInvisibleFields(recursionStepPlan, this.idAllocator) : QueryPlanner.coerce(recursionStepPlan, types, this.symbolAllocator, this.idAllocator);
        NodeAndMappings replacementSpot = new NodeAndMappings(anchorPlan.getRoot(), anchorPlan.getFieldMappings());
        PlanNode recursionStep = coercedRecursionStep.getNode();
        List<Symbol> mappings = coercedRecursionStep.getFields();
        int maxRecursionDepth = SystemSessionProperties.getMaxRecursionDepth(this.session);
        for (int i = 0; i < maxRecursionDepth; ++i) {
            recursionSteps.add((Object)this.copy(recursionStep, mappings));
            NodeAndMappings replacement = this.copy(recursionStep, mappings);
            replacement = QueryPlanner.disambiguateOutputs(replacement, this.symbolAllocator, this.idAllocator);
            recursionStep = this.replace(recursionStep, replacementSpot, replacement);
            replacementSpot = replacement;
        }
        NodeAndMappings checkConvergenceStep = this.copy(recursionStep, mappings);
        Symbol countSymbol = this.symbolAllocator.newSymbol("count", (Type)BigintType.BIGINT);
        ResolvedFunction function = this.plannerContext.getMetadata().resolveBuiltinFunction("count", (List<TypeSignatureProvider>)ImmutableList.of());
        WindowNode.Function countFunction = new WindowNode.Function(function, (List<Expression>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME, false);
        WindowNode windowNode = new WindowNode(this.idAllocator.getNextId(), checkConvergenceStep.getNode(), new DataOrganizationSpecification((List<Symbol>)ImmutableList.of(), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)countSymbol, (Object)countFunction), Optional.empty(), (Set<Symbol>)ImmutableSet.of(), 0);
        String recursionLimitExceededMessage = String.format("Recursion depth limit exceeded (%s). Use 'max_recursion_depth' session property to modify the limit.", maxRecursionDepth);
        IfExpression predicate = new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)countSymbol.toSymbolReference(), (Expression)new GenericLiteral("BIGINT", "0")), (Expression)new Cast((Expression)LogicalPlanner.failFunction(this.plannerContext.getMetadata(), (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, recursionLimitExceededMessage), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN)), (Expression)BooleanLiteral.TRUE_LITERAL);
        FilterNode filterNode = new FilterNode(this.idAllocator.getNextId(), windowNode, (Expression)predicate);
        recursionSteps.add((Object)new NodeAndMappings(filterNode, checkConvergenceStep.getFields()));
        ImmutableList recursionStepsToUnion = recursionSteps.build();
        List unionOutputSymbols = (List)anchorPlan.getFieldMappings().stream().map(symbol -> this.symbolAllocator.newSymbol((Symbol)symbol, "_expanded")).collect(ImmutableList.toImmutableList());
        ImmutableListMultimap.Builder unionSymbolMapping = ImmutableListMultimap.builder();
        for (NodeAndMappings plan : recursionStepsToUnion) {
            for (int i = 0; i < unionOutputSymbols.size(); ++i) {
                unionSymbolMapping.put((Object)((Symbol)unionOutputSymbols.get(i)), (Object)plan.getFields().get(i));
            }
        }
        List nodesToUnion = (List)recursionStepsToUnion.stream().map(NodeAndMappings::getNode).collect(ImmutableList.toImmutableList());
        PlanNode result = new UnionNode(this.idAllocator.getNextId(), nodesToUnion, (ListMultimap<Symbol, Symbol>)unionSymbolMapping.build(), unionOutputSymbols);
        if (union.isDistinct()) {
            result = AggregationNode.singleAggregation(this.idAllocator.getNextId(), result, (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), AggregationNode.singleGroupingSet(((PlanNode)result).getOutputSymbols()));
        }
        return new RelationPlan(result, anchorPlan.getScope(), unionOutputSymbols, this.outerContext);
    }

    private NodeAndMappings copy(PlanNode plan, List<Symbol> fields) {
        return PlanCopier.copyPlan(plan, fields, this.plannerContext.getMetadata(), this.symbolAllocator, this.idAllocator);
    }

    private PlanNode replace(PlanNode plan, final NodeAndMappings replacementSpot, final NodeAndMappings replacement) {
        Preconditions.checkArgument((replacementSpot.getFields().size() == replacement.getFields().size() ? 1 : 0) != 0, (String)"mismatching outputs in replacement, expected: %s, got: %s", (int)replacementSpot.getFields().size(), (int)replacement.getFields().size());
        return SimplePlanRewriter.rewriteWith(new SimplePlanRewriter<Void>(){

            @Override
            protected PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
                return node.replaceChildren((List)node.getSources().stream().map(child -> {
                    if (child == replacementSpot.getNode()) {
                        Assignments.Builder assignments = Assignments.builder();
                        for (int i = 0; i < replacementSpot.getFields().size(); ++i) {
                            assignments.put(replacementSpot.getFields().get(i), (Expression)replacement.getFields().get(i).toSymbolReference());
                        }
                        return new ProjectNode(QueryPlanner.this.idAllocator.getNextId(), replacement.getNode(), assignments.build());
                    }
                    return context.rewrite((PlanNode)child);
                }).collect(ImmutableList.toImmutableList()));
            }
        }, plan, null);
    }

    public RelationPlan plan(QuerySpecification node) {
        PlanBuilder builder = this.planFrom(node);
        builder = this.filter(builder, this.analysis.getWhere(node), (Node)node);
        builder = this.aggregate(builder, node);
        builder = this.filter(builder, this.analysis.getHaving(node), (Node)node);
        builder = this.planWindowFunctions((Node)node, builder, (List<FunctionCall>)ImmutableList.copyOf(this.analysis.getWindowFunctions(node)));
        builder = this.planWindowMeasures((Node)node, builder, (List<WindowOperation>)ImmutableList.copyOf(this.analysis.getWindowMeasures(node)));
        List<Analysis.SelectExpression> selectExpressions = this.analysis.getSelectExpressions((Node)node);
        List expressions = (List)selectExpressions.stream().map(Analysis.SelectExpression::getExpression).collect(ImmutableList.toImmutableList());
        builder = this.subqueryPlanner.handleSubqueries(builder, expressions, this.analysis.getSubqueries((Node)node));
        if (QueryPlanner.hasExpressionsToUnfold(selectExpressions)) {
            builder = builder.appendProjections(expressions, this.symbolAllocator, this.idAllocator);
        }
        List<Expression> outputs = QueryPlanner.outputExpressions(selectExpressions);
        if (node.getOrderBy().isPresent()) {
            if (this.analysis.isAggregation(node)) {
                List<Expression> orderByAggregates = this.analysis.getOrderByAggregates((OrderBy)node.getOrderBy().get());
                builder = builder.appendProjections(orderByAggregates, this.symbolAllocator, this.idAllocator);
            }
            builder = builder.appendProjections(outputs, this.symbolAllocator, this.idAllocator);
            ArrayList<Symbol> newFields = new ArrayList<Symbol>();
            newFields.addAll(builder.getTranslations().getFieldSymbols());
            outputs.stream().map(builder::translate).forEach(newFields::add);
            builder = builder.withScope(this.analysis.getScope((Node)node.getOrderBy().get()), newFields);
            builder = this.planWindowFunctions((Node)node, builder, (List<FunctionCall>)ImmutableList.copyOf(this.analysis.getOrderByWindowFunctions((OrderBy)node.getOrderBy().get())));
            builder = this.planWindowMeasures((Node)node, builder, (List<WindowOperation>)ImmutableList.copyOf(this.analysis.getOrderByWindowMeasures((OrderBy)node.getOrderBy().get())));
        }
        List<Expression> orderBy = this.analysis.getOrderByExpressions((Node)node);
        builder = this.subqueryPlanner.handleSubqueries(builder, orderBy, this.analysis.getSubqueries((Node)node));
        builder = builder.appendProjections(Iterables.concat(orderBy, outputs), this.symbolAllocator, this.idAllocator);
        builder = this.distinct(builder, node, outputs);
        Optional<OrderingScheme> orderingScheme = this.orderingScheme(builder, node.getOrderBy(), this.analysis.getOrderByExpressions((Node)node));
        builder = this.sort(builder, orderingScheme);
        builder = this.offset(builder, node.getOffset());
        builder = this.limit(builder, node.getLimit(), orderingScheme);
        builder = builder.appendProjections(outputs, this.symbolAllocator, this.idAllocator);
        return new RelationPlan(builder.getRoot(), this.analysis.getScope((Node)node), QueryPlanner.computeOutputs(builder, outputs), this.outerContext);
    }

    private static boolean hasExpressionsToUnfold(List<Analysis.SelectExpression> selectExpressions) {
        return selectExpressions.stream().map(Analysis.SelectExpression::getUnfoldedExpressions).anyMatch(Optional::isPresent);
    }

    private static List<Expression> outputExpressions(List<Analysis.SelectExpression> selectExpressions) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Analysis.SelectExpression selectExpression : selectExpressions) {
            if (selectExpression.getUnfoldedExpressions().isPresent()) {
                result.addAll((Iterable)selectExpression.getUnfoldedExpressions().get());
                continue;
            }
            result.add((Object)selectExpression.getExpression());
        }
        return result.build();
    }

    public PlanNode plan(Delete node) {
        Table table = node.getTable();
        TableHandle handle = this.analysis.getTableHandle(table);
        RelationPlan relationPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).process((Node)table, null);
        PlanBuilder builder = PlanBuilder.newPlanBuilder(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext);
        if (node.getWhere().isPresent()) {
            builder = this.filter(builder, (Expression)node.getWhere().get(), (Node)node);
        }
        FieldReference reference = this.analysis.getRowIdField(table);
        Symbol rowIdSymbol = builder.translate((Expression)reference);
        ImmutableList outputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), (Object)this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY));
        TableMetadata tableMetadata = this.plannerContext.getMetadata().getTableMetadata(this.session, handle);
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        ImmutableList.Builder namesBuilder = ImmutableList.builder();
        tableMetadata.getMetadata().getColumns().stream().filter(column -> !column.isHidden()).forEach(columnMetadata -> {
            typeBuilder.add((Object)columnMetadata.getType());
            namesBuilder.add((Object)columnMetadata.getName());
        });
        Type rowIdType = this.analysis.getType((Expression)this.analysis.getRowIdField(table));
        TableWriterNode.MergeParadigmAndTypes paradigmAndTypes = new TableWriterNode.MergeParadigmAndTypes(Optional.empty(), (List<Type>)typeBuilder.build(), (List<String>)namesBuilder.build(), rowIdType);
        Analysis.MergeAnalysis mergeAnalysis = this.analysis.getMergeAnalysis().orElseThrow(() -> new IllegalArgumentException("Didn't find mergeAnalysis in analysis"));
        Assignments.Builder assignmentsBuilder = new Assignments.Builder();
        ImmutableList.Builder columnSymbolsBuilder = ImmutableList.builder();
        for (ColumnHandle columnHandle : mergeAnalysis.getDataColumnHandles()) {
            int fieldIndex = Objects.requireNonNull(mergeAnalysis.getColumnHandleFieldNumbers().get(columnHandle), "Could not find field number for column handle");
            Symbol symbol = relationPlan.getFieldMappings().get(fieldIndex);
            columnSymbolsBuilder.add((Object)symbol);
            if (mergeAnalysis.getRedistributionColumnHandles().contains(columnHandle)) {
                assignmentsBuilder.putIdentity(symbol);
                continue;
            }
            assignmentsBuilder.put(symbol, (Expression)new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType(this.symbolAllocator.getTypes().get(symbol))));
        }
        ImmutableList columnSymbols = columnSymbolsBuilder.build();
        Symbol operationSymbol = this.symbolAllocator.newSymbol("operation", (Type)TinyintType.TINYINT);
        assignmentsBuilder.put(operationSymbol, (Expression)new GenericLiteral("TINYINT", String.valueOf(2)));
        Symbol projectedRowIdSymbol = this.symbolAllocator.newSymbol(rowIdSymbol.getName(), rowIdType);
        assignmentsBuilder.put(projectedRowIdSymbol, (Expression)rowIdSymbol.toSymbolReference());
        assignmentsBuilder.put(this.symbolAllocator.newSymbol("insert_from_update", (Type)TinyintType.TINYINT), (Expression)new GenericLiteral("TINYINT", "0"));
        Assignments assignments = assignmentsBuilder.build();
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), builder.getRoot(), assignments);
        Optional<PartitioningScheme> partitioningScheme = QueryPlanner.createMergePartitioningScheme(mergeAnalysis.getInsertLayout(), (List<Symbol>)columnSymbols, mergeAnalysis.getInsertPartitioningArgumentIndexes(), mergeAnalysis.getUpdateLayout(), projectedRowIdSymbol, operationSymbol);
        return new MergeWriterNode(this.idAllocator.getNextId(), projectNode, new TableWriterNode.MergeTarget(handle, Optional.empty(), tableMetadata.getTable(), paradigmAndTypes), projectNode.getOutputSymbols(), partitioningScheme, (List<Symbol>)outputs);
    }

    public PlanNode plan(Update node) {
        Analysis.MergeAnalysis mergeAnalysis = this.analysis.getMergeAnalysis().orElseThrow();
        Table table = mergeAnalysis.getTargetTable();
        List<ColumnSchema> dataColumnSchemas = mergeAnalysis.getDataColumnSchemas();
        List<ColumnHandle> dataColumnHandles = mergeAnalysis.getDataColumnHandles();
        List<ColumnHandle> updatedColumnHandles = mergeAnalysis.getMergeCaseColumnHandles().get(0);
        ImmutableMap.Builder nameToHandleBuilder = ImmutableMap.builder();
        for (int columnIndex = 0; columnIndex < mergeAnalysis.getDataColumnSchemas().size(); ++columnIndex) {
            nameToHandleBuilder.put((Object)dataColumnSchemas.get(columnIndex).getName(), (Object)dataColumnHandles.get(columnIndex));
        }
        ImmutableMap nameToHandle = nameToHandleBuilder.buildOrThrow();
        Expression[] orderedColumnValuesArray = new Expression[updatedColumnHandles.size()];
        node.getAssignments().forEach(arg_0 -> QueryPlanner.lambda$plan$4((Map)nameToHandle, updatedColumnHandles, orderedColumnValuesArray, arg_0));
        List<Expression> orderedColumnValues = Arrays.stream(orderedColumnValuesArray).toList();
        RelationPlan relationPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).process((Node)table, null);
        PlanBuilder subPlanBuilder = PlanBuilder.newPlanBuilder(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext);
        if (node.getWhere().isPresent()) {
            subPlanBuilder = this.filter(subPlanBuilder, (Expression)node.getWhere().get(), (Node)node);
        }
        subPlanBuilder = this.subqueryPlanner.handleSubqueries(subPlanBuilder, orderedColumnValues, this.analysis.getSubqueries((Node)node));
        Metadata metadata = this.plannerContext.getMetadata();
        ImmutableList.Builder rowBuilder = ImmutableList.builder();
        Assignments.Builder assignments = Assignments.builder();
        for (int columnIndex = 0; columnIndex < mergeAnalysis.getDataColumnHandles().size(); ++columnIndex) {
            ColumnHandle dataColumnHandle = mergeAnalysis.getDataColumnHandles().get(columnIndex);
            ColumnSchema columnSchema = mergeAnalysis.getDataColumnSchemas().get(columnIndex);
            int fieldNumber = mergeAnalysis.getColumnHandleFieldNumbers().get(dataColumnHandle);
            Symbol field = relationPlan.getFieldMappings().get(fieldNumber);
            int index = updatedColumnHandles.indexOf(dataColumnHandle);
            if (index >= 0) {
                Expression original = orderedColumnValues.get(index);
                Expression setExpression = QueryPlanner.coerceIfNecessary(this.analysis, original, original);
                subPlanBuilder = this.subqueryPlanner.handleSubqueries(subPlanBuilder, setExpression, this.analysis.getSubqueries((Node)node));
                Object rewritten = subPlanBuilder.rewrite(setExpression);
                if (mergeAnalysis.getNonNullableColumnHandles().contains(dataColumnHandle)) {
                    String columnName = columnSchema.getName();
                    rewritten = new CoalesceExpression((Expression)rewritten, (Expression)new Cast((Expression)LogicalPlanner.failFunction(metadata, (ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "NULL value not allowed for NOT NULL column: " + columnName), TypeSignatureTranslator.toSqlType(columnSchema.getType())), new Expression[0]);
                }
                rowBuilder.add(rewritten);
                assignments.put(field, (Expression)rewritten);
                continue;
            }
            rowBuilder.add((Object)field.toSymbolReference());
            assignments.putIdentity(field);
        }
        FieldReference rowIdReference = this.analysis.getRowIdField(mergeAnalysis.getTargetTable());
        assignments.putIdentity(relationPlan.getFieldMappings().get(rowIdReference.getFieldIndex()));
        rowBuilder.add((Object)new GenericLiteral("BOOLEAN", "TRUE"));
        rowBuilder.add((Object)new GenericLiteral("TINYINT", String.valueOf(3)));
        rowBuilder.add((Object)new GenericLiteral("INTEGER", "0"));
        Row mergeRow = new Row((List)rowBuilder.build());
        List<Expression> constraints = this.analysis.getCheckConstraints(table);
        if (!constraints.isEmpty()) {
            subPlanBuilder = subPlanBuilder.withNewRoot(new ProjectNode(this.idAllocator.getNextId(), subPlanBuilder.getRoot(), assignments.build()));
            subPlanBuilder = this.addCheckConstraints(constraints, subPlanBuilder);
        }
        Symbol rowIdSymbol = relationPlan.getFieldMappings().get(rowIdReference.getFieldIndex());
        Symbol mergeRowSymbol = this.symbolAllocator.newSymbol("merge_row", (Type)mergeAnalysis.getMergeRowType());
        Symbol caseNumberSymbol = this.symbolAllocator.newSymbol("case_number", (Type)IntegerType.INTEGER);
        Symbol isDistinctSymbol = this.symbolAllocator.newSymbol("is_distinct", (Type)BooleanType.BOOLEAN);
        Assignments.Builder projectionAssignmentsBuilder = Assignments.builder();
        for (ColumnHandle column : mergeAnalysis.getRedistributionColumnHandles()) {
            int fieldIndex = Objects.requireNonNull(mergeAnalysis.getColumnHandleFieldNumbers().get(column), "Could not find fieldIndex for redistribution column");
            Symbol symbol = relationPlan.getFieldMappings().get(fieldIndex);
            projectionAssignmentsBuilder.putIdentity(symbol);
        }
        projectionAssignmentsBuilder.putIdentity(rowIdSymbol);
        projectionAssignmentsBuilder.put(mergeRowSymbol, (Expression)mergeRow);
        projectionAssignmentsBuilder.put(caseNumberSymbol, (Expression)new GenericLiteral("INTEGER", "0"));
        projectionAssignmentsBuilder.put(isDistinctSymbol, (Expression)BooleanLiteral.TRUE_LITERAL);
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), subPlanBuilder.getRoot(), projectionAssignmentsBuilder.build());
        return this.createMergePipeline(table, relationPlan, projectNode, rowIdSymbol, mergeRowSymbol);
    }

    private PlanBuilder addCheckConstraints(List<Expression> constraints, PlanBuilder subPlanBuilder) {
        PlanBuilder constraintBuilder = subPlanBuilder.appendProjections(constraints, this.symbolAllocator, this.idAllocator);
        ArrayList<Expression> predicates = new ArrayList<Expression>();
        for (Expression constraint : constraints) {
            SymbolReference symbol = constraintBuilder.translate(constraint).toSymbolReference();
            IfExpression predicate = new IfExpression((Expression)new CoalesceExpression(QueryPlanner.coerceIfNecessary(this.analysis, (Expression)symbol, (Expression)symbol), (Expression)BooleanLiteral.TRUE_LITERAL, new Expression[0]), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Cast((Expression)LogicalPlanner.failFunction(this.plannerContext.getMetadata(), (ErrorCodeSupplier)StandardErrorCode.CONSTRAINT_VIOLATION, "Check constraint violation: " + String.valueOf(constraint)), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN)));
            predicates.add((Expression)predicate);
        }
        return subPlanBuilder.withNewRoot(new FilterNode(this.idAllocator.getNextId(), constraintBuilder.getRoot(), ExpressionUtils.and(predicates)));
    }

    public MergeWriterNode plan(Merge merge) {
        Analysis.MergeAnalysis mergeAnalysis = this.analysis.getMergeAnalysis().orElseThrow(() -> new IllegalArgumentException("analysis.getMergeAnalysis() isn't present"));
        List<List<ColumnHandle>> mergeCaseColumnsHandles = mergeAnalysis.getMergeCaseColumnHandles();
        RelationPlan targetTablePlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).process((Node)merge.getTarget());
        Symbol uniqueIdSymbol = this.symbolAllocator.newSymbol("unique_id", (Type)BigintType.BIGINT);
        RelationPlan planWithUniqueId = new RelationPlan(new AssignUniqueId(this.idAllocator.getNextId(), targetTablePlan.getRoot(), uniqueIdSymbol), mergeAnalysis.getTargetTableScope(), targetTablePlan.getFieldMappings(), this.outerContext);
        Assignments.Builder projections = Assignments.builder();
        projections.putIdentities(planWithUniqueId.getRoot().getOutputSymbols());
        Symbol presentColumn = this.symbolAllocator.newSymbol("present", (Type)BooleanType.BOOLEAN);
        projections.put(presentColumn, (Expression)BooleanLiteral.TRUE_LITERAL);
        RelationPlan planWithPresentColumn = new RelationPlan(new ProjectNode(this.idAllocator.getNextId(), planWithUniqueId.getRoot(), projections.build()), mergeAnalysis.getTargetTableScope(), planWithUniqueId.getFieldMappings(), this.outerContext);
        RelationPlan source = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).process((Node)merge.getSource());
        RelationPlan joinPlan = new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).planJoin(QueryPlanner.coerceIfNecessary(this.analysis, merge.getPredicate(), merge.getPredicate()), Join.Type.RIGHT, mergeAnalysis.getJoinScope(), planWithPresentColumn, source, this.analysis.getSubqueries((Node)merge));
        PlanBuilder subPlan = PlanBuilder.newPlanBuilder(joinPlan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext);
        FieldReference rowIdReference = this.analysis.getRowIdField(mergeAnalysis.getTargetTable());
        Symbol rowIdSymbol = planWithPresentColumn.getFieldMappings().get(rowIdReference.getFieldIndex());
        Metadata metadata = this.plannerContext.getMetadata();
        List<ColumnSchema> dataColumnSchemas = mergeAnalysis.getDataColumnSchemas();
        ImmutableList.Builder whenClauses = ImmutableList.builder();
        Set<ColumnHandle> nonNullableColumnHandles = mergeAnalysis.getNonNullableColumnHandles();
        for (int caseNumber = 0; caseNumber < merge.getMergeCases().size(); ++caseNumber) {
            MergeCase mergeCase = (MergeCase)merge.getMergeCases().get(caseNumber);
            Optional<Object> casePredicate = Optional.empty();
            if (mergeCase.getExpression().isPresent()) {
                Expression original = (Expression)mergeCase.getExpression().get();
                Expression predicate = QueryPlanner.coerceIfNecessary(this.analysis, original, original);
                casePredicate = Optional.of(predicate);
                subPlan = this.subqueryPlanner.handleSubqueries(subPlan, predicate, this.analysis.getSubqueries((Node)merge));
            }
            ImmutableList.Builder rowBuilder = ImmutableList.builder();
            Assignments.Builder assignments = Assignments.builder();
            List<ColumnHandle> mergeCaseSetColumns = mergeCaseColumnsHandles.get(caseNumber);
            for (ColumnHandle dataColumnHandle : mergeAnalysis.getDataColumnHandles()) {
                int index = mergeCaseSetColumns.indexOf(dataColumnHandle);
                int fieldNumber = mergeAnalysis.getColumnHandleFieldNumbers().get(dataColumnHandle);
                Symbol field = planWithPresentColumn.getFieldMappings().get(fieldNumber);
                if (index >= 0) {
                    Expression setExpression = (Expression)mergeCase.getSetExpressions().get(index);
                    subPlan = this.subqueryPlanner.handleSubqueries(subPlan, setExpression, this.analysis.getSubqueries((Node)merge));
                    Expression rewritten = subPlan.rewrite(setExpression);
                    rewritten = QueryPlanner.coerceIfNecessary(this.analysis, setExpression, rewritten);
                    if (nonNullableColumnHandles.contains(dataColumnHandle)) {
                        ColumnSchema columnSchema2 = dataColumnSchemas.get(fieldNumber);
                        String columnName = columnSchema2.getName();
                        rewritten = new CoalesceExpression(rewritten, (Expression)new Cast((Expression)LogicalPlanner.failFunction(metadata, (ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Assigning NULL to non-null MERGE target table column " + columnName), TypeSignatureTranslator.toSqlType(columnSchema2.getType())), new Expression[0]);
                    }
                    rowBuilder.add((Object)rewritten);
                    assignments.put(field, rewritten);
                    continue;
                }
                rowBuilder.add((Object)field.toSymbolReference());
                assignments.putIdentity(field);
            }
            rowBuilder.add((Object)new IsNotNullPredicate((Expression)presentColumn.toSymbolReference()));
            rowBuilder.add((Object)new GenericLiteral("TINYINT", String.valueOf(QueryPlanner.getMergeCaseOperationNumber(mergeCase))));
            rowBuilder.add((Object)new GenericLiteral("INTEGER", String.valueOf(caseNumber)));
            Optional<Expression> rewritten = casePredicate.map(subPlan::rewrite);
            SymbolReference condition = presentColumn.toSymbolReference();
            if (mergeCase instanceof MergeInsert) {
                condition = new IsNullPredicate((Expression)presentColumn.toSymbolReference());
            }
            if (rewritten.isPresent()) {
                condition = ExpressionUtils.and(new Expression[]{condition, rewritten.get()});
            }
            whenClauses.add((Object)new WhenClause((Expression)condition, (Expression)new Row((List)rowBuilder.build())));
            List<Expression> constraints = this.analysis.getCheckConstraints(mergeAnalysis.getTargetTable());
            if (constraints.isEmpty()) continue;
            assignments.putIdentity(uniqueIdSymbol);
            assignments.putIdentity(presentColumn);
            assignments.putIdentity(rowIdSymbol);
            assignments.putIdentities(source.getFieldMappings());
            subPlan = subPlan.withNewRoot(new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), assignments.build()));
            subPlan = this.addCheckConstraints(constraints, subPlan.withScope(targetTablePlan.getScope(), targetTablePlan.getFieldMappings()));
        }
        ImmutableList.Builder rowBuilder = ImmutableList.builder();
        dataColumnSchemas.forEach(columnSchema -> rowBuilder.add((Object)new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType(columnSchema.getType()))));
        rowBuilder.add((Object)new IsNotNullPredicate((Expression)presentColumn.toSymbolReference()));
        rowBuilder.add((Object)new GenericLiteral("TINYINT", "-1"));
        rowBuilder.add((Object)new GenericLiteral("INTEGER", "-1"));
        SearchedCaseExpression caseExpression = new SearchedCaseExpression((List)whenClauses.build(), Optional.of(new Row((List)rowBuilder.build())));
        Symbol mergeRowSymbol = this.symbolAllocator.newSymbol("merge_row", (Type)mergeAnalysis.getMergeRowType());
        Symbol caseNumberSymbol = this.symbolAllocator.newSymbol("case_number", (Type)IntegerType.INTEGER);
        Assignments.Builder projectionAssignmentsBuilder = Assignments.builder();
        for (ColumnHandle column : mergeAnalysis.getRedistributionColumnHandles()) {
            int fieldIndex = Objects.requireNonNull(mergeAnalysis.getColumnHandleFieldNumbers().get(column), "Could not find fieldIndex for redistribution column");
            Symbol symbol = planWithPresentColumn.getFieldMappings().get(fieldIndex);
            projectionAssignmentsBuilder.putIdentity(symbol);
        }
        projectionAssignmentsBuilder.putIdentity(uniqueIdSymbol);
        projectionAssignmentsBuilder.putIdentity(rowIdSymbol);
        projectionAssignmentsBuilder.put(mergeRowSymbol, (Expression)caseExpression);
        ProjectNode subPlanProject = new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), projectionAssignmentsBuilder.build());
        ProjectNode project = new ProjectNode(this.idAllocator.getNextId(), subPlanProject, Assignments.builder().putIdentities(subPlanProject.getOutputSymbols()).put(caseNumberSymbol, (Expression)new SubscriptExpression((Expression)mergeRowSymbol.toSymbolReference(), (Expression)new LongLiteral(Long.toString(mergeAnalysis.getMergeRowType().getFields().size())))).build());
        Symbol isDistinctSymbol = this.symbolAllocator.newSymbol("is_distinct", (Type)BooleanType.BOOLEAN);
        MarkDistinctNode markDistinctNode = new MarkDistinctNode(this.idAllocator.getNextId(), project, isDistinctSymbol, (List<Symbol>)ImmutableList.of((Object)uniqueIdSymbol, (Object)caseNumberSymbol), Optional.empty());
        IfExpression filter = new IfExpression((Expression)LogicalExpression.and((Expression)new NotExpression((Expression)isDistinctSymbol.toSymbolReference()), (Expression)new IsNotNullPredicate((Expression)uniqueIdSymbol.toSymbolReference())), (Expression)new Cast((Expression)LogicalPlanner.failFunction(metadata, (ErrorCodeSupplier)StandardErrorCode.MERGE_TARGET_ROW_MULTIPLE_MATCHES, "One MERGE target table row matched more than one source row"), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN)), (Expression)BooleanLiteral.TRUE_LITERAL);
        FilterNode filterNode = new FilterNode(this.idAllocator.getNextId(), markDistinctNode, (Expression)filter);
        return this.createMergePipeline(merge.getTargetTable(), planWithPresentColumn, filterNode, rowIdSymbol, mergeRowSymbol);
    }

    private MergeWriterNode createMergePipeline(Table table, RelationPlan relationPlan, PlanNode planNode, Symbol rowIdSymbol, Symbol mergeRowSymbol) {
        TableHandle handle = this.analysis.getTableHandle(table);
        Analysis.MergeAnalysis mergeAnalysis = this.analysis.getMergeAnalysis().orElseThrow();
        Metadata metadata = this.plannerContext.getMetadata();
        RowChangeParadigm paradigm = metadata.getRowChangeParadigm(this.session, handle);
        Type rowIdType = this.analysis.getType((Expression)this.analysis.getRowIdField(table));
        ImmutableList.Builder typesBuilder = ImmutableList.builder();
        ImmutableList.Builder columnNamesBuilder = ImmutableList.builder();
        mergeAnalysis.getDataColumnSchemas().stream().filter(columnSchema -> !columnSchema.isHidden()).forEach(columnSchema -> {
            typesBuilder.add((Object)columnSchema.getType());
            columnNamesBuilder.add((Object)columnSchema.getName());
        });
        TableWriterNode.MergeParadigmAndTypes mergeParadigmAndTypes = new TableWriterNode.MergeParadigmAndTypes(Optional.of(paradigm), (List<Type>)typesBuilder.build(), (List<String>)columnNamesBuilder.build(), rowIdType);
        TableWriterNode.MergeTarget mergeTarget = new TableWriterNode.MergeTarget(handle, Optional.empty(), metadata.getTableName(this.session, handle).getSchemaTableName(), mergeParadigmAndTypes);
        ImmutableList.Builder columnSymbolsBuilder = ImmutableList.builder();
        for (ColumnHandle columnHandle : mergeAnalysis.getDataColumnHandles()) {
            int fieldIndex = Objects.requireNonNull(mergeAnalysis.getColumnHandleFieldNumbers().get(columnHandle), "Could not find field number for column handle");
            columnSymbolsBuilder.add((Object)relationPlan.getFieldMappings().get(fieldIndex));
        }
        ImmutableList columnSymbols = columnSymbolsBuilder.build();
        ImmutableList.Builder redistributionSymbolsBuilder = ImmutableList.builder();
        for (ColumnHandle columnHandle : mergeAnalysis.getRedistributionColumnHandles()) {
            int fieldIndex = Objects.requireNonNull(mergeAnalysis.getColumnHandleFieldNumbers().get(columnHandle), "Could not find field number for column handle");
            redistributionSymbolsBuilder.add((Object)relationPlan.getFieldMappings().get(fieldIndex));
        }
        Symbol operationSymbol = this.symbolAllocator.newSymbol("operation", (Type)TinyintType.TINYINT);
        Symbol insertFromUpdateSymbol = this.symbolAllocator.newSymbol("insert_from_update", (Type)TinyintType.TINYINT);
        ImmutableList projectedSymbols = ImmutableList.builder().addAll((Iterable)columnSymbols).add((Object)operationSymbol).add((Object)rowIdSymbol).add((Object)insertFromUpdateSymbol).build();
        MergeProcessorNode mergeProcessorNode = new MergeProcessorNode(this.idAllocator.getNextId(), planNode, mergeTarget, rowIdSymbol, mergeRowSymbol, (List<Symbol>)columnSymbols, (List<Symbol>)redistributionSymbolsBuilder.build(), (List<Symbol>)projectedSymbols);
        Optional<PartitioningScheme> partitioningScheme = QueryPlanner.createMergePartitioningScheme(mergeAnalysis.getInsertLayout(), (List<Symbol>)columnSymbols, mergeAnalysis.getInsertPartitioningArgumentIndexes(), mergeAnalysis.getUpdateLayout(), rowIdSymbol, operationSymbol);
        ImmutableList outputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), (Object)this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY));
        return new MergeWriterNode(this.idAllocator.getNextId(), mergeProcessorNode, mergeTarget, (List<Symbol>)projectedSymbols, partitioningScheme, (List<Symbol>)outputs);
    }

    private static int getMergeCaseOperationNumber(MergeCase mergeCase) {
        if (mergeCase instanceof MergeInsert) {
            return 1;
        }
        if (mergeCase instanceof MergeUpdate) {
            return 3;
        }
        if (mergeCase instanceof MergeDelete) {
            return 2;
        }
        throw new IllegalArgumentException("Unrecognized MergeCase: " + String.valueOf(mergeCase));
    }

    public static Optional<PartitioningScheme> createMergePartitioningScheme(Optional<TableLayout> insertLayout, List<Symbol> symbols, List<Integer> insertPartitioningArgumentIndexes, Optional<PartitioningHandle> updateLayout, Symbol rowIdSymbol, Symbol operationSymbol) {
        if (insertLayout.isEmpty() && updateLayout.isEmpty()) {
            return Optional.empty();
        }
        Optional<PartitioningScheme> insertPartitioning = insertLayout.map(layout -> {
            List arguments = (List)insertPartitioningArgumentIndexes.stream().map(symbols::get).collect(ImmutableList.toImmutableList());
            return layout.getPartitioning().map(handle -> new PartitioningScheme(Partitioning.create(handle, arguments), symbols)).orElseGet(() -> new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, arguments), symbols));
        });
        Optional<PartitioningScheme> updatePartitioning = updateLayout.map(handle -> new PartitioningScheme(Partitioning.create(handle, (List<Symbol>)ImmutableList.of((Object)rowIdSymbol)), (List<Symbol>)ImmutableList.of((Object)rowIdSymbol)));
        PartitioningHandle partitioningHandle = new PartitioningHandle(Optional.empty(), Optional.empty(), new MergePartitioningHandle(insertPartitioning, updatePartitioning));
        ArrayList<Symbol> combinedSymbols = new ArrayList<Symbol>();
        combinedSymbols.add(operationSymbol);
        insertPartitioning.ifPresent(scheme -> combinedSymbols.addAll(QueryPlanner.partitioningSymbols(scheme)));
        updatePartitioning.ifPresent(scheme -> combinedSymbols.addAll(QueryPlanner.partitioningSymbols(scheme)));
        return Optional.of(new PartitioningScheme(Partitioning.create(partitioningHandle, combinedSymbols), combinedSymbols));
    }

    private static List<Symbol> partitioningSymbols(PartitioningScheme scheme) {
        return (List)scheme.getPartitioning().getArguments().stream().map(Partitioning.ArgumentBinding::getColumn).collect(ImmutableList.toImmutableList());
    }

    private static List<Symbol> computeOutputs(PlanBuilder builder, List<Expression> outputExpressions) {
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        for (Expression expression : outputExpressions) {
            outputSymbols.add((Object)builder.translate(expression));
        }
        return outputSymbols.build();
    }

    private PlanBuilder planQueryBody(Query query) {
        RelationPlan relationPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).process((Node)query.getQueryBody(), null);
        return PlanBuilder.newPlanBuilder(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext);
    }

    private PlanBuilder planFrom(QuerySpecification node) {
        if (node.getFrom().isPresent()) {
            RelationPlan relationPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).process((Node)node.getFrom().get(), null);
            return PlanBuilder.newPlanBuilder(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext);
        }
        return new PlanBuilder(new TranslationMap(this.outerContext, this.analysis.getImplicitFromScope(node), this.analysis, this.lambdaDeclarationToSymbolMap, (List<Symbol>)ImmutableList.of(), this.session, this.plannerContext), new ValuesNode(this.idAllocator.getNextId(), 1));
    }

    private PlanBuilder filter(PlanBuilder subPlan, Expression predicate, Node node) {
        if (predicate == null) {
            return subPlan;
        }
        subPlan = this.subqueryPlanner.handleSubqueries(subPlan, predicate, this.analysis.getSubqueries(node));
        return subPlan.withNewRoot(new FilterNode(this.idAllocator.getNextId(), subPlan.getRoot(), QueryPlanner.coerceIfNecessary(this.analysis, predicate, subPlan.rewrite(predicate))));
    }

    private PlanBuilder aggregate(PlanBuilder subPlan, QuerySpecification node) {
        if (!this.analysis.isAggregation(node)) {
            return subPlan;
        }
        ImmutableList.Builder inputBuilder = ImmutableList.builder();
        this.analysis.getAggregates(node).stream().map(FunctionCall::getArguments).flatMap(Collection::stream).filter(expression -> !(expression instanceof LambdaExpression)).forEach(arg_0 -> ((ImmutableList.Builder)inputBuilder).add(arg_0));
        this.analysis.getAggregates(node).stream().map(FunctionCall::getOrderBy).map(NodeUtils::getSortItemsFromOrderBy).flatMap(Collection::stream).map(SortItem::getSortKey).forEach(arg_0 -> ((ImmutableList.Builder)inputBuilder).add(arg_0));
        this.analysis.getAggregates(node).stream().map(FunctionCall::getFilter).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((ImmutableList.Builder)inputBuilder).add(arg_0));
        Analysis.GroupingSetAnalysis groupingSetAnalysis = this.analysis.getGroupingSets(node);
        inputBuilder.addAll(groupingSetAnalysis.getComplexExpressions());
        ImmutableList inputs = inputBuilder.build();
        subPlan = this.subqueryPlanner.handleSubqueries(subPlan, (Collection<Expression>)inputs, this.analysis.getSubqueries((Node)node));
        subPlan = subPlan.appendProjections((Iterable<Expression>)inputs, this.symbolAllocator, this.idAllocator);
        PlanAndMappings coercions = QueryPlanner.coerce(subPlan, (List<Expression>)inputs, this.analysis, this.idAllocator, this.symbolAllocator, this.typeCoercion);
        subPlan = coercions.getSubPlan();
        GroupingSetsPlan groupingSets = this.planGroupingSets(subPlan, node, groupingSetAnalysis);
        subPlan = this.planAggregation(groupingSets.getSubPlan(), groupingSets.getGroupingSets(), groupingSets.getGroupIdSymbol(), this.analysis.getAggregates(node), coercions::get);
        return this.planGroupingOperations(subPlan, node, groupingSets.getGroupIdSymbol(), groupingSets.getColumnOnlyGroupingSets());
    }

    /*
     * WARNING - void declaration
     */
    private GroupingSetsPlan planGroupingSets(PlanBuilder subPlan, QuerySpecification node, Analysis.GroupingSetAnalysis groupingSetAnalysis) {
        PlanNode groupId;
        void var7_11;
        LinkedHashMap<Symbol, Symbol> groupingSetMappings = new LinkedHashMap<Symbol, Symbol>();
        Symbol[] fields = new Symbol[subPlan.getTranslations().getFieldSymbols().size()];
        for (FieldId fieldId : groupingSetAnalysis.getAllFields()) {
            Symbol output;
            Symbol input = subPlan.getTranslations().getFieldSymbols().get(fieldId.getFieldIndex());
            fields[fieldId.getFieldIndex()] = output = this.symbolAllocator.newSymbol(input, "gid");
            groupingSetMappings.put(output, input);
        }
        LinkedHashMap<ScopeAware<Expression>, Symbol> complexExpressions = new LinkedHashMap<ScopeAware<Expression>, Symbol>();
        for (Expression expression : groupingSetAnalysis.getComplexExpressions()) {
            if (complexExpressions.containsKey(ScopeAware.scopeAwareKey(expression, this.analysis, subPlan.getScope()))) continue;
            Symbol input = subPlan.translate(expression);
            Symbol output = this.symbolAllocator.newSymbol(expression, this.analysis.getType(expression), "gid");
            complexExpressions.put(ScopeAware.scopeAwareKey(expression, this.analysis, subPlan.getScope()), output);
            groupingSetMappings.put(output, input);
        }
        List<Set<FieldId>> list = QueryPlanner.enumerateGroupingSets(groupingSetAnalysis);
        if (node.getGroupBy().isPresent() && ((GroupBy)node.getGroupBy().get()).isDistinct()) {
            List list2 = (List)list.stream().distinct().collect(ImmutableList.toImmutableList());
        }
        List sets = (List)var7_11.stream().map(set -> (ImmutableList)set.stream().map(FieldId::getFieldIndex).map(index -> fields[index]).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        List groupingSets = (List)sets.stream().map(set -> ImmutableList.builder().addAll((Iterable)set).addAll(complexExpressions.values()).build()).collect(ImmutableList.toImmutableList());
        Optional<Object> groupIdSymbol = Optional.empty();
        if (groupingSets.size() > 1) {
            groupIdSymbol = Optional.of(this.symbolAllocator.newSymbol("groupId", (Type)BigintType.BIGINT));
            groupId = new GroupIdNode(this.idAllocator.getNextId(), subPlan.getRoot(), groupingSets, groupingSetMappings, subPlan.getRoot().getOutputSymbols(), (Symbol)groupIdSymbol.get());
        } else {
            Assignments.Builder assignments = Assignments.builder();
            assignments.putIdentities(subPlan.getRoot().getOutputSymbols());
            groupingSetMappings.forEach((key, value) -> assignments.put((Symbol)key, (Expression)value.toSymbolReference()));
            groupId = new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), assignments.build());
        }
        subPlan = new PlanBuilder(subPlan.getTranslations().withNewMappings(complexExpressions, Arrays.asList(fields)), groupId);
        return new GroupingSetsPlan(subPlan, (List<Set<FieldId>>)var7_11, groupingSets, groupIdSymbol);
    }

    private PlanBuilder planAggregation(PlanBuilder subPlan, List<List<Symbol>> groupingSets, Optional<Symbol> groupIdSymbol, List<FunctionCall> aggregates, Function<Expression, Symbol> coercions) {
        ImmutableList.Builder aggregateMappingBuilder = ImmutableList.builder();
        for (FunctionCall function : this.scopeAwareDistinct(subPlan, aggregates)) {
            Symbol symbol = this.symbolAllocator.newSymbol((Expression)function, this.analysis.getType((Expression)function));
            AggregationNode.Aggregation aggregation = new AggregationNode.Aggregation(this.analysis.getResolvedFunction((Node)function), (List)function.getArguments().stream().map(argument -> {
                if (argument instanceof LambdaExpression) {
                    return subPlan.rewrite((Expression)argument);
                }
                return ((Symbol)coercions.apply((Expression)argument)).toSymbolReference();
            }).collect(ImmutableList.toImmutableList()), function.isDistinct(), function.getFilter().map(coercions), function.getOrderBy().map(orderBy -> QueryPlanner.translateOrderingScheme(orderBy.getSortItems(), coercions)), Optional.empty());
            aggregateMappingBuilder.add((Object)new AggregationAssignment(symbol, (Expression)function, aggregation));
        }
        ImmutableList aggregateMappings = aggregateMappingBuilder.build();
        ImmutableSet.Builder globalGroupingSets = ImmutableSet.builder();
        for (int i = 0; i < groupingSets.size(); ++i) {
            if (!groupingSets.get(i).isEmpty()) continue;
            globalGroupingSets.add((Object)i);
        }
        ImmutableList.Builder groupingKeys = ImmutableList.builder();
        groupingSets.stream().flatMap(Collection::stream).distinct().forEach(arg_0 -> ((ImmutableList.Builder)groupingKeys).add(arg_0));
        groupIdSymbol.ifPresent(arg_0 -> ((ImmutableList.Builder)groupingKeys).add(arg_0));
        AggregationNode aggregationNode = new AggregationNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map)aggregateMappings.stream().collect(ImmutableMap.toImmutableMap(AggregationAssignment::getSymbol, AggregationAssignment::getRewritten)), AggregationNode.groupingSets((List<Symbol>)groupingKeys.build(), groupingSets.size(), (Set<Integer>)globalGroupingSets.build()), (List<Symbol>)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), groupIdSymbol);
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings((Map)aggregateMappings.stream().collect(ImmutableMap.toImmutableMap(assignment -> ScopeAware.scopeAwareKey(assignment.getAstExpression(), this.analysis, subPlan.getScope()), AggregationAssignment::getSymbol))), aggregationNode);
    }

    private <T extends Expression> List<T> scopeAwareDistinct(PlanBuilder subPlan, List<T> expressions) {
        return (List)expressions.stream().map(function -> ScopeAware.scopeAwareKey(function, this.analysis, subPlan.getScope())).distinct().map(ScopeAware::getNode).collect(ImmutableList.toImmutableList());
    }

    public static OrderingScheme translateOrderingScheme(List<SortItem> items, Function<Expression, Symbol> coercions) {
        List coerced = (List)items.stream().map(SortItem::getSortKey).map(coercions).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder symbols = ImmutableList.builder();
        HashMap<Symbol, SortOrder> orders = new HashMap<Symbol, SortOrder>();
        for (int i = 0; i < coerced.size(); ++i) {
            Symbol symbol = (Symbol)coerced.get(i);
            if (orders.containsKey(symbol)) continue;
            symbols.add((Object)symbol);
            orders.put(symbol, OrderingScheme.sortItemToSortOrder(items.get(i)));
        }
        return new OrderingScheme((List<Symbol>)symbols.build(), orders);
    }

    private static List<Set<FieldId>> enumerateGroupingSets(Analysis.GroupingSetAnalysis groupingSetAnalysis) {
        List sets;
        ArrayList<List<Set<FieldId>>> partialSets = new ArrayList<List<Set<FieldId>>>();
        for (List<Set<FieldId>> cube : groupingSetAnalysis.getCubes()) {
            sets = (List)Sets.powerSet((Set)ImmutableSet.copyOf(cube)).stream().map(set -> (ImmutableSet)set.stream().flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet())).collect(ImmutableList.toImmutableList());
            partialSets.add(sets);
        }
        for (List<Set<FieldId>> rollup : groupingSetAnalysis.getRollups()) {
            sets = (List)IntStream.rangeClosed(0, rollup.size()).mapToObj(prefixLength -> (ImmutableSet)rollup.subList(0, prefixLength).stream().flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet())).collect(ImmutableList.toImmutableList());
            partialSets.add(sets);
        }
        partialSets.addAll(groupingSetAnalysis.getOrdinarySets());
        if (partialSets.isEmpty()) {
            return ImmutableList.of((Object)ImmutableSet.of());
        }
        ArrayList<Set<FieldId>> allSets = new ArrayList<Set<FieldId>>();
        ((List)partialSets.get(0)).stream().map(ImmutableSet::copyOf).forEach(allSets::add);
        for (int i = 1; i < partialSets.size(); ++i) {
            List groupingSets = (List)partialSets.get(i);
            ImmutableList oldGroupingSetsCrossProduct = ImmutableList.copyOf(allSets);
            allSets.clear();
            for (Set existingSet : oldGroupingSetsCrossProduct) {
                for (Set groupingSet : groupingSets) {
                    ImmutableSet concatenatedSet = ImmutableSet.builder().addAll((Iterable)existingSet).addAll((Iterable)groupingSet).build();
                    allSets.add((Set<FieldId>)concatenatedSet);
                }
            }
        }
        return allSets;
    }

    private PlanBuilder planGroupingOperations(PlanBuilder subPlan, QuerySpecification node, Optional<Symbol> groupIdSymbol, List<Set<FieldId>> groupingSets) {
        if (this.analysis.getGroupingOperations(node).isEmpty()) {
            return subPlan;
        }
        List descriptor = (List)groupingSets.stream().map(set -> (ImmutableSet)set.stream().map(FieldId::getFieldIndex).collect(ImmutableSet.toImmutableSet())).collect(ImmutableList.toImmutableList());
        return subPlan.appendProjections(this.analysis.getGroupingOperations(node), this.symbolAllocator, this.idAllocator, (translations, groupingOperation) -> GroupingOperationRewriter.rewriteGroupingOperation(groupingOperation, descriptor, this.analysis.getColumnReferenceFields(), groupIdSymbol), (translations, groupingOperation) -> false);
    }

    private PlanBuilder planWindowFunctions(Node node, PlanBuilder subPlan, List<FunctionCall> windowFunctions) {
        if (windowFunctions.isEmpty()) {
            return subPlan;
        }
        Map<Analysis.ResolvedWindow, List<FunctionCall>> functions = this.scopeAwareDistinct(subPlan, windowFunctions).stream().collect(Collectors.groupingBy(this.analysis::getWindow));
        for (Map.Entry<Analysis.ResolvedWindow, List<FunctionCall>> entry : functions.entrySet()) {
            Analysis.ResolvedWindow window = entry.getKey();
            List<FunctionCall> functionCalls = entry.getValue();
            ImmutableList.Builder inputsBuilder = ImmutableList.builder().addAll(window.getPartitionBy()).addAll(NodeUtils.getSortItemsFromOrderBy(window.getOrderBy()).stream().map(SortItem::getSortKey).iterator());
            if (window.getFrame().isPresent()) {
                WindowFrame frame = window.getFrame().get();
                frame.getStart().getValue().ifPresent(arg_0 -> ((ImmutableList.Builder)inputsBuilder).add(arg_0));
                if (frame.getEnd().isPresent()) {
                    ((FrameBound)frame.getEnd().get()).getValue().ifPresent(arg_0 -> ((ImmutableList.Builder)inputsBuilder).add(arg_0));
                }
            }
            for (FunctionCall windowFunction : functionCalls) {
                inputsBuilder.addAll((Iterable)windowFunction.getArguments().stream().filter(argument -> !(argument instanceof LambdaExpression)).collect(Collectors.toList()));
            }
            ImmutableList inputs = inputsBuilder.build();
            subPlan = this.subqueryPlanner.handleSubqueries(subPlan, (Collection<Expression>)inputs, this.analysis.getSubqueries(node));
            subPlan = subPlan.appendProjections((Iterable<Expression>)inputs, this.symbolAllocator, this.idAllocator);
            PlanAndMappings coercions = QueryPlanner.coerce(subPlan, (List<Expression>)inputs, this.analysis, this.idAllocator, this.symbolAllocator, this.typeCoercion);
            subPlan = coercions.getSubPlan();
            Optional<Symbol> frameStart = Optional.empty();
            Optional<Symbol> frameEnd = Optional.empty();
            Optional<Symbol> sortKeyCoercedForFrameStartComparison = Optional.empty();
            Optional<Symbol> sortKeyCoercedForFrameEndComparison = Optional.empty();
            if (window.getFrame().isPresent() && window.getFrame().get().getType() == WindowFrame.Type.RANGE) {
                startValue = window.getFrame().get().getStart().getValue();
                endValue = window.getFrame().get().getEnd().flatMap(FrameBound::getValue);
                HashMap<Type, Symbol> sortKeyCoercions = new HashMap<Type, Symbol>();
                FrameBoundPlanAndSymbols plan = this.planFrameBound(subPlan, coercions, startValue, window, sortKeyCoercions);
                subPlan = plan.getSubPlan();
                frameStart = plan.getFrameBoundSymbol();
                sortKeyCoercedForFrameStartComparison = plan.getSortKeyCoercedForFrameBoundComparison();
                plan = this.planFrameBound(subPlan, coercions, endValue, window, sortKeyCoercions);
                subPlan = plan.getSubPlan();
                frameEnd = plan.getFrameBoundSymbol();
                sortKeyCoercedForFrameEndComparison = plan.getSortKeyCoercedForFrameBoundComparison();
            } else if (window.getFrame().isPresent() && (window.getFrame().get().getType() == WindowFrame.Type.ROWS || window.getFrame().get().getType() == WindowFrame.Type.GROUPS)) {
                startValue = window.getFrame().get().getStart().getValue();
                endValue = window.getFrame().get().getEnd().flatMap(FrameBound::getValue);
                FrameOffsetPlanAndSymbol plan = this.planFrameOffset(subPlan, startValue.map(coercions::get));
                subPlan = plan.getSubPlan();
                frameStart = plan.getFrameOffsetSymbol();
                plan = this.planFrameOffset(subPlan, endValue.map(coercions::get));
                subPlan = plan.getSubPlan();
                frameEnd = plan.getFrameOffsetSymbol();
            } else if (window.getFrame().isPresent()) {
                throw new IllegalArgumentException("unexpected window frame type: " + String.valueOf(window.getFrame().get().getType()));
            }
            if (window.getFrame().isPresent() && window.getFrame().get().getPattern().isPresent()) {
                WindowFrame frame = window.getFrame().get();
                subPlan = this.subqueryPlanner.handleSubqueries(subPlan, QueryPlanner.extractPatternRecognitionExpressions(frame.getVariableDefinitions(), frame.getMeasures()), this.analysis.getSubqueries(node));
                subPlan = this.planPatternRecognition(subPlan, functionCalls, window, coercions, frameEnd);
                continue;
            }
            subPlan = this.planWindow(subPlan, functionCalls, window, coercions, frameStart, sortKeyCoercedForFrameStartComparison, frameEnd, sortKeyCoercedForFrameEndComparison);
        }
        return subPlan;
    }

    private FrameBoundPlanAndSymbols planFrameBound(PlanBuilder subPlan, PlanAndMappings coercions, Optional<Expression> frameOffset, Analysis.ResolvedWindow window, Map<Type, Symbol> sortKeyCoercions) {
        Optional<ResolvedFunction> frameBoundCalculationFunction = frameOffset.map(this.analysis::getFrameBoundCalculation);
        if (frameBoundCalculationFunction.isEmpty()) {
            return new FrameBoundPlanAndSymbols(subPlan, Optional.empty(), Optional.empty());
        }
        Symbol offsetSymbol = coercions.get(frameOffset.get());
        Expression zeroOffset = QueryPlanner.zeroOfType(this.symbolAllocator.getTypes().get(offsetSymbol));
        IfExpression predicate = new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)offsetSymbol.toSymbolReference(), zeroOffset), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Cast((Expression)LogicalPlanner.failFunction(this.plannerContext.getMetadata(), (ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, "Window frame offset value must not be negative or null"), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN)));
        subPlan = subPlan.withNewRoot(new FilterNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Expression)predicate));
        Expression sortKey = ((SortItem)Iterables.getOnlyElement((Iterable)window.getOrderBy().orElseThrow().getSortItems())).getSortKey();
        Symbol sortKeyCoercedForFrameBoundCalculation = coercions.get(sortKey);
        Optional<Type> coercion = frameOffset.map(this.analysis::getSortKeyCoercionForFrameBoundCalculation);
        if (coercion.isPresent()) {
            Type expectedType = coercion.get();
            Symbol alreadyCoerced = sortKeyCoercions.get(expectedType);
            if (alreadyCoerced != null) {
                sortKeyCoercedForFrameBoundCalculation = alreadyCoerced;
            } else {
                Cast cast = new Cast((Expression)coercions.get(sortKey).toSymbolReference(), TypeSignatureTranslator.toSqlType(expectedType), false, this.typeCoercion.isTypeOnlyCoercion(this.analysis.getType(sortKey), expectedType));
                sortKeyCoercedForFrameBoundCalculation = this.symbolAllocator.newSymbol((Expression)cast, expectedType);
                sortKeyCoercions.put(expectedType, sortKeyCoercedForFrameBoundCalculation);
                subPlan = subPlan.withNewRoot(new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(sortKeyCoercedForFrameBoundCalculation, (Expression)cast).build()));
            }
        }
        ResolvedFunction function = frameBoundCalculationFunction.get();
        FunctionCall functionCall = new FunctionCall(function.toQualifiedName(), (List)ImmutableList.of((Object)sortKeyCoercedForFrameBoundCalculation.toSymbolReference(), (Object)offsetSymbol.toSymbolReference()));
        Symbol frameBoundSymbol = this.symbolAllocator.newSymbol((Expression)functionCall, function.getSignature().getReturnType());
        subPlan = subPlan.withNewRoot(new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(frameBoundSymbol, (Expression)functionCall).build()));
        Optional<Symbol> sortKeyCoercedForFrameBoundComparison = Optional.of(coercions.get(sortKey));
        coercion = frameOffset.map(this.analysis::getSortKeyCoercionForFrameBoundComparison);
        if (coercion.isPresent()) {
            Type expectedType = coercion.get();
            Symbol alreadyCoerced = sortKeyCoercions.get(expectedType);
            if (alreadyCoerced != null) {
                sortKeyCoercedForFrameBoundComparison = Optional.of(alreadyCoerced);
            } else {
                Cast cast = new Cast((Expression)coercions.get(sortKey).toSymbolReference(), TypeSignatureTranslator.toSqlType(expectedType), false, this.typeCoercion.isTypeOnlyCoercion(this.analysis.getType(sortKey), expectedType));
                Symbol castSymbol = this.symbolAllocator.newSymbol((Expression)cast, expectedType);
                sortKeyCoercions.put(expectedType, castSymbol);
                subPlan = subPlan.withNewRoot(new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(castSymbol, (Expression)cast).build()));
                sortKeyCoercedForFrameBoundComparison = Optional.of(castSymbol);
            }
        }
        return new FrameBoundPlanAndSymbols(subPlan, Optional.of(frameBoundSymbol), sortKeyCoercedForFrameBoundComparison);
    }

    private FrameOffsetPlanAndSymbol planFrameOffset(PlanBuilder subPlan, Optional<Symbol> frameOffset) {
        Object offsetToBigint;
        if (frameOffset.isEmpty()) {
            return new FrameOffsetPlanAndSymbol(subPlan, Optional.empty());
        }
        Symbol offsetSymbol = frameOffset.get();
        Type offsetType = this.symbolAllocator.getTypes().get(offsetSymbol);
        Expression zeroOffset = QueryPlanner.zeroOfType(offsetType);
        IfExpression predicate = new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)offsetSymbol.toSymbolReference(), zeroOffset), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Cast((Expression)LogicalPlanner.failFunction(this.plannerContext.getMetadata(), (ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, "Window frame offset value must not be negative or null"), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN)));
        subPlan = subPlan.withNewRoot(new FilterNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Expression)predicate));
        if (offsetType.equals((Object)BigintType.BIGINT)) {
            return new FrameOffsetPlanAndSymbol(subPlan, Optional.of(offsetSymbol));
        }
        if (offsetType instanceof DecimalType && !((DecimalType)offsetType).isShort()) {
            String maxBigint = Long.toString(Long.MAX_VALUE);
            int maxBigintPrecision = maxBigint.length();
            int actualPrecision = ((DecimalType)offsetType).getPrecision();
            offsetToBigint = actualPrecision < maxBigintPrecision ? new Cast((Expression)offsetSymbol.toSymbolReference(), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT)) : (actualPrecision > maxBigintPrecision ? new GenericLiteral("BIGINT", maxBigint) : new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)offsetSymbol.toSymbolReference(), (Expression)new DecimalLiteral(maxBigint)), (Expression)new Cast((Expression)offsetSymbol.toSymbolReference(), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT)), (Expression)new GenericLiteral("BIGINT", maxBigint)));
        } else {
            offsetToBigint = new Cast((Expression)offsetSymbol.toSymbolReference(), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT), false, this.typeCoercion.isTypeOnlyCoercion(offsetType, (Type)BigintType.BIGINT));
        }
        Symbol coercedOffsetSymbol = this.symbolAllocator.newSymbol((Expression)offsetToBigint, (Type)BigintType.BIGINT);
        subPlan = subPlan.withNewRoot(new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(coercedOffsetSymbol, (Expression)offsetToBigint).build()));
        return new FrameOffsetPlanAndSymbol(subPlan, Optional.of(coercedOffsetSymbol));
    }

    private static Expression zeroOfType(Type type) {
        if (ExpressionAnalyzer.isNumericType(type)) {
            return new Cast((Expression)new LongLiteral("0"), TypeSignatureTranslator.toSqlType(type));
        }
        if (type.equals((Object)IntervalDayTimeType.INTERVAL_DAY_TIME)) {
            return new IntervalLiteral("0", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.DAY);
        }
        if (type.equals((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH)) {
            return new IntervalLiteral("0", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.YEAR);
        }
        throw new IllegalArgumentException("unexpected type: " + String.valueOf(type));
    }

    private PlanBuilder planWindow(PlanBuilder subPlan, List<FunctionCall> windowFunctions, Analysis.ResolvedWindow window, PlanAndMappings coercions, Optional<Symbol> frameStartSymbol, Optional<Symbol> sortKeyCoercedForFrameStartComparison, Optional<Symbol> frameEndSymbol, Optional<Symbol> sortKeyCoercedForFrameEndComparison) {
        WindowFrameType frameType = WindowFrameType.RANGE;
        FrameBoundType frameStartType = FrameBoundType.UNBOUNDED_PRECEDING;
        FrameBoundType frameEndType = FrameBoundType.CURRENT_ROW;
        Optional frameStartExpression = Optional.empty();
        Optional frameEndExpression = Optional.empty();
        if (window.getFrame().isPresent()) {
            WindowFrame frame = window.getFrame().get();
            frameType = this.mapWindowFrameType(frame.getType());
            frameStartType = this.mapFrameBoundType(frame.getStart().getType());
            frameStartExpression = frame.getStart().getValue();
            if (frame.getEnd().isPresent()) {
                frameEndType = this.mapFrameBoundType(((FrameBound)frame.getEnd().get()).getType());
                frameEndExpression = ((FrameBound)frame.getEnd().get()).getValue();
            }
        }
        DataOrganizationSpecification specification = QueryPlanner.planWindowSpecification(window.getPartitionBy(), window.getOrderBy(), coercions::get);
        WindowNode.Frame frame = new WindowNode.Frame(frameType, frameStartType, frameStartSymbol, sortKeyCoercedForFrameStartComparison, frameEndType, frameEndSymbol, sortKeyCoercedForFrameEndComparison, frameStartExpression, frameEndExpression);
        ImmutableMap.Builder mappings = ImmutableMap.builder();
        ImmutableMap.Builder functions = ImmutableMap.builder();
        for (FunctionCall windowFunction : windowFunctions) {
            Symbol newSymbol = this.symbolAllocator.newSymbol((Expression)windowFunction, this.analysis.getType((Expression)windowFunction));
            FunctionCall.NullTreatment nullTreatment = windowFunction.getNullTreatment().orElse(FunctionCall.NullTreatment.RESPECT);
            WindowNode.Function function = new WindowNode.Function(this.analysis.getResolvedFunction((Node)windowFunction), (List)windowFunction.getArguments().stream().map(argument -> {
                if (argument instanceof LambdaExpression) {
                    return subPlan.rewrite((Expression)argument);
                }
                return coercions.get((Expression)argument).toSymbolReference();
            }).collect(ImmutableList.toImmutableList()), frame, nullTreatment == FunctionCall.NullTreatment.IGNORE);
            functions.put((Object)newSymbol, (Object)function);
            mappings.put(ScopeAware.scopeAwareKey(windowFunction, this.analysis, subPlan.getScope()), (Object)newSymbol);
        }
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings((Map<ScopeAware<Expression>, Symbol>)mappings.buildOrThrow()), new WindowNode(this.idAllocator.getNextId(), subPlan.getRoot(), specification, (Map<Symbol, WindowNode.Function>)functions.buildOrThrow(), Optional.empty(), (Set<Symbol>)ImmutableSet.of(), 0));
    }

    private WindowFrameType mapWindowFrameType(WindowFrame.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case WindowFrame.Type.RANGE -> WindowFrameType.RANGE;
            case WindowFrame.Type.ROWS -> WindowFrameType.ROWS;
            case WindowFrame.Type.GROUPS -> WindowFrameType.GROUPS;
        };
    }

    private FrameBoundType mapFrameBoundType(FrameBound.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case FrameBound.Type.UNBOUNDED_PRECEDING -> FrameBoundType.UNBOUNDED_PRECEDING;
            case FrameBound.Type.PRECEDING -> FrameBoundType.PRECEDING;
            case FrameBound.Type.CURRENT_ROW -> FrameBoundType.CURRENT_ROW;
            case FrameBound.Type.FOLLOWING -> FrameBoundType.FOLLOWING;
            case FrameBound.Type.UNBOUNDED_FOLLOWING -> FrameBoundType.UNBOUNDED_FOLLOWING;
        };
    }

    private PlanBuilder planPatternRecognition(PlanBuilder subPlan, List<FunctionCall> windowFunctions, Analysis.ResolvedWindow window, PlanAndMappings coercions, Optional<Symbol> frameEndSymbol) {
        DataOrganizationSpecification specification = QueryPlanner.planWindowSpecification(window.getPartitionBy(), window.getOrderBy(), coercions::get);
        WindowFrame frame = window.getFrame().orElseThrow();
        FrameBound frameEnd = (FrameBound)frame.getEnd().orElseThrow();
        WindowNode.Frame baseFrame = new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), this.mapFrameBoundType(frameEnd.getType()), frameEndSymbol, Optional.empty(), Optional.empty(), frameEnd.getValue());
        ImmutableMap.Builder mappings = ImmutableMap.builder();
        ImmutableMap.Builder functions = ImmutableMap.builder();
        for (FunctionCall windowFunction : windowFunctions) {
            Symbol newSymbol = this.symbolAllocator.newSymbol((Expression)windowFunction, this.analysis.getType((Expression)windowFunction));
            FunctionCall.NullTreatment nullTreatment = windowFunction.getNullTreatment().orElse(FunctionCall.NullTreatment.RESPECT);
            WindowNode.Function function = new WindowNode.Function(this.analysis.getResolvedFunction((Node)windowFunction), (List)windowFunction.getArguments().stream().map(argument -> {
                if (argument instanceof LambdaExpression) {
                    return subPlan.rewrite((Expression)argument);
                }
                return coercions.get((Expression)argument).toSymbolReference();
            }).collect(ImmutableList.toImmutableList()), baseFrame, nullTreatment == FunctionCall.NullTreatment.IGNORE);
            functions.put((Object)newSymbol, (Object)function);
            mappings.put(ScopeAware.scopeAwareKey(windowFunction, this.analysis, subPlan.getScope()), (Object)newSymbol);
        }
        RelationPlanner.PatternRecognitionComponents components = new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).planPatternRecognitionComponents(subPlan::rewrite, frame.getSubsets(), (List<MeasureDefinition>)ImmutableList.of(), frame.getAfterMatchSkipTo(), frame.getPatternSearchMode(), (RowPattern)frame.getPattern().orElseThrow(), frame.getVariableDefinitions());
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings((Map<ScopeAware<Expression>, Symbol>)mappings.buildOrThrow()), new PatternRecognitionNode(this.idAllocator.getNextId(), subPlan.getRoot(), specification, Optional.empty(), (Set<Symbol>)ImmutableSet.of(), 0, (Map<Symbol, WindowNode.Function>)functions.buildOrThrow(), components.getMeasures(), Optional.of(baseFrame), RowsPerMatch.WINDOW, components.getSkipToLabel(), components.getSkipToPosition(), components.isInitial(), components.getPattern(), components.getSubsets(), components.getVariableDefinitions()));
    }

    /*
     * WARNING - void declaration
     */
    public static DataOrganizationSpecification planWindowSpecification(List<Expression> partitionBy, Optional<OrderBy> orderBy, Function<Expression, Symbol> expressionRewrite) {
        void var5_9;
        ImmutableList.Builder partitionBySymbols = ImmutableList.builder();
        for (Expression expression : partitionBy) {
            partitionBySymbols.add((Object)expressionRewrite.apply(expression));
        }
        LinkedHashMap<Symbol, SortOrder> orderings = new LinkedHashMap<Symbol, SortOrder>();
        for (SortItem item : NodeUtils.getSortItemsFromOrderBy(orderBy)) {
            Symbol symbol = expressionRewrite.apply(item.getSortKey());
            orderings.putIfAbsent(symbol, OrderingScheme.sortItemToSortOrder(item));
        }
        Optional optional = Optional.empty();
        if (!orderings.isEmpty()) {
            Optional<OrderingScheme> optional2 = Optional.of(new OrderingScheme((List<Symbol>)ImmutableList.copyOf(orderings.keySet()), orderings));
        }
        return new DataOrganizationSpecification((List<Symbol>)partitionBySymbols.build(), (Optional<OrderingScheme>)var5_9);
    }

    private PlanBuilder planWindowMeasures(Node node, PlanBuilder subPlan, List<WindowOperation> windowMeasures) {
        if (windowMeasures.isEmpty()) {
            return subPlan;
        }
        for (WindowOperation windowMeasure : this.scopeAwareDistinct(subPlan, windowMeasures)) {
            Analysis.ResolvedWindow window = this.analysis.getWindow((Node)windowMeasure);
            Preconditions.checkState((window != null ? 1 : 0) != 0, (Object)("no resolved window for: " + String.valueOf(windowMeasure)));
            ImmutableList.Builder inputsBuilder = ImmutableList.builder().addAll(window.getPartitionBy()).addAll(NodeUtils.getSortItemsFromOrderBy(window.getOrderBy()).stream().map(SortItem::getSortKey).iterator());
            WindowFrame frame = window.getFrame().orElseThrow();
            Optional endValue = ((FrameBound)frame.getEnd().orElseThrow()).getValue();
            endValue.ifPresent(arg_0 -> ((ImmutableList.Builder)inputsBuilder).add(arg_0));
            ImmutableList inputs = inputsBuilder.build();
            subPlan = this.subqueryPlanner.handleSubqueries(subPlan, (Collection<Expression>)inputs, this.analysis.getSubqueries(node));
            subPlan = subPlan.appendProjections((Iterable<Expression>)inputs, this.symbolAllocator, this.idAllocator);
            FrameOffsetPlanAndSymbol plan = this.planFrameOffset(subPlan, endValue.map(subPlan::translate));
            subPlan = plan.getSubPlan();
            Optional<Symbol> frameEnd = plan.getFrameOffsetSymbol();
            subPlan = this.subqueryPlanner.handleSubqueries(subPlan, QueryPlanner.extractPatternRecognitionExpressions(frame.getVariableDefinitions(), frame.getMeasures()), this.analysis.getSubqueries(node));
            subPlan = this.planPatternRecognition(subPlan, windowMeasure, window, frameEnd);
        }
        return subPlan;
    }

    public static List<Expression> extractPatternRecognitionExpressions(List<VariableDefinition> variableDefinitions, List<MeasureDefinition> measureDefinitions) {
        ImmutableList.Builder expressions = ImmutableList.builder();
        variableDefinitions.stream().map(VariableDefinition::getExpression).forEach(arg_0 -> ((ImmutableList.Builder)expressions).add(arg_0));
        measureDefinitions.stream().map(MeasureDefinition::getExpression).forEach(arg_0 -> ((ImmutableList.Builder)expressions).add(arg_0));
        return expressions.build();
    }

    private PlanBuilder planPatternRecognition(PlanBuilder subPlan, WindowOperation windowMeasure, Analysis.ResolvedWindow window, Optional<Symbol> frameEndSymbol) {
        DataOrganizationSpecification specification = QueryPlanner.planWindowSpecification(window.getPartitionBy(), window.getOrderBy(), subPlan::translate);
        WindowFrame frame = window.getFrame().orElseThrow();
        FrameBound frameEnd = (FrameBound)frame.getEnd().orElseThrow();
        WindowNode.Frame baseFrame = new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), this.mapFrameBoundType(frameEnd.getType()), frameEndSymbol, Optional.empty(), Optional.empty(), frameEnd.getValue());
        RelationPlanner.PatternRecognitionComponents components = new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).planPatternRecognitionComponents(subPlan::rewrite, frame.getSubsets(), (List<MeasureDefinition>)ImmutableList.of((Object)this.analysis.getMeasureDefinition(windowMeasure)), frame.getAfterMatchSkipTo(), frame.getPatternSearchMode(), (RowPattern)frame.getPattern().orElseThrow(), frame.getVariableDefinitions());
        Symbol measureSymbol = (Symbol)Iterables.getOnlyElement(components.getMeasures().keySet());
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings((Map<ScopeAware<Expression>, Symbol>)ImmutableMap.of(ScopeAware.scopeAwareKey(windowMeasure, this.analysis, subPlan.getScope()), (Object)measureSymbol)), new PatternRecognitionNode(this.idAllocator.getNextId(), subPlan.getRoot(), specification, Optional.empty(), (Set<Symbol>)ImmutableSet.of(), 0, (Map<Symbol, WindowNode.Function>)ImmutableMap.of(), components.getMeasures(), Optional.of(baseFrame), RowsPerMatch.WINDOW, components.getSkipToLabel(), components.getSkipToPosition(), components.isInitial(), components.getPattern(), components.getSubsets(), components.getVariableDefinitions()));
    }

    public static PlanAndMappings coerce(PlanBuilder subPlan, List<Expression> expressions, Analysis analysis, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, TypeCoercion typeCoercion) {
        Assignments.Builder assignments = Assignments.builder();
        assignments.putIdentities(subPlan.getRoot().getOutputSymbols());
        HashMap<NodeRef<Expression>, Symbol> mappings = new HashMap<NodeRef<Expression>, Symbol>();
        for (Expression expression : expressions) {
            Type coercion = analysis.getCoercion(expression);
            if (mappings.containsKey(NodeRef.of((Node)expression))) continue;
            if (coercion != null) {
                Type type = analysis.getType(expression);
                Symbol symbol = symbolAllocator.newSymbol(expression, coercion);
                assignments.put(symbol, (Expression)new Cast(subPlan.rewrite(expression), TypeSignatureTranslator.toSqlType(coercion), false, typeCoercion.isTypeOnlyCoercion(type, coercion)));
                mappings.put((NodeRef<Expression>)NodeRef.of((Node)expression), symbol);
                continue;
            }
            mappings.put((NodeRef<Expression>)NodeRef.of((Node)expression), subPlan.translate(expression));
        }
        subPlan = subPlan.withNewRoot(new ProjectNode(idAllocator.getNextId(), subPlan.getRoot(), assignments.build()));
        return new PlanAndMappings(subPlan, mappings);
    }

    public static Expression coerceIfNecessary(Analysis analysis, Expression original, Expression rewritten) {
        Type coercion = analysis.getCoercion(original);
        if (coercion == null) {
            return rewritten;
        }
        return new Cast(rewritten, TypeSignatureTranslator.toSqlType(coercion), false, analysis.isTypeOnlyCoercion(original));
    }

    public static NodeAndMappings coerce(RelationPlan plan, List<Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        List<Symbol> visibleFields = QueryPlanner.visibleFields(plan);
        Preconditions.checkArgument((visibleFields.size() == types.size() ? 1 : 0) != 0);
        Assignments.Builder assignments = Assignments.builder();
        ImmutableList.Builder mappings = ImmutableList.builder();
        for (int i = 0; i < types.size(); ++i) {
            Symbol input = visibleFields.get(i);
            Type type = types.get(i);
            if (!symbolAllocator.getTypes().get(input).equals((Object)type)) {
                Symbol coerced = symbolAllocator.newSymbol(input.getName(), type);
                assignments.put(coerced, (Expression)new Cast((Expression)input.toSymbolReference(), TypeSignatureTranslator.toSqlType(type)));
                mappings.add((Object)coerced);
                continue;
            }
            assignments.putIdentity(input);
            mappings.add((Object)input);
        }
        ProjectNode coerced = new ProjectNode(idAllocator.getNextId(), plan.getRoot(), assignments.build());
        return new NodeAndMappings(coerced, (List<Symbol>)mappings.build());
    }

    public static List<Symbol> visibleFields(RelationPlan subPlan) {
        RelationType descriptor = subPlan.getDescriptor();
        return (List)descriptor.getAllFields().stream().filter(field -> !field.isHidden()).map(descriptor::indexOf).map(subPlan.getFieldMappings()::get).collect(ImmutableList.toImmutableList());
    }

    public static NodeAndMappings pruneInvisibleFields(RelationPlan plan, PlanNodeIdAllocator idAllocator) {
        List<Symbol> visibleFields = QueryPlanner.visibleFields(plan);
        ProjectNode pruned = new ProjectNode(idAllocator.getNextId(), plan.getRoot(), Assignments.identity(visibleFields));
        return new NodeAndMappings(pruned, visibleFields);
    }

    public static NodeAndMappings disambiguateOutputs(NodeAndMappings plan, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        ImmutableSet distinctOutputs = ImmutableSet.copyOf(plan.getFields());
        if (distinctOutputs.size() < plan.getFields().size()) {
            Assignments.Builder assignments = Assignments.builder();
            ImmutableList.Builder newOutputs = ImmutableList.builder();
            HashSet<Symbol> uniqueOutputs = new HashSet<Symbol>();
            for (Symbol output : plan.getFields()) {
                if (uniqueOutputs.add(output)) {
                    assignments.putIdentity(output);
                    newOutputs.add((Object)output);
                    continue;
                }
                Symbol newOutput = symbolAllocator.newSymbol(output);
                assignments.put(newOutput, (Expression)output.toSymbolReference());
                newOutputs.add((Object)newOutput);
            }
            return new NodeAndMappings(new ProjectNode(idAllocator.getNextId(), plan.getNode(), assignments.build()), (List<Symbol>)newOutputs.build());
        }
        return plan;
    }

    private PlanBuilder distinct(PlanBuilder subPlan, QuerySpecification node, List<Expression> expressions) {
        if (node.getSelect().isDistinct()) {
            List<Symbol> symbols = expressions.stream().map(subPlan::translate).collect(Collectors.toList());
            return subPlan.withNewRoot(AggregationNode.singleAggregation(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), AggregationNode.singleGroupingSet(symbols)));
        }
        return subPlan;
    }

    private Optional<OrderingScheme> orderingScheme(PlanBuilder subPlan, Optional<OrderBy> orderBy, List<Expression> orderByExpressions) {
        if (orderBy.isEmpty() || SystemSessionProperties.isSkipRedundantSort(this.session) && this.analysis.isOrderByRedundant(orderBy.get())) {
            return Optional.empty();
        }
        Iterator sortItems = orderBy.get().getSortItems().iterator();
        ImmutableList.Builder orderBySymbols = ImmutableList.builder();
        HashMap<Symbol, SortOrder> orderings = new HashMap<Symbol, SortOrder>();
        for (Expression fieldOrExpression : orderByExpressions) {
            Symbol symbol = subPlan.translate(fieldOrExpression);
            SortItem sortItem = (SortItem)sortItems.next();
            if (orderings.containsKey(symbol)) continue;
            orderBySymbols.add((Object)symbol);
            orderings.put(symbol, OrderingScheme.sortItemToSortOrder(sortItem));
        }
        return Optional.of(new OrderingScheme((List<Symbol>)orderBySymbols.build(), orderings));
    }

    private PlanBuilder sort(PlanBuilder subPlan, Optional<OrderingScheme> orderingScheme) {
        if (orderingScheme.isEmpty()) {
            return subPlan;
        }
        return subPlan.withNewRoot(new SortNode(this.idAllocator.getNextId(), subPlan.getRoot(), orderingScheme.get(), false));
    }

    private PlanBuilder offset(PlanBuilder subPlan, Optional<Offset> offset) {
        if (offset.isEmpty()) {
            return subPlan;
        }
        return subPlan.withNewRoot(new OffsetNode(this.idAllocator.getNextId(), subPlan.getRoot(), this.analysis.getOffset(offset.get())));
    }

    private PlanBuilder limit(PlanBuilder subPlan, Optional<Node> limit, Optional<OrderingScheme> orderingScheme) {
        if (limit.isPresent() && this.analysis.getLimit(limit.get()).isPresent()) {
            Optional<OrderingScheme> tiesResolvingScheme = Optional.empty();
            if (limit.get() instanceof FetchFirst && ((FetchFirst)limit.get()).isWithTies()) {
                tiesResolvingScheme = orderingScheme;
            }
            return subPlan.withNewRoot(new LimitNode(this.idAllocator.getNextId(), subPlan.getRoot(), this.analysis.getLimit(limit.get()).getAsLong(), tiesResolvingScheme, false, (List<Symbol>)ImmutableList.of()));
        }
        return subPlan;
    }

    private static /* synthetic */ void lambda$plan$4(Map nameToHandle, List updatedColumnHandles, Expression[] orderedColumnValuesArray, UpdateAssignment assignment) {
        String name = assignment.getName().getValue();
        ColumnHandle handle = (ColumnHandle)nameToHandle.get(name);
        int index = updatedColumnHandles.indexOf(handle);
        if (index >= 0) {
            orderedColumnValuesArray[index] = assignment.getValue();
        }
    }

    public static class PlanAndMappings {
        private final PlanBuilder subPlan;
        private final Map<NodeRef<Expression>, Symbol> mappings;

        public PlanAndMappings(PlanBuilder subPlan, Map<NodeRef<Expression>, Symbol> mappings) {
            this.subPlan = subPlan;
            this.mappings = ImmutableMap.copyOf(mappings);
        }

        public PlanBuilder getSubPlan() {
            return this.subPlan;
        }

        public Symbol get(Expression expression) {
            return this.tryGet(expression).orElseThrow(() -> new IllegalArgumentException(String.format("No mapping for expression: %s (%s)", expression, System.identityHashCode(expression))));
        }

        public Optional<Symbol> tryGet(Expression expression) {
            Symbol result = this.mappings.get(NodeRef.of((Node)expression));
            if (result != null) {
                return Optional.of(result);
            }
            return Optional.empty();
        }
    }

    private static class GroupingSetsPlan {
        private final PlanBuilder subPlan;
        private final List<Set<FieldId>> columnOnlyGroupingSets;
        private final List<List<Symbol>> groupingSets;
        private final Optional<Symbol> groupIdSymbol;

        public GroupingSetsPlan(PlanBuilder subPlan, List<Set<FieldId>> columnOnlyGroupingSets, List<List<Symbol>> groupingSets, Optional<Symbol> groupIdSymbol) {
            this.columnOnlyGroupingSets = columnOnlyGroupingSets;
            this.groupingSets = groupingSets;
            this.groupIdSymbol = groupIdSymbol;
            this.subPlan = subPlan;
        }

        public PlanBuilder getSubPlan() {
            return this.subPlan;
        }

        public List<Set<FieldId>> getColumnOnlyGroupingSets() {
            return this.columnOnlyGroupingSets;
        }

        public List<List<Symbol>> getGroupingSets() {
            return this.groupingSets;
        }

        public Optional<Symbol> getGroupIdSymbol() {
            return this.groupIdSymbol;
        }
    }

    private static class AggregationAssignment {
        private final Symbol symbol;
        private final Expression astExpression;
        private final AggregationNode.Aggregation aggregation;

        public AggregationAssignment(Symbol symbol, Expression astExpression, AggregationNode.Aggregation aggregation) {
            this.astExpression = astExpression;
            this.symbol = symbol;
            this.aggregation = aggregation;
        }

        public Symbol getSymbol() {
            return this.symbol;
        }

        public Expression getAstExpression() {
            return this.astExpression;
        }

        public AggregationNode.Aggregation getRewritten() {
            return this.aggregation;
        }
    }

    private static class FrameBoundPlanAndSymbols {
        private final PlanBuilder subPlan;
        private final Optional<Symbol> frameBoundSymbol;
        private final Optional<Symbol> sortKeyCoercedForFrameBoundComparison;

        public FrameBoundPlanAndSymbols(PlanBuilder subPlan, Optional<Symbol> frameBoundSymbol, Optional<Symbol> sortKeyCoercedForFrameBoundComparison) {
            this.subPlan = subPlan;
            this.frameBoundSymbol = frameBoundSymbol;
            this.sortKeyCoercedForFrameBoundComparison = sortKeyCoercedForFrameBoundComparison;
        }

        public PlanBuilder getSubPlan() {
            return this.subPlan;
        }

        public Optional<Symbol> getFrameBoundSymbol() {
            return this.frameBoundSymbol;
        }

        public Optional<Symbol> getSortKeyCoercedForFrameBoundComparison() {
            return this.sortKeyCoercedForFrameBoundComparison;
        }
    }

    private static class FrameOffsetPlanAndSymbol {
        private final PlanBuilder subPlan;
        private final Optional<Symbol> frameOffsetSymbol;

        public FrameOffsetPlanAndSymbol(PlanBuilder subPlan, Optional<Symbol> frameOffsetSymbol) {
            this.subPlan = subPlan;
            this.frameOffsetSymbol = frameOffsetSymbol;
        }

        public PlanBuilder getSubPlan() {
            return this.subPlan;
        }

        public Optional<Symbol> getFrameOffsetSymbol() {
            return this.frameOffsetSymbol;
        }
    }
}

