/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.rowpattern.LogicalIndexExtractor;
import java.util.Set;

public class PrunePatternRecognitionSourceColumns
implements Rule<PatternRecognitionNode> {
    private static final Pattern<PatternRecognitionNode> PATTERN = Patterns.patternRecognition().with(Patterns.PatternRecognition.rowsPerMatch().matching(rowsPerMatch -> rowsPerMatch == RowsPerMatch.ONE));

    @Override
    public Pattern<PatternRecognitionNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(PatternRecognitionNode node, Captures captures, Rule.Context context) {
        Preconditions.checkState((boolean)node.getWindowFunctions().isEmpty(), (Object)"invalid node: window functions present with ONE ROW PER MATCH");
        Preconditions.checkState((boolean)node.getCommonBaseFrame().isEmpty(), (Object)"invalid node: common base frame present with ONE ROW PER MATCH");
        ImmutableSet.Builder referencedInputs = ImmutableSet.builder();
        referencedInputs.addAll(node.getPartitionBy());
        node.getOrderingScheme().ifPresent(orderingScheme -> referencedInputs.addAll(orderingScheme.getOrderBy()));
        node.getHashSymbol().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0));
        node.getMeasures().values().stream().map(PatternRecognitionNode.Measure::getExpressionAndValuePointers).map(LogicalIndexExtractor.ExpressionAndValuePointers::getInputSymbols).forEach(arg_0 -> ((ImmutableSet.Builder)referencedInputs).addAll(arg_0));
        node.getVariableDefinitions().values().stream().map(LogicalIndexExtractor.ExpressionAndValuePointers::getInputSymbols).forEach(arg_0 -> ((ImmutableSet.Builder)referencedInputs).addAll(arg_0));
        return Util.restrictChildOutputs(context.getIdAllocator(), node, new Set[]{referencedInputs.build()}).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }
}

