/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.Immutable;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableProperties;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.LocalProperty;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.ActualProperties;
import io.trino.sql.planner.optimizations.PropertyDerivations;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.DynamicFilterSourceNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.ExplainAnalyzeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.IndexSourceNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.MergeProcessorNode;
import io.trino.sql.planner.plan.MergeWriterNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RefreshMaterializedViewNode;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.SampleNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SimpleTableExecuteNode;
import io.trino.sql.planner.plan.SkipToPosition;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableDeleteNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableUpdateNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class StreamPropertyDerivations {
    private StreamPropertyDerivations() {
    }

    public static StreamProperties derivePropertiesRecursively(PlanNode node, PlannerContext plannerContext, Session session, TypeProvider types, TypeAnalyzer typeAnalyzer) {
        List inputProperties = (List)node.getSources().stream().map(source -> StreamPropertyDerivations.derivePropertiesRecursively(source, plannerContext, session, types, typeAnalyzer)).collect(ImmutableList.toImmutableList());
        return StreamPropertyDerivations.deriveProperties(node, inputProperties, plannerContext, session, types, typeAnalyzer);
    }

    public static StreamProperties deriveProperties(PlanNode node, StreamProperties inputProperties, PlannerContext plannerContext, Session session, TypeProvider types, TypeAnalyzer typeAnalyzer) {
        return StreamPropertyDerivations.deriveProperties(node, (List<StreamProperties>)ImmutableList.of((Object)inputProperties), plannerContext, session, types, typeAnalyzer);
    }

    public static StreamProperties deriveProperties(PlanNode node, List<StreamProperties> inputProperties, PlannerContext plannerContext, Session session, TypeProvider types, TypeAnalyzer typeAnalyzer) {
        Objects.requireNonNull(node, "node is null");
        Objects.requireNonNull(inputProperties, "inputProperties is null");
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        ActualProperties otherProperties = PropertyDerivations.streamBackdoorDeriveProperties(node, (List)inputProperties.stream().map(properties -> properties.otherActualProperties).collect(ImmutableList.toImmutableList()), plannerContext, session, types, typeAnalyzer);
        StreamProperties result = StreamPropertyDerivations.deriveStreamPropertiesWithoutActualProperties(node, inputProperties, plannerContext.getMetadata(), session).withOtherActualProperties(otherProperties);
        Set localPropertyColumns = result.getLocalProperties().stream().flatMap(property -> property.getColumns().stream()).collect(Collectors.toSet());
        Verify.verify((boolean)node.getOutputSymbols().containsAll(localPropertyColumns), (String)"Stream-level local properties contain columns not present in node's output", (Object[])new Object[0]);
        return result;
    }

    @Deprecated
    static boolean isLocalExchangesSourceSingleStreamDistributed(ExchangeNode exchangeNode, Metadata metadata, Session session) {
        Preconditions.checkArgument((exchangeNode.getScope() == ExchangeNode.Scope.LOCAL ? 1 : 0) != 0, (Object)"exchangeNode must be a local exchange");
        Preconditions.checkArgument((exchangeNode.getSources().size() == 1 ? 1 : 0) != 0, (Object)"exchangeNode must have a single source");
        return StreamPropertyDerivations.deriveStreamPropertiesWithoutActualPropertiesRecursively(exchangeNode.getSources().get(0), metadata, session).isSingleStream();
    }

    @Deprecated
    private static StreamProperties deriveStreamPropertiesWithoutActualPropertiesRecursively(PlanNode node, Metadata metadata, Session session) {
        List inputProperties = (List)node.getSources().stream().map(source -> StreamPropertyDerivations.deriveStreamPropertiesWithoutActualPropertiesRecursively(source, metadata, session)).collect(ImmutableList.toImmutableList());
        return StreamPropertyDerivations.deriveStreamPropertiesWithoutActualProperties(node, inputProperties, metadata, session);
    }

    private static StreamProperties deriveStreamPropertiesWithoutActualProperties(PlanNode node, List<StreamProperties> inputProperties, Metadata metadata, Session session) {
        StreamProperties result = node.accept(new Visitor(metadata, session), inputProperties);
        result.getPartitioningColumns().ifPresent(columns -> Verify.verify((boolean)node.getOutputSymbols().containsAll((Collection<?>)columns), (String)"Stream-level partitioning properties contain columns not present in node's output", (Object[])new Object[0]));
        return result;
    }

    @Immutable
    public static final class StreamProperties {
        private final StreamDistribution distribution;
        private final Optional<List<Symbol>> partitioningColumns;
        private final boolean ordered;
        private final ActualProperties otherActualProperties;

        private StreamProperties(StreamDistribution distribution, Optional<? extends Iterable<Symbol>> partitioningColumns, boolean ordered) {
            this(distribution, partitioningColumns, ordered, null);
        }

        private StreamProperties(StreamDistribution distribution, Optional<? extends Iterable<Symbol>> partitioningColumns, boolean ordered, ActualProperties otherActualProperties) {
            this.distribution = Objects.requireNonNull(distribution, "distribution is null");
            this.partitioningColumns = partitioningColumns.map(ImmutableList::copyOf);
            Preconditions.checkArgument((distribution != StreamDistribution.SINGLE || this.partitioningColumns.equals(Optional.of(ImmutableList.of())) ? 1 : 0) != 0, (Object)"Single stream must be partitioned on empty set");
            this.ordered = ordered;
            Preconditions.checkArgument((!ordered || distribution == StreamDistribution.SINGLE ? 1 : 0) != 0, (Object)"Ordered must be a single stream");
            this.otherActualProperties = otherActualProperties;
        }

        public List<LocalProperty<Symbol>> getLocalProperties() {
            Preconditions.checkState((this.otherActualProperties != null ? 1 : 0) != 0, (Object)"otherActualProperties not set");
            return this.otherActualProperties.getLocalProperties();
        }

        private static StreamProperties singleStream() {
            return new StreamProperties(StreamDistribution.SINGLE, Optional.of(ImmutableSet.of()), false);
        }

        private static StreamProperties fixedStreams() {
            return new StreamProperties(StreamDistribution.FIXED, Optional.empty(), false);
        }

        private static StreamProperties ordered() {
            return new StreamProperties(StreamDistribution.SINGLE, Optional.of(ImmutableSet.of()), true);
        }

        private StreamProperties unordered(boolean unordered) {
            if (unordered) {
                ActualProperties updatedProperies = null;
                if (this.otherActualProperties != null) {
                    updatedProperies = ActualProperties.builderFrom(this.otherActualProperties).unordered(true).build();
                }
                return new StreamProperties(this.distribution, this.partitioningColumns, false, updatedProperies);
            }
            return this;
        }

        public boolean isSingleStream() {
            return this.distribution == StreamDistribution.SINGLE;
        }

        public StreamDistribution getDistribution() {
            return this.distribution;
        }

        public boolean isExactlyPartitionedOn(Iterable<Symbol> columns) {
            return this.partitioningColumns.isPresent() && columns.equals(ImmutableList.copyOf((Collection)this.partitioningColumns.get()));
        }

        public boolean isPartitionedOn(Iterable<Symbol> columns) {
            if (this.partitioningColumns.isEmpty()) {
                return false;
            }
            return ImmutableSet.copyOf(columns).containsAll((Collection)this.partitioningColumns.get());
        }

        public boolean isOrdered() {
            return this.ordered;
        }

        private StreamProperties withUnspecifiedPartitioning() {
            if (this.isSingleStream()) {
                return this;
            }
            return new StreamProperties(this.distribution, Optional.empty(), this.ordered);
        }

        private StreamProperties withOtherActualProperties(ActualProperties actualProperties) {
            return new StreamProperties(this.distribution, this.partitioningColumns, this.ordered, actualProperties);
        }

        public StreamProperties translate(Function<Symbol, Optional<Symbol>> translator) {
            return new StreamProperties(this.distribution, this.partitioningColumns.flatMap(partitioning -> {
                ImmutableList.Builder newPartitioningColumns = ImmutableList.builder();
                for (Symbol partitioningColumn : partitioning) {
                    Optional translated = (Optional)translator.apply(partitioningColumn);
                    if (translated.isEmpty()) {
                        return Optional.empty();
                    }
                    newPartitioningColumns.add((Object)((Symbol)translated.get()));
                }
                return Optional.of(newPartitioningColumns.build());
            }), this.ordered, this.otherActualProperties == null ? null : this.otherActualProperties.translate(translator));
        }

        public Optional<List<Symbol>> getPartitioningColumns() {
            return this.partitioningColumns;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.distribution, this.partitioningColumns});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StreamProperties other = (StreamProperties)obj;
            return this.distribution == other.distribution && Objects.equals(this.partitioningColumns, other.partitioningColumns);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("distribution", (Object)this.distribution).add("partitioningColumns", this.partitioningColumns).toString();
        }

        public static enum StreamDistribution {
            SINGLE,
            MULTIPLE,
            FIXED;

        }
    }

    private static class Visitor
    extends PlanVisitor<StreamProperties, List<StreamProperties>> {
        private final Metadata metadata;
        private final Session session;

        private Visitor(Metadata metadata, Session session) {
            this.metadata = metadata;
            this.session = session;
        }

        @Override
        protected StreamProperties visitPlan(PlanNode node, List<StreamProperties> inputProperties) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        @Override
        public StreamProperties visitJoin(JoinNode node, List<StreamProperties> inputProperties) {
            StreamProperties leftProperties = inputProperties.get(0);
            boolean unordered = Visitor.spillPossible(this.session, node);
            return switch (node.getType()) {
                default -> throw new MatchException(null, null);
                case JoinType.INNER -> leftProperties.translate(column -> PropertyDerivations.filterOrRewrite(node.getOutputSymbols(), node.getCriteria(), column)).unordered(unordered);
                case JoinType.LEFT -> leftProperties.translate(column -> PropertyDerivations.filterIfMissing(node.getOutputSymbols(), column)).unordered(unordered);
                case JoinType.RIGHT -> new StreamProperties(StreamProperties.StreamDistribution.MULTIPLE, Optional.empty(), false);
                case JoinType.FULL -> new StreamProperties(StreamProperties.StreamDistribution.MULTIPLE, Optional.empty(), false);
            };
        }

        private static boolean spillPossible(Session session, JoinNode node) {
            return SystemSessionProperties.isSpillEnabled(session) && node.isSpillable().orElseThrow(() -> new IllegalArgumentException("spillable not yet set")) != false;
        }

        @Override
        public StreamProperties visitSpatialJoin(SpatialJoinNode node, List<StreamProperties> inputProperties) {
            StreamProperties leftProperties = inputProperties.get(0);
            switch (node.getType()) {
                default: {
                    throw new MatchException(null, null);
                }
                case INNER: 
                case LEFT: 
            }
            return leftProperties.translate(column -> PropertyDerivations.filterIfMissing(node.getOutputSymbols(), column));
        }

        @Override
        public StreamProperties visitIndexJoin(IndexJoinNode node, List<StreamProperties> inputProperties) {
            StreamProperties probeProperties = inputProperties.get(0);
            return switch (node.getType()) {
                default -> throw new MatchException(null, null);
                case IndexJoinNode.Type.INNER -> probeProperties;
                case IndexJoinNode.Type.SOURCE_OUTER -> probeProperties.withUnspecifiedPartitioning();
            };
        }

        @Override
        public StreamProperties visitDynamicFilterSource(DynamicFilterSourceNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public StreamProperties visitValues(ValuesNode node, List<StreamProperties> context) {
            return StreamProperties.singleStream();
        }

        @Override
        public StreamProperties visitTableScan(TableScanNode node, List<StreamProperties> inputProperties) {
            TableProperties layout = this.metadata.getTableProperties(this.session, node.getTable());
            ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
            HashSet constants = new HashSet();
            ((Map)TupleDomain.extractFixedValues(layout.getPredicate()).orElse(ImmutableMap.of())).entrySet().stream().filter(entry -> !((NullableValue)entry.getValue()).isNull()).forEach(entry -> constants.add((ColumnHandle)entry.getKey()));
            Optional partitioningSymbols = layout.getTablePartitioning().flatMap(arg_0 -> Visitor.lambda$visitTableScan$6((Map)assignments, constants, arg_0));
            return new StreamProperties(StreamProperties.StreamDistribution.MULTIPLE, partitioningSymbols, false);
        }

        private static Optional<Set<Symbol>> getNonConstantSymbols(List<ColumnHandle> columnHandles, Map<ColumnHandle, Symbol> assignments, Set<ColumnHandle> globalConstants) {
            Set constantsStrippedPartitionColumns = (Set)columnHandles.stream().filter(column -> !globalConstants.contains(column)).collect(ImmutableSet.toImmutableSet());
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (ColumnHandle column2 : constantsStrippedPartitionColumns) {
                Symbol translated = assignments.get(column2);
                if (translated == null) {
                    return Optional.empty();
                }
                builder.add((Object)translated);
            }
            return Optional.of(builder.build());
        }

        @Override
        public StreamProperties visitExchange(ExchangeNode node, List<StreamProperties> inputProperties) {
            if (node.getOrderingScheme().isPresent()) {
                return StreamProperties.ordered();
            }
            if (node.getScope() == ExchangeNode.Scope.REMOTE) {
                return StreamProperties.fixedStreams();
            }
            return switch (node.getType()) {
                default -> throw new MatchException(null, null);
                case ExchangeNode.Type.GATHER -> StreamProperties.singleStream();
                case ExchangeNode.Type.REPARTITION -> {
                    if (node.getPartitioningScheme().getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION)) {
                        yield new StreamProperties(StreamProperties.StreamDistribution.FIXED, Optional.empty(), false);
                    }
                    yield new StreamProperties(StreamProperties.StreamDistribution.FIXED, Optional.of((ImmutableList)node.getPartitioningScheme().getPartitioning().getArguments().stream().map(Partitioning.ArgumentBinding::getColumn).collect(ImmutableList.toImmutableList())), false);
                }
                case ExchangeNode.Type.REPLICATE -> new StreamProperties(StreamProperties.StreamDistribution.MULTIPLE, Optional.empty(), false);
            };
        }

        @Override
        public StreamProperties visitProject(ProjectNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            Map<Symbol, Symbol> identities = Visitor.computeIdentityTranslations(node.getAssignments().getMap());
            return properties.translate(column -> Optional.ofNullable((Symbol)identities.get(column)));
        }

        private static Map<Symbol, Symbol> computeIdentityTranslations(Map<Symbol, Expression> assignments) {
            HashMap<Symbol, Symbol> inputToOutput = new HashMap<Symbol, Symbol>();
            for (Map.Entry<Symbol, Expression> assignment : assignments.entrySet()) {
                if (!(assignment.getValue() instanceof SymbolReference)) continue;
                inputToOutput.put(Symbol.from(assignment.getValue()), assignment.getKey());
            }
            return inputToOutput;
        }

        @Override
        public StreamProperties visitGroupId(GroupIdNode node, List<StreamProperties> inputProperties) {
            HashMap<Symbol, Symbol> inputToOutputMappings = new HashMap<Symbol, Symbol>();
            for (Map.Entry<Symbol, Symbol> setMapping : node.getGroupingColumns().entrySet()) {
                if (!node.getCommonGroupingColumns().contains(setMapping.getKey())) continue;
                inputToOutputMappings.putIfAbsent(setMapping.getValue(), setMapping.getKey());
            }
            for (Symbol argument : node.getAggregationArguments()) {
                inputToOutputMappings.putIfAbsent(argument, argument);
            }
            return ((StreamProperties)Iterables.getOnlyElement(inputProperties)).translate(column -> Optional.ofNullable((Symbol)inputToOutputMappings.get(column)));
        }

        @Override
        public StreamProperties visitAggregation(AggregationNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            return properties.translate(symbol -> node.getGroupingKeys().contains(symbol) ? Optional.of(symbol) : Optional.empty());
        }

        @Override
        public StreamProperties visitStatisticsWriterNode(StatisticsWriterNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            return properties.withUnspecifiedPartitioning();
        }

        @Override
        public StreamProperties visitTableFinish(TableFinishNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            return properties.withUnspecifiedPartitioning();
        }

        @Override
        public StreamProperties visitTableDelete(TableDeleteNode node, List<StreamProperties> inputProperties) {
            return StreamProperties.singleStream();
        }

        @Override
        public StreamProperties visitTableUpdate(TableUpdateNode node, List<StreamProperties> inputProperties) {
            return StreamProperties.singleStream();
        }

        @Override
        public StreamProperties visitTableExecute(TableExecuteNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            return properties.withUnspecifiedPartitioning();
        }

        @Override
        public StreamProperties visitSimpleTableExecuteNode(SimpleTableExecuteNode node, List<StreamProperties> context) {
            return StreamProperties.singleStream();
        }

        @Override
        public StreamProperties visitRefreshMaterializedView(RefreshMaterializedViewNode node, List<StreamProperties> inputProperties) {
            return StreamProperties.singleStream();
        }

        @Override
        public StreamProperties visitMergeWriter(MergeWriterNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            return properties.withUnspecifiedPartitioning();
        }

        @Override
        public StreamProperties visitMergeProcessor(MergeProcessorNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            return properties.withUnspecifiedPartitioning();
        }

        @Override
        public StreamProperties visitTableWriter(TableWriterNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            return properties.withUnspecifiedPartitioning();
        }

        @Override
        public StreamProperties visitUnnest(UnnestNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            ImmutableSet passThroughInputs = ImmutableSet.copyOf(node.getReplicateSymbols());
            StreamProperties translatedProperties = properties.translate(arg_0 -> Visitor.lambda$visitUnnest$11((Set)passThroughInputs, arg_0));
            return switch (node.getJoinType()) {
                default -> throw new MatchException(null, null);
                case JoinType.INNER, JoinType.LEFT -> translatedProperties;
                case JoinType.RIGHT, JoinType.FULL -> translatedProperties.unordered(true);
            };
        }

        @Override
        public StreamProperties visitExplainAnalyze(ExplainAnalyzeNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            return properties.withUnspecifiedPartitioning();
        }

        @Override
        public StreamProperties visitIndexSource(IndexSourceNode node, List<StreamProperties> context) {
            return StreamProperties.singleStream();
        }

        @Override
        public StreamProperties visitUnion(UnionNode node, List<StreamProperties> context) {
            return StreamProperties.singleStream();
        }

        @Override
        public StreamProperties visitEnforceSingleRow(EnforceSingleRowNode node, List<StreamProperties> context) {
            return StreamProperties.singleStream();
        }

        @Override
        public StreamProperties visitAssignUniqueId(AssignUniqueId node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            if (properties.getPartitioningColumns().isPresent()) {
                return properties;
            }
            return new StreamProperties(properties.getDistribution(), Optional.of(ImmutableList.of((Object)node.getIdColumn())), properties.isOrdered());
        }

        @Override
        public StreamProperties visitOutput(OutputNode node, List<StreamProperties> inputProperties) {
            return ((StreamProperties)Iterables.getOnlyElement(inputProperties)).translate(column -> PropertyDerivations.filterIfMissing(node.getOutputSymbols(), column));
        }

        @Override
        public StreamProperties visitMarkDistinct(MarkDistinctNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public StreamProperties visitWindow(WindowNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public StreamProperties visitPatternRecognition(PatternRecognitionNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            Sets.SetView passThroughInputs = Sets.intersection((Set)ImmutableSet.copyOf(node.getSource().getOutputSymbols()), (Set)ImmutableSet.copyOf(node.getOutputSymbols()));
            StreamProperties translatedProperties = properties.translate(arg_0 -> Visitor.lambda$visitPatternRecognition$13((Set)passThroughInputs, arg_0));
            boolean preservesOrdering = node.getRowsPerMatch().isOneRow() || node.getSkipToPosition() == SkipToPosition.PAST_LAST;
            return translatedProperties.unordered(!preservesOrdering);
        }

        @Override
        public StreamProperties visitTableFunction(TableFunctionNode node, List<StreamProperties> inputProperties) {
            throw new IllegalStateException(String.format("Unexpected node: TableFunctionNode (%s)", node.getName()));
        }

        @Override
        public StreamProperties visitTableFunctionProcessor(TableFunctionProcessorNode node, List<StreamProperties> inputProperties) {
            if (node.getSource().isEmpty()) {
                return StreamProperties.singleStream();
            }
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            Sets.SetView passThroughInputs = Sets.intersection((Set)ImmutableSet.copyOf(node.getSource().orElseThrow().getOutputSymbols()), (Set)ImmutableSet.copyOf(node.getOutputSymbols()));
            StreamProperties translatedProperties = properties.translate(arg_0 -> Visitor.lambda$visitTableFunctionProcessor$14((Set)passThroughInputs, arg_0));
            return translatedProperties.unordered(true);
        }

        @Override
        public StreamProperties visitRowNumber(RowNumberNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public StreamProperties visitTopNRanking(TopNRankingNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public StreamProperties visitTopN(TopNNode node, List<StreamProperties> inputProperties) {
            if (node.getStep() == TopNNode.Step.PARTIAL) {
                return (StreamProperties)Iterables.getOnlyElement(inputProperties);
            }
            return StreamProperties.ordered();
        }

        @Override
        public StreamProperties visitSort(SortNode node, List<StreamProperties> inputProperties) {
            StreamProperties sourceProperties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            if (sourceProperties.isSingleStream()) {
                return StreamProperties.ordered();
            }
            return sourceProperties;
        }

        @Override
        public StreamProperties visitLimit(LimitNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public StreamProperties visitDistinctLimit(DistinctLimitNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public StreamProperties visitSemiJoin(SemiJoinNode node, List<StreamProperties> inputProperties) {
            return inputProperties.get(0);
        }

        @Override
        public StreamProperties visitApply(ApplyNode node, List<StreamProperties> inputProperties) {
            throw new IllegalStateException("Unexpected node: " + String.valueOf(node.getClass()));
        }

        @Override
        public StreamProperties visitCorrelatedJoin(CorrelatedJoinNode node, List<StreamProperties> inputProperties) {
            throw new IllegalStateException("Unexpected node: " + String.valueOf(node.getClass()));
        }

        @Override
        public StreamProperties visitFilter(FilterNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public StreamProperties visitSample(SampleNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        private static /* synthetic */ Optional lambda$visitTableFunctionProcessor$14(Set passThroughInputs, Symbol column) {
            if (passThroughInputs.contains(column)) {
                return Optional.of(column);
            }
            return Optional.empty();
        }

        private static /* synthetic */ Optional lambda$visitPatternRecognition$13(Set passThroughInputs, Symbol column) {
            if (passThroughInputs.contains(column)) {
                return Optional.of(column);
            }
            return Optional.empty();
        }

        private static /* synthetic */ Optional lambda$visitUnnest$11(Set passThroughInputs, Symbol column) {
            if (passThroughInputs.contains(column)) {
                return Optional.of(column);
            }
            return Optional.empty();
        }

        private static /* synthetic */ Optional lambda$visitTableScan$6(Map assignments, Set constants, TableProperties.TablePartitioning partitioning) {
            if (!partitioning.isSingleSplitPerPartition()) {
                return Optional.empty();
            }
            Optional<Set<Symbol>> symbols = Visitor.getNonConstantSymbols(partitioning.getPartitioningColumns(), assignments, constants);
            if (symbols.isPresent() && symbols.get().isEmpty()) {
                return Optional.empty();
            }
            return symbols;
        }
    }
}

