/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.rowpattern;

import com.google.common.collect.ImmutableList;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.LabelDereference;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class AggregateArgumentsRewriter {
    private AggregateArgumentsRewriter() {
    }

    public static List<Expression> rewrite(List<Expression> arguments, Symbol classifierSymbol, Symbol matchNumberSymbol) {
        Rewriter rewriter = new Rewriter(classifierSymbol, matchNumberSymbol);
        return (List)arguments.stream().filter(argument -> !AggregateArgumentsRewriter.isAllRowsReference(argument)).map(argument -> ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)rewriter, (Expression)argument)).collect(ImmutableList.toImmutableList());
    }

    private static boolean isAllRowsReference(Expression argument) {
        return argument instanceof LabelDereference && ((LabelDereference)argument).getReference().isEmpty();
    }

    private static class Rewriter
    extends ExpressionRewriter<Void> {
        private final Symbol classifierSymbol;
        private final Symbol matchNumberSymbol;

        public Rewriter(Symbol classifierSymbol, Symbol matchNumberSymbol) {
            this.classifierSymbol = Objects.requireNonNull(classifierSymbol, "classifierSymbol is null");
            this.matchNumberSymbol = Objects.requireNonNull(matchNumberSymbol, "matchNumberSymbol is null");
        }

        protected Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            return treeRewriter.defaultRewrite(node, (Object)context);
        }

        public Expression rewriteLabelDereference(LabelDereference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            return (Expression)node.getReference().orElseThrow();
        }

        public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (ExpressionAnalyzer.isPatternRecognitionFunction(node)) {
                String functionName;
                QualifiedName name = node.getName();
                return switch (functionName = name.getSuffix().toUpperCase(Locale.ENGLISH)) {
                    case "CLASSIFIER" -> this.classifierSymbol.toSymbolReference();
                    case "MATCH_NUMBER" -> this.matchNumberSymbol.toSymbolReference();
                    default -> throw new UnsupportedOperationException("unexpected pattern recognition function: " + String.valueOf(node.getName()));
                };
            }
            return super.rewriteFunctionCall(node, (Object)context, treeRewriter);
        }
    }
}

