/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.assertions;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.trino.cache.SafeCaches;
import io.trino.client.ErrorInfo;
import io.trino.client.FailureException;
import io.trino.client.FailureInfo;
import io.trino.execution.Failure;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.ErrorType;
import io.trino.spi.Location;
import io.trino.spi.TrinoException;
import io.trino.sql.parser.ParsingException;
import io.trino.testing.QueryFailedException;
import io.trino.util.Failures;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.error.ShouldContainCharSequence;
import org.assertj.core.error.ShouldHaveMessageMatchingRegex;
import org.assertj.core.util.CheckReturnValue;

public final class TrinoExceptionAssert
extends AbstractThrowableAssert<TrinoExceptionAssert, Throwable> {
    private static final LoadingCache<String, Boolean> isTrinoExceptionCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(100L), (CacheLoader)CacheLoader.from(type -> {
        try {
            Class<?> exceptionClass = Class.forName(type);
            return TrinoException.class.isAssignableFrom(exceptionClass) || ParsingException.class.isAssignableFrom(exceptionClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }));
    private final FailureInfo failureInfo;

    @CheckReturnValue
    public static TrinoExceptionAssert assertTrinoExceptionThrownBy(ThrowableAssert.ThrowingCallable throwingCallable) {
        Throwable throwable = Assertions.catchThrowable((ThrowableAssert.ThrowingCallable)throwingCallable);
        if (throwable == null) {
            Assertions.failBecauseExceptionWasNotThrown(TrinoException.class);
        }
        return TrinoExceptionAssert.assertThatTrinoException(throwable);
    }

    @CheckReturnValue
    public static TrinoExceptionAssert assertThatTrinoException(Throwable throwable) {
        Optional<FailureInfo> failureInfo = TrinoExceptionAssert.getFailureInfo(throwable);
        if (failureInfo.isEmpty() || !TrinoExceptionAssert.isTrinoException(failureInfo.get().getType())) {
            throw new AssertionError("Expected TrinoException or wrapper, but got: " + throwable.getClass().getName() + " " + String.valueOf(throwable), throwable);
        }
        return new TrinoExceptionAssert(throwable, failureInfo.get());
    }

    private static boolean isTrinoException(String type) {
        return (Boolean)isTrinoExceptionCache.getUnchecked((Object)type);
    }

    private static Optional<FailureInfo> getFailureInfo(Throwable throwable) {
        Throwable throwable2 = throwable;
        Objects.requireNonNull(throwable2);
        Throwable throwable3 = throwable2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TrinoException.class, QueryFailedException.class}, (Object)throwable3, n)) {
            case 0 -> {
                TrinoException trinoException = (TrinoException)throwable3;
                yield Optional.of(Failures.toFailure(trinoException).toFailureInfo());
            }
            case 1 -> {
                QueryFailedException queryFailedException = (QueryFailedException)throwable3;
                if (queryFailedException.getCause() == null) {
                    yield Optional.empty();
                }
                Throwable v2 = queryFailedException.getCause();
                Objects.requireNonNull(v2);
                Throwable var6_5 = v2;
                int var7_6 = 0;
                Optional<Object> v3 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Failure.class, FailureException.class}, (Object)var6_5, var7_6)) {
                    case 0 -> {
                        Failure failure = (Failure)var6_5;
                        yield Optional.of(failure.getFailureInfo().toFailureInfo());
                    }
                    case 1 -> {
                        FailureException failure = (FailureException)var6_5;
                        yield Optional.of(failure.getFailureInfo());
                    }
                    default -> Optional.empty();
                };
                Optional failureInfo = v3;
                yield failureInfo;
            }
            default -> Optional.empty();
        };
    }

    private TrinoExceptionAssert(Throwable actual, FailureInfo failureInfo) {
        super(actual, TrinoExceptionAssert.class);
        this.failureInfo = Objects.requireNonNull(failureInfo, "failureInfo is null");
    }

    public TrinoExceptionAssert hasErrorCode(ErrorCodeSupplier ... errorCodeSupplier) {
        ErrorCode errorCode = null;
        ErrorInfo errorInfo = this.failureInfo.getErrorInfo();
        if (errorInfo != null) {
            errorCode = new ErrorCode(errorInfo.getCode(), errorInfo.getName(), ErrorType.valueOf((String)errorInfo.getType()));
        }
        try {
            Assertions.assertThat(errorCode).isIn((Iterable)Stream.of(errorCodeSupplier).map(ErrorCodeSupplier::toErrorCode).collect(Collectors.toSet()));
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).addSuppressed((Throwable)this.actual);
            throw e;
        }
        return (TrinoExceptionAssert)this.myself;
    }

    public TrinoExceptionAssert hasLocation(int lineNumber, int columnNumber) {
        try {
            Optional<Location> location = Optional.ofNullable(this.failureInfo.getErrorLocation()).map(errorLocation -> new Location(errorLocation.getLineNumber(), errorLocation.getColumnNumber()));
            Assertions.assertThat(location).hasValue((Object)new Location(lineNumber, columnNumber));
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).addSuppressed((Throwable)this.actual);
            throw e;
        }
        return (TrinoExceptionAssert)this.myself;
    }

    public TrinoExceptionAssert hasCauseMessageMatching(String regex) {
        for (Throwable cause = (Throwable)this.actual; cause != null; cause = cause.getCause()) {
            if (!cause.getMessage().matches(regex)) continue;
            return (TrinoExceptionAssert)this.myself;
        }
        throw org.assertj.core.internal.Failures.instance().failure((AssertionInfo)this.info, ShouldHaveMessageMatchingRegex.shouldHaveMessageMatchingRegex((Throwable)((Throwable)this.actual), (CharSequence)regex));
    }

    public TrinoExceptionAssert hasCauseMessageContaining(String message) {
        for (Throwable cause = (Throwable)this.actual; cause != null; cause = cause.getCause()) {
            if (!cause.getMessage().contains(message)) continue;
            return (TrinoExceptionAssert)this.myself;
        }
        throw org.assertj.core.internal.Failures.instance().failure((AssertionInfo)this.info, ShouldContainCharSequence.shouldContain((Throwable)((Throwable)this.actual), (CharSequence)message));
    }
}

