/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.trino.operator.aggregation.state;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateMetadata;
import io.trino.spi.type.Type;

@AccumulatorStateMetadata(stateSerializerClass = BlockPositionStateSerializer.class)
public interface BlockPositionState
        extends AccumulatorState, NullableState
{
    Block getBlock();

    int getPosition();

    void setBlock(Block value);

    void setPosition(int position);

    @Override
    default boolean isNull()
    {
        Block block = getBlock();
        return block == null || block.isNull(getPosition());
    }

    default void set(BlockPositionState state)
    {
        setBlock(state.getBlock());
        setPosition(state.getPosition());
    }

    static void write(Type type, BlockPositionState state, BlockBuilder out)
    {
        if (state.getBlock() == null) {
            out.appendNull();
        }
        else {
            type.appendTo(state.getBlock(), state.getPosition(), out);
        }
    }
}
