/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.trino.spi.predicate.Domain;
import io.trino.sql.planner.plan.DynamicFilterId;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DynamicFiltersCollector {
    public static final long INITIAL_DYNAMIC_FILTERS_VERSION = 0L;
    public static final VersionedDynamicFilterDomains INITIAL_DYNAMIC_FILTER_DOMAINS = new VersionedDynamicFilterDomains(0L, (Map<DynamicFilterId, Domain>)ImmutableMap.of());
    private final Runnable notifyTaskStatusChanged;
    @GuardedBy(value="this")
    private final Map<DynamicFilterId, VersionedDomain> dynamicFilterDomains = new HashMap<DynamicFilterId, VersionedDomain>();
    @GuardedBy(value="this")
    private long currentVersion;

    public DynamicFiltersCollector(Runnable notifyTaskStatusChanged) {
        this.notifyTaskStatusChanged = Objects.requireNonNull(notifyTaskStatusChanged, "notifyTaskStatusChanged is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDomains(Map<DynamicFilterId, Domain> newDynamicFilterDomains) {
        if (newDynamicFilterDomains.isEmpty()) {
            return;
        }
        DynamicFiltersCollector dynamicFiltersCollector = this;
        synchronized (dynamicFiltersCollector) {
            long currentVersion = ++this.currentVersion;
            for (Map.Entry<DynamicFilterId, Domain> entry : newDynamicFilterDomains.entrySet()) {
                this.dynamicFilterDomains.merge(entry.getKey(), new VersionedDomain(currentVersion, entry.getValue()), (oldDomain, newDomain) -> new VersionedDomain(Math.max(oldDomain.getVersion(), newDomain.getVersion()), oldDomain.getDomain().intersect(newDomain.getDomain())));
            }
        }
        this.notifyTaskStatusChanged.run();
    }

    public synchronized long getDynamicFiltersVersion() {
        return this.currentVersion;
    }

    public synchronized VersionedDynamicFilterDomains acknowledgeAndGetNewDomains(long callersCurrentVersion) {
        this.acknowledge(callersCurrentVersion);
        return this.getCurrentDynamicFilterDomains();
    }

    public synchronized void acknowledge(long callersCurrentVersion) {
        this.dynamicFilterDomains.values().removeIf(domain -> domain.getVersion() <= callersCurrentVersion);
    }

    public synchronized VersionedDynamicFilterDomains getCurrentDynamicFilterDomains() {
        return new VersionedDynamicFilterDomains(this.currentVersion, (Map)this.dynamicFilterDomains.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((VersionedDomain)entry.getValue()).getDomain())));
    }

    private static class VersionedDomain {
        private final long version;
        private final Domain domain;

        private VersionedDomain(long version, Domain domain) {
            this.version = version;
            this.domain = Objects.requireNonNull(domain, "domain is null");
        }

        public long getVersion() {
            return this.version;
        }

        public Domain getDomain() {
            return this.domain;
        }
    }

    public static class VersionedDynamicFilterDomains {
        private final long version;
        private final Map<DynamicFilterId, Domain> dynamicFilterDomains;

        @JsonCreator
        public VersionedDynamicFilterDomains(long version, Map<DynamicFilterId, Domain> dynamicFilterDomains) {
            this.version = version;
            this.dynamicFilterDomains = ImmutableMap.copyOf(Objects.requireNonNull(dynamicFilterDomains, "dynamicFilterDomains is null"));
        }

        @JsonProperty
        public long getVersion() {
            return this.version;
        }

        @JsonProperty
        public Map<DynamicFilterId, Domain> getDynamicFilterDomains() {
            return this.dynamicFilterDomains;
        }
    }
}

