/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigHidden;
import io.airlift.units.Duration;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.TimeUnit;

public class FailureInjectionConfig {
    private Duration expirationPeriod = new Duration(10.0, TimeUnit.MINUTES);
    private Duration requestTimeout = new Duration(2.0, TimeUnit.MINUTES);

    @NotNull
    public Duration getExpirationPeriod() {
        return this.expirationPeriod;
    }

    @ConfigHidden
    @Config(value="failure-injection.expiration-period")
    @ConfigDescription(value="Period after which an injected failure is considered expired and will no longer be triggering a failure")
    public FailureInjectionConfig setExpirationPeriod(Duration expirationPeriod) {
        this.expirationPeriod = expirationPeriod;
        return this;
    }

    @NotNull
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @ConfigHidden
    @Config(value="failure-injection.request-timeout")
    @ConfigDescription(value="Period after which requests blocked to emulate a timeout are released")
    public FailureInjectionConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }
}

