/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor.scheduler;

import io.trino.annotation.NotThreadSafe;
import io.trino.execution.executor.scheduler.State;

@NotThreadSafe
final class Task {
    private State state;
    private long weight;
    private long uncommittedWeight;

    public Task(long initialWeight) {
        this.weight = initialWeight;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void commitWeight(long delta) {
        this.weight += delta;
        this.uncommittedWeight = 0L;
    }

    public void addWeight(long delta) {
        this.weight += delta;
    }

    public long weight() {
        return this.weight + this.uncommittedWeight;
    }

    public void setUncommittedWeight(long weight) {
        this.uncommittedWeight = weight;
    }

    public long uncommittedWeight() {
        return this.uncommittedWeight;
    }

    public State state() {
        return this.state;
    }
}

