/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.primitives.ImmutableLongArray;
import io.trino.Session;
import io.trino.execution.StageId;
import io.trino.execution.scheduler.faulttolerant.EventDrivenFaultTolerantQueryScheduler;
import io.trino.execution.scheduler.faulttolerant.OutputStatsEstimator;
import io.trino.execution.scheduler.faulttolerant.OutputStatsEstimatorFactory;
import java.util.Optional;
import java.util.function.Function;

public class ByEagerParentOutputStatsEstimator
implements OutputStatsEstimator {
    @Override
    public Optional<OutputStatsEstimator.OutputStatsEstimateResult> getEstimatedOutputStats(EventDrivenFaultTolerantQueryScheduler.StageExecution stageExecution, Function<StageId, EventDrivenFaultTolerantQueryScheduler.StageExecution> stageExecutionLookup, boolean parentEager) {
        if (!parentEager) {
            return Optional.empty();
        }
        int outputPartitionsCount = stageExecution.getSinkPartitioningScheme().getPartitionCount();
        ImmutableLongArray.Builder estimateBuilder = ImmutableLongArray.builder((int)outputPartitionsCount);
        for (int i = 0; i < outputPartitionsCount; ++i) {
            estimateBuilder.add(0L);
        }
        return Optional.of(new OutputStatsEstimator.OutputStatsEstimateResult(estimateBuilder.build(), 0L, "FOR_EAGER_PARENT"));
    }

    public static class Factory
    implements OutputStatsEstimatorFactory {
        @Override
        public OutputStatsEstimator create(Session session) {
            return new ByEagerParentOutputStatsEstimator();
        }
    }
}

