/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.google.inject.Provider;
import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.compress.zstd.ZstdDecompressor;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.cache.NonEvictableLoadingCache;
import io.trino.cache.SafeCaches;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.tree.QualifiedName;
import io.trino.type.TypeDeserializer;
import io.trino.type.TypeSignatureDeserializer;
import io.trino.type.TypeSignatureKeyDeserializer;
import io.trino.util.ThreadLocalCompressorDecompressor;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class ResolvedFunction {
    private final BoundSignature signature;
    private final CatalogHandle catalogHandle;
    private final FunctionId functionId;
    private final FunctionKind functionKind;
    private final boolean deterministic;
    private final FunctionNullability functionNullability;
    private final Map<TypeSignature, Type> typeDependencies;
    private final Set<ResolvedFunction> functionDependencies;

    @JsonCreator
    public ResolvedFunction(@JsonProperty(value="signature") BoundSignature signature, @JsonProperty(value="catalogHandle") CatalogHandle catalogHandle, @JsonProperty(value="id") FunctionId functionId, @JsonProperty(value="functionKind") FunctionKind functionKind, @JsonProperty(value="deterministic") boolean deterministic, @JsonProperty(value="functionNullability") FunctionNullability functionNullability, @JsonProperty(value="typeDependencies") Map<TypeSignature, Type> typeDependencies, @JsonProperty(value="functionDependencies") Set<ResolvedFunction> functionDependencies) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.functionId = Objects.requireNonNull(functionId, "functionId is null");
        this.functionKind = Objects.requireNonNull(functionKind, "functionKind is null");
        this.deterministic = deterministic;
        this.functionNullability = Objects.requireNonNull(functionNullability, "functionNullability is null");
        this.typeDependencies = ImmutableMap.copyOf(Objects.requireNonNull(typeDependencies, "typeDependencies is null"));
        this.functionDependencies = ImmutableSet.copyOf((Collection)Objects.requireNonNull(functionDependencies, "functionDependencies is null"));
        Preconditions.checkArgument((functionNullability.getArgumentNullable().size() == signature.getArgumentTypes().size() ? 1 : 0) != 0, (Object)"signature and functionNullability must have same argument count");
    }

    @JsonProperty
    public BoundSignature getSignature() {
        return this.signature;
    }

    @JsonProperty
    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }

    @JsonProperty(value="id")
    public FunctionId getFunctionId() {
        return this.functionId;
    }

    @JsonProperty(value="functionKind")
    public FunctionKind getFunctionKind() {
        return this.functionKind;
    }

    @JsonProperty
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @JsonProperty
    public FunctionNullability getFunctionNullability() {
        return this.functionNullability;
    }

    @JsonProperty
    public Map<TypeSignature, Type> getTypeDependencies() {
        return this.typeDependencies;
    }

    @JsonProperty
    public Set<ResolvedFunction> getFunctionDependencies() {
        return this.functionDependencies;
    }

    public static boolean isResolved(QualifiedName name) {
        return SerializedResolvedFunction.isSerializedResolvedFunction(name);
    }

    public QualifiedName toQualifiedName() {
        CatalogSchemaFunctionName name = this.toCatalogSchemaFunctionName();
        return QualifiedName.of((String)name.getCatalogName(), (String[])new String[]{name.getSchemaName(), name.getFunctionName()});
    }

    public CatalogSchemaFunctionName toCatalogSchemaFunctionName() {
        return ResolvedFunctionDecoder.toCatalogSchemaFunctionName(this);
    }

    public static CatalogSchemaFunctionName extractFunctionName(QualifiedName qualifiedName) {
        Preconditions.checkArgument((boolean)ResolvedFunction.isResolved(qualifiedName), (String)"Expected qualifiedName to be a resolved function: %s", (Object)qualifiedName);
        return SerializedResolvedFunction.fromSerializedName(qualifiedName).functionName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedFunction that = (ResolvedFunction)o;
        return Objects.equals(this.signature, that.signature) && Objects.equals(this.catalogHandle, that.catalogHandle) && Objects.equals(this.functionId, that.functionId) && this.functionKind == that.functionKind && this.deterministic == that.deterministic && Objects.equals(this.functionNullability, that.functionNullability) && Objects.equals(this.typeDependencies, that.typeDependencies) && Objects.equals(this.functionDependencies, that.functionDependencies);
    }

    public int hashCode() {
        return Objects.hash(this.signature, this.catalogHandle, this.functionId, this.functionKind, this.deterministic, this.functionNullability, this.typeDependencies, this.functionDependencies);
    }

    public String toString() {
        return this.signature.toString();
    }

    private record SerializedResolvedFunction(CatalogSchemaFunctionName functionName, String base32Data) {
        private static final String PREFIX = "@";
        private static final String SCHEMA = "$resolved";

        private SerializedResolvedFunction {
            Objects.requireNonNull(functionName, "functionName is null");
            Preconditions.checkArgument((!SerializedResolvedFunction.isSerializedResolvedFunction(functionName) ? 1 : 0) != 0, (String)"function is already a serialized resolved function: %s", (Object)functionName);
            Objects.requireNonNull(base32Data, "base32Data is null");
        }

        public static boolean isSerializedResolvedFunction(QualifiedName name) {
            List parts = name.getParts();
            return parts.size() == 3 && ((String)parts.get(0)).equals("system") && ((String)parts.get(1)).equals(SCHEMA);
        }

        public static boolean isSerializedResolvedFunction(CatalogSchemaFunctionName name) {
            return name.getCatalogName().equals("system") && name.getSchemaName().equals(SCHEMA);
        }

        public static SerializedResolvedFunction fromSerializedName(QualifiedName qualifiedName) {
            Preconditions.checkArgument((boolean)SerializedResolvedFunction.isSerializedResolvedFunction(qualifiedName), (String)"Expected qualifiedName to be a resolved function: %s", (Object)qualifiedName);
            String data = qualifiedName.getSuffix();
            List parts = Splitter.on((String)PREFIX).splitToList((CharSequence)data);
            Preconditions.checkArgument((parts.size() == 5 && ((String)parts.get(0)).isEmpty() ? 1 : 0) != 0, (String)"Invalid serialized resolved function: %s", (Object)qualifiedName);
            return new SerializedResolvedFunction(new CatalogSchemaFunctionName((String)parts.get(1), (String)parts.get(2), (String)parts.get(3)), (String)parts.get(4));
        }

        public CatalogSchemaFunctionName serialize() {
            String encodedName = PREFIX + this.functionName.getCatalogName() + PREFIX + this.functionName.getSchemaName() + PREFIX + this.functionName.getFunctionName() + PREFIX + this.base32Data;
            return new CatalogSchemaFunctionName("system", SCHEMA, encodedName);
        }
    }

    public static class ResolvedFunctionDecoder {
        private static final JsonCodec<ResolvedFunction> SERIALIZE_JSON_CODEC = new JsonCodecFactory().jsonCodec(ResolvedFunction.class);
        private static final ThreadLocalCompressorDecompressor COMPRESSOR_DECOMPRESSOR = new ThreadLocalCompressorDecompressor(ZstdCompressor::new, ZstdDecompressor::new);
        private final NonEvictableLoadingCache<QualifiedName, ResolvedFunction> resolvedFunctions = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1024L), (CacheLoader)CacheLoader.from(this::deserialize));
        private static final NonEvictableLoadingCache<ResolvedFunction, CatalogSchemaFunctionName> qualifiedNames = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1024L), (CacheLoader)CacheLoader.from(ResolvedFunctionDecoder::serialize));
        private final JsonCodec<ResolvedFunction> jsonCodec;

        public ResolvedFunctionDecoder(Function<TypeId, Type> typeLoader) {
            ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
            objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)((Object)new TypeDeserializer(typeLoader)), TypeSignature.class, (Object)((Object)new TypeSignatureDeserializer())));
            objectMapperProvider.setKeyDeserializers((Map)ImmutableMap.of(TypeSignature.class, (Object)((Object)new TypeSignatureKeyDeserializer())));
            this.jsonCodec = new JsonCodecFactory((Provider)objectMapperProvider).jsonCodec(ResolvedFunction.class);
        }

        public Optional<ResolvedFunction> fromCatalogSchemaFunctionName(CatalogSchemaFunctionName name) {
            return this.fromQualifiedName(QualifiedName.of((String)name.getCatalogName(), (String[])new String[]{name.getSchemaName(), name.getFunctionName()}));
        }

        public Optional<ResolvedFunction> fromQualifiedName(QualifiedName qualifiedName) {
            if (!ResolvedFunction.isResolved(qualifiedName)) {
                return Optional.empty();
            }
            return Optional.of((ResolvedFunction)this.resolvedFunctions.getUnchecked((Object)qualifiedName));
        }

        public static CatalogSchemaFunctionName toCatalogSchemaFunctionName(ResolvedFunction function) {
            return (CatalogSchemaFunctionName)qualifiedNames.getUnchecked((Object)function);
        }

        private ResolvedFunction deserialize(QualifiedName qualifiedName) {
            SerializedResolvedFunction serialized = SerializedResolvedFunction.fromSerializedName(qualifiedName);
            String base32 = serialized.base32Data().toUpperCase(Locale.ENGLISH);
            byte[] compressed = BaseEncoding.base32Hex().decode((CharSequence)base32);
            ByteBuffer decompressed = ByteBuffer.allocate(Math.toIntExact(ZstdDecompressor.getDecompressedSize((byte[])compressed, (int)0, (int)compressed.length)));
            COMPRESSOR_DECOMPRESSOR.decompress(ByteBuffer.wrap(compressed), decompressed);
            ResolvedFunction resolvedFunction = (ResolvedFunction)this.jsonCodec.fromJson(Arrays.copyOf(decompressed.array(), decompressed.position()));
            Preconditions.checkArgument((boolean)resolvedFunction.getSignature().getName().toString().equalsIgnoreCase(serialized.functionName().toString()), (String)"Expected decoded function to have name %s, but name is %s", (Object)resolvedFunction.getSignature().getName(), (Object)serialized.functionName());
            return resolvedFunction;
        }

        private static CatalogSchemaFunctionName serialize(ResolvedFunction function) {
            byte[] value = SERIALIZE_JSON_CODEC.toJsonBytes((Object)function);
            ByteBuffer compressed = ByteBuffer.allocate(COMPRESSOR_DECOMPRESSOR.maxCompressedLength(value.length));
            COMPRESSOR_DECOMPRESSOR.compress(ByteBuffer.wrap(value), compressed);
            String base32 = BaseEncoding.base32Hex().encode(compressed.array(), 0, compressed.position());
            return new SerializedResolvedFunction(function.getSignature().getName(), base32).serialize();
        }
    }
}

