/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Throwables;
import io.airlift.slice.SizeOf;
import io.trino.operator.VariableWidthData;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Objects;

final class FlatSet {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(FlatSet.class);
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int INITIAL_CAPACITY = 16;
    private static final int RECORDS_PER_GROUP_SHIFT = 10;
    private static final int RECORDS_PER_GROUP = 1024;
    private static final int RECORDS_PER_GROUP_MASK = 1023;
    private static final int VECTOR_LENGTH = 8;
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private final Type type;
    private final MethodHandle writeFlat;
    private final MethodHandle hashFlat;
    private final MethodHandle distinctFlatBlock;
    private final MethodHandle hashBlock;
    private final int recordSize;
    private final int recordValueOffset;
    private boolean hasNull;
    private int capacity;
    private int mask;
    private byte[] control;
    private byte[][] recordGroups;
    private final VariableWidthData variableWidthData;
    private int size;
    private int maxFill;

    public FlatSet(Type type, MethodHandle writeFlat, MethodHandle hashFlat, MethodHandle distinctFlatBlock, MethodHandle hashBlock) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.writeFlat = Objects.requireNonNull(writeFlat, "writeFlat is null");
        this.hashFlat = Objects.requireNonNull(hashFlat, "hashFlat is null");
        this.distinctFlatBlock = Objects.requireNonNull(distinctFlatBlock, "distinctFlatBlock is null");
        this.hashBlock = Objects.requireNonNull(hashBlock, "hashBlock is null");
        this.capacity = 16;
        this.maxFill = FlatSet.calculateMaxFill(this.capacity);
        this.mask = this.capacity - 1;
        this.control = new byte[this.capacity + 8];
        boolean variableWidth = type.isFlatVariableWidth();
        this.variableWidthData = variableWidth ? new VariableWidthData() : null;
        this.recordValueOffset = variableWidth ? 12 : 0;
        this.recordSize = this.recordValueOffset + type.getFlatFixedSize();
        this.recordGroups = FlatSet.createRecordGroups(this.capacity, this.recordSize);
    }

    private static byte[][] createRecordGroups(int capacity, int recordSize) {
        if (capacity < 1024) {
            return new byte[][]{new byte[Math.multiplyExact(capacity, recordSize)]};
        }
        byte[][] groups = new byte[capacity + 1 >> 10][];
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = new byte[Math.multiplyExact(1024, recordSize)];
        }
        return groups;
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.control) + SizeOf.sizeOf((byte[])this.recordGroups[0]) * (long)this.recordGroups.length + (this.variableWidthData == null ? 0L : this.variableWidthData.getRetainedSizeBytes());
    }

    public int size() {
        return this.size + (this.hasNull ? 1 : 0);
    }

    public boolean containsNull() {
        return this.hasNull;
    }

    public boolean contains(Block block, int position) {
        if (block.isNull(position)) {
            return this.hasNull;
        }
        return this.getIndex(block, position, this.valueHashCode(block, position)) >= 0;
    }

    public boolean contains(Block block, int position, long hash) {
        if (block.isNull(position)) {
            return this.hasNull;
        }
        return this.getIndex(block, position, hash) >= 0;
    }

    public void add(Block block, int position) {
        if (block.isNull(position)) {
            this.hasNull = true;
            return;
        }
        this.addNonNull(block, position, this.valueHashCode(block, position));
    }

    public void add(Block block, int position, long hash) {
        if (block.isNull(position)) {
            this.hasNull = true;
            return;
        }
        this.addNonNull(block, position, hash);
    }

    private void addNonNull(Block block, int position, long hash) {
        int index = this.getIndex(block, position, hash);
        if (index >= 0) {
            return;
        }
        index = -index - 1;
        this.insert(index, block, position, hash);
        ++this.size;
        if (this.size >= this.maxFill) {
            this.rehash();
        }
    }

    private int getIndex(Block block, int position, long hash) {
        byte hashPrefix = (byte)(hash & 0x7FL | 0x80L);
        int bucket = this.bucket((int)(hash >> 7));
        int step = 1;
        long repeated = FlatSet.repeat(hashPrefix);
        long controlVector;
        int matchIndex;
        while ((matchIndex = this.matchInVector(block, position, bucket, repeated, controlVector = LONG_HANDLE.get(this.control, bucket))) < 0) {
            int emptyIndex = this.findEmptyInVector(controlVector, bucket);
            if (emptyIndex >= 0) {
                return -emptyIndex - 1;
            }
            bucket = this.bucket(bucket + step);
            step += 8;
        }
        return matchIndex;
    }

    private int matchInVector(Block block, int position, int vectorStartBucket, long repeated, long controlVector) {
        for (long controlMatches = FlatSet.match(controlVector, repeated); controlMatches != 0L; controlMatches &= controlMatches - 1L) {
            int bucket = this.bucket(vectorStartBucket + (Long.numberOfTrailingZeros(controlMatches) >>> 3));
            if (!this.valueNotDistinctFrom(bucket, block, position)) continue;
            return bucket;
        }
        return -1;
    }

    private int findEmptyInVector(long vector, int vectorStartBucket) {
        long controlMatches = FlatSet.match(vector, 0L);
        if (controlMatches == 0L) {
            return -1;
        }
        int slot = Long.numberOfTrailingZeros(controlMatches) >>> 3;
        return this.bucket(vectorStartBucket + slot);
    }

    private void insert(int index, Block block, int position, long hash) {
        this.setControl(index, (byte)(hash & 0x7FL | 0x80L));
        byte[] records = this.getRecords(index);
        int recordOffset = this.getRecordOffset(index);
        byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        int variableWidthChunkOffset = 0;
        if (this.variableWidthData != null) {
            int variableWidthLength = this.type.getFlatVariableWidthSize(block, position);
            variableWidthChunk = this.variableWidthData.allocate(records, recordOffset, variableWidthLength);
            variableWidthChunkOffset = VariableWidthData.getChunkOffset(records, recordOffset);
        }
        try {
            this.writeFlat.invokeExact(block, position, records, recordOffset + this.recordValueOffset, variableWidthChunk, variableWidthChunkOffset);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private void setControl(int index, byte hashPrefix) {
        this.control[index] = hashPrefix;
        if (index < 8) {
            this.control[index + this.capacity] = hashPrefix;
        }
    }

    private void rehash() {
        int oldCapacity = this.capacity;
        byte[] oldControl = this.control;
        byte[][] oldRecordGroups = this.recordGroups;
        long newCapacityLong = (long)this.capacity * 2L;
        if (newCapacityLong > 0x7FFFFFF7L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
        }
        this.capacity = (int)newCapacityLong;
        this.maxFill = FlatSet.calculateMaxFill(this.capacity);
        this.mask = this.capacity - 1;
        this.control = new byte[this.capacity + 8];
        this.recordGroups = FlatSet.createRecordGroups(this.capacity, this.recordSize);
        block0: for (int oldIndex = 0; oldIndex < oldCapacity; ++oldIndex) {
            if (oldControl[oldIndex] == 0) continue;
            byte[] oldRecords = oldRecordGroups[oldIndex >> 10];
            int oldRecordOffset = this.getRecordOffset(oldIndex);
            long hash = this.valueHashCode(oldRecords, oldIndex);
            byte hashPrefix = (byte)(hash & 0x7FL | 0x80L);
            int bucket = this.bucket((int)(hash >> 7));
            int step = 1;
            while (true) {
                long controlVector;
                int emptyIndex;
                if ((emptyIndex = this.findEmptyInVector(controlVector = LONG_HANDLE.get(this.control, bucket), bucket)) >= 0) {
                    this.setControl(emptyIndex, hashPrefix);
                    byte[] records = this.getRecords(emptyIndex);
                    int recordOffset = this.getRecordOffset(emptyIndex);
                    System.arraycopy(oldRecords, oldRecordOffset, records, recordOffset, this.recordSize);
                    continue block0;
                }
                bucket = this.bucket(bucket + step);
                step += 8;
            }
        }
    }

    private int bucket(int hash) {
        return hash & this.mask;
    }

    private byte[] getRecords(int index) {
        return this.recordGroups[index >> 10];
    }

    private int getRecordOffset(int index) {
        return (index & 0x3FF) * this.recordSize;
    }

    private long valueHashCode(byte[] records, int index) {
        int recordOffset = this.getRecordOffset(index);
        try {
            byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
            if (this.variableWidthData != null) {
                variableWidthChunk = this.variableWidthData.getChunk(records, recordOffset);
            }
            return this.hashFlat.invokeExact(records, recordOffset + this.recordValueOffset, variableWidthChunk);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private long valueHashCode(Block right, int rightPosition) {
        try {
            return this.hashBlock.invokeExact(right, rightPosition);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private boolean valueNotDistinctFrom(int leftPosition, Block right, int rightPosition) {
        byte[] leftRecords = this.getRecords(leftPosition);
        int leftRecordOffset = this.getRecordOffset(leftPosition);
        byte[] leftVariableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (this.variableWidthData != null) {
            leftVariableWidthChunk = this.variableWidthData.getChunk(leftRecords, leftRecordOffset);
        }
        try {
            return !this.distinctFlatBlock.invokeExact(leftRecords, leftRecordOffset + this.recordValueOffset, leftVariableWidthChunk, right, rightPosition);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private static long repeat(byte value) {
        return (long)(value & 0xFF) * 0x101010101010101L;
    }

    private static long match(long vector, long repeatedValue) {
        long comparison = vector ^ repeatedValue;
        return comparison - 0x101010101010101L & (comparison ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L;
    }

    private static int calculateMaxFill(int capacity) {
        return capacity / 16 * 15;
    }
}

