/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.trino.operator.CompletedWork;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.Work;
import io.trino.operator.project.InputChannels;
import io.trino.operator.project.PageProjection;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.DictionaryId;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class DictionaryAwarePageProjection
implements PageProjection {
    private static final DriverYieldSignal NON_YIELDING_SIGNAL = new DriverYieldSignal();
    private final PageProjection projection;
    private final Function<DictionaryBlock, DictionaryId> sourceIdFunction;
    private final boolean produceLazyBlock;
    private Block lastInputDictionary;
    private Optional<Block> lastOutputDictionary;
    private long lastDictionaryUsageCount;

    public DictionaryAwarePageProjection(PageProjection projection, Function<DictionaryBlock, DictionaryId> sourceIdFunction, boolean produceLazyBlock) {
        this.projection = Objects.requireNonNull(projection, "projection is null");
        this.sourceIdFunction = sourceIdFunction;
        this.produceLazyBlock = produceLazyBlock;
        Verify.verify((boolean)projection.isDeterministic(), (String)"projection must be deterministic", (Object[])new Object[0]);
        Verify.verify((projection.getInputChannels().size() == 1 ? 1 : 0) != 0, (String)"projection must have only one input", (Object[])new Object[0]);
    }

    @Override
    public Type getType() {
        return this.projection.getType();
    }

    @Override
    public boolean isDeterministic() {
        return this.projection.isDeterministic();
    }

    @Override
    public InputChannels getInputChannels() {
        return this.projection.getInputChannels();
    }

    @Override
    public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
        return new DictionaryAwarePageProjectionWork(session, yieldSignal, page, selectedPositions);
    }

    private static int[] filterDictionaryIds(DictionaryBlock dictionaryBlock, SelectedPositions selectedPositions) {
        int[] outputIds = new int[selectedPositions.size()];
        if (selectedPositions.isList()) {
            int[] positions = selectedPositions.getPositions();
            int endPosition = selectedPositions.getOffset() + selectedPositions.size();
            int outputIndex = 0;
            for (int position = selectedPositions.getOffset(); position < endPosition; ++position) {
                outputIds[outputIndex++] = dictionaryBlock.getId(positions[position]);
            }
        } else {
            int endPosition = selectedPositions.getOffset() + selectedPositions.size();
            int outputIndex = 0;
            for (int position = selectedPositions.getOffset(); position < endPosition; ++position) {
                outputIds[outputIndex++] = dictionaryBlock.getId(position);
            }
        }
        return outputIds;
    }

    private class DictionaryAwarePageProjectionWork
    implements Work<Block> {
        private final ConnectorSession session;
        private final DriverYieldSignal yieldSignal;
        private final SelectedPositions selectedPositions;
        private final boolean produceLazyBlock;
        private Block block;
        private Block result;
        private Work<Block> dictionaryProcessingProjectionWork;
        private Work<Block> fallbackProcessingProjectionWork;

        public DictionaryAwarePageProjectionWork(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            this.session = session;
            this.block = page.getBlock(0);
            this.selectedPositions = Objects.requireNonNull(selectedPositions, "selectedPositions is null");
            boolean bl = this.produceLazyBlock = DictionaryAwarePageProjection.this.produceLazyBlock && !this.block.isLoaded();
            if (this.produceLazyBlock) {
                this.yieldSignal = NON_YIELDING_SIGNAL;
            } else {
                this.yieldSignal = Objects.requireNonNull(yieldSignal, "yieldSignal is null");
                this.setupDictionaryBlockProjection();
            }
        }

        @Override
        public boolean process() {
            if (this.produceLazyBlock) {
                return true;
            }
            return this.processInternal();
        }

        private boolean processInternal() {
            Preconditions.checkState((this.result == null ? 1 : 0) != 0, (Object)"result has been generated");
            if (this.fallbackProcessingProjectionWork != null) {
                if (this.fallbackProcessingProjectionWork.process()) {
                    this.result = this.fallbackProcessingProjectionWork.getResult();
                    return true;
                }
                return false;
            }
            Optional<Object> dictionaryOutput = Optional.empty();
            if (this.dictionaryProcessingProjectionWork != null) {
                try {
                    if (!this.dictionaryProcessingProjectionWork.process()) {
                        return false;
                    }
                    dictionaryOutput = Optional.of(this.dictionaryProcessingProjectionWork.getResult());
                    DictionaryAwarePageProjection.this.lastOutputDictionary = dictionaryOutput;
                }
                catch (Exception ignored) {
                    DictionaryAwarePageProjection.this.lastOutputDictionary = Optional.empty();
                    this.dictionaryProcessingProjectionWork = null;
                }
            }
            if (this.block instanceof DictionaryBlock) {
                DictionaryAwarePageProjection.this.lastDictionaryUsageCount += (long)this.selectedPositions.size();
            }
            if (dictionaryOutput.isPresent()) {
                if (this.block instanceof RunLengthEncodedBlock) {
                    this.result = RunLengthEncodedBlock.create((Block)((Block)dictionaryOutput.get()), (int)this.selectedPositions.size());
                    return true;
                }
                Block block = this.block;
                if (block instanceof DictionaryBlock) {
                    DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
                    int[] outputIds = DictionaryAwarePageProjection.filterDictionaryIds(dictionaryBlock, this.selectedPositions);
                    this.result = DictionaryBlock.createProjectedDictionaryBlock((int)this.selectedPositions.size(), (Block)((Block)dictionaryOutput.get()), (int[])outputIds, (DictionaryId)DictionaryAwarePageProjection.this.sourceIdFunction.apply(dictionaryBlock));
                    return true;
                }
                throw new UnsupportedOperationException("unexpected block type " + String.valueOf(this.block.getClass()));
            }
            Verify.verify((this.dictionaryProcessingProjectionWork == null ? 1 : 0) != 0);
            Verify.verify((this.fallbackProcessingProjectionWork == null ? 1 : 0) != 0);
            this.fallbackProcessingProjectionWork = DictionaryAwarePageProjection.this.projection.project(this.session, this.yieldSignal, new Page(new Block[]{this.block}), this.selectedPositions);
            if (this.fallbackProcessingProjectionWork.process()) {
                this.result = this.fallbackProcessingProjectionWork.getResult();
                return true;
            }
            return false;
        }

        @Override
        public Block getResult() {
            if (this.produceLazyBlock) {
                return new LazyBlock(this.selectedPositions.size(), () -> {
                    this.setupDictionaryBlockProjection();
                    Preconditions.checkState((boolean)this.processInternal(), (Object)"processInternal() yielded");
                    Preconditions.checkState((this.result != null ? 1 : 0) != 0, (Object)"result has not been generated");
                    return this.result.getLoadedBlock();
                });
            }
            Preconditions.checkState((this.result != null ? 1 : 0) != 0, (Object)"result has not been generated");
            return this.result;
        }

        private void setupDictionaryBlockProjection() {
            this.block = this.block.getLoadedBlock();
            Optional<Object> dictionary = Optional.empty();
            if (this.block instanceof RunLengthEncodedBlock) {
                dictionary = Optional.of(((RunLengthEncodedBlock)this.block).getValue());
            } else if (this.block instanceof DictionaryBlock) {
                dictionary = Optional.of(((DictionaryBlock)this.block).getDictionary());
            }
            this.dictionaryProcessingProjectionWork = this.createDictionaryBlockProjection(dictionary, this.block.getPositionCount());
        }

        private Work<Block> createDictionaryBlockProjection(Optional<Block> dictionary, int blockPositionsCount) {
            if (dictionary.isEmpty()) {
                DictionaryAwarePageProjection.this.lastOutputDictionary = Optional.empty();
                return null;
            }
            if (DictionaryAwarePageProjection.this.lastInputDictionary == dictionary.get()) {
                return DictionaryAwarePageProjection.this.lastOutputDictionary.map(CompletedWork::new).orElse(null);
            }
            boolean shouldProcessDictionary = dictionary.get().getPositionCount() <= blockPositionsCount || DictionaryAwarePageProjection.this.lastInputDictionary == null || DictionaryAwarePageProjection.this.lastDictionaryUsageCount >= (long)DictionaryAwarePageProjection.this.lastInputDictionary.getPositionCount();
            DictionaryAwarePageProjection.this.lastDictionaryUsageCount = 0L;
            DictionaryAwarePageProjection.this.lastInputDictionary = dictionary.get();
            DictionaryAwarePageProjection.this.lastOutputDictionary = Optional.empty();
            if (shouldProcessDictionary) {
                return DictionaryAwarePageProjection.this.projection.project(this.session, this.yieldSignal, new Page(new Block[]{DictionaryAwarePageProjection.this.lastInputDictionary}), SelectedPositions.positionsRange(0, DictionaryAwarePageProjection.this.lastInputDictionary.getPositionCount()));
            }
            return null;
        }
    }
}

