/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedMapValueBuilder;
import io.trino.spi.block.DuplicateMapKeyException;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameters;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import java.util.List;

@ScalarFunction(value="map_from_entries")
@Description(value="Construct a map from an array of entries")
public final class MapFromEntriesFunction {
    private final BufferedMapValueBuilder mapValueBuilder;

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    public MapFromEntriesFunction(@TypeParameter(value="map(K,V)") Type mapType) {
        this.mapValueBuilder = BufferedMapValueBuilder.createBufferedDistinctStrict((MapType)((MapType)mapType));
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="map(K,V)")
    @SqlNullable
    public SqlMap mapFromEntries(@OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"K", "K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionIsDistinctFrom keysDistinctOperator, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode keyHashCode, @TypeParameter(value="map(K,V)") MapType mapType, ConnectorSession session, @SqlType(value="array(row(K,V))") Block mapEntries) {
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        RowType mapEntryType = RowType.anonymous((List)ImmutableList.of((Object)keyType, (Object)valueType));
        int entryCount = mapEntries.getPositionCount();
        try {
            return this.mapValueBuilder.build(entryCount, (keyBuilder, valueBuilder) -> {
                for (int i = 0; i < entryCount; ++i) {
                    if (mapEntries.isNull(i)) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map entry cannot be null");
                    }
                    SqlRow entry = mapEntryType.getObject(mapEntries, i);
                    int rawIndex = entry.getRawIndex();
                    Block keyBlock = entry.getRawFieldBlock(0);
                    if (keyBlock.isNull(rawIndex)) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be null");
                    }
                    keyType.appendTo(keyBlock, rawIndex, keyBuilder);
                    valueType.appendTo(entry.getRawFieldBlock(1), rawIndex, valueBuilder);
                }
            });
        }
        catch (DuplicateMapKeyException e) {
            throw e.withDetailedMessage(mapType.getKeyType(), session);
        }
    }
}

