/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.operator.scalar.BlockSet;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedMapValueBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameters;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;

@ScalarFunction(value="multimap_from_entries")
@Description(value="Construct a multimap from an array of entries")
public final class MultimapFromEntriesFunction {
    private static final int INITIAL_ENTRY_COUNT = 128;
    private final BufferedMapValueBuilder mapValueBuilder;
    private IntList[] entryIndicesList;

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    public MultimapFromEntriesFunction(@TypeParameter(value="map(K,array(V))") Type mapType) {
        this.mapValueBuilder = BufferedMapValueBuilder.createBuffered((MapType)((MapType)mapType));
        this.initializeEntryIndicesList(128);
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="map(K,array(V))")
    @SqlNullable
    public SqlMap multimapFromEntries(@TypeParameter(value="map(K,array(V))") MapType mapType, @OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"K", "K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionIsDistinctFrom keysDistinctOperator, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode keyHashCode, @SqlType(value="array(row(K,V))") Block mapEntries) {
        Type keyType = mapType.getKeyType();
        Type valueType = ((ArrayType)mapType.getValueType()).getElementType();
        RowType mapEntryType = RowType.anonymous((List)ImmutableList.of((Object)keyType, (Object)valueType));
        int entryCount = mapEntries.getPositionCount();
        if (entryCount > this.entryIndicesList.length) {
            this.initializeEntryIndicesList(entryCount);
        }
        BlockSet keySet = new BlockSet(keyType, keysDistinctOperator, keyHashCode, entryCount);
        for (int i = 0; i < entryCount; ++i) {
            if (mapEntries.isNull(i)) {
                this.clearEntryIndices(keySet.size());
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map entry cannot be null");
            }
            SqlRow entry = mapEntryType.getObject(mapEntries, i);
            int rawIndex = entry.getRawIndex();
            Block keyBlock = entry.getRawFieldBlock(0);
            if (keyBlock.isNull(rawIndex)) {
                this.clearEntryIndices(keySet.size());
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be null");
            }
            if (keySet.add(keyBlock, rawIndex)) {
                this.entryIndicesList[keySet.size() - 1].add(i);
                continue;
            }
            this.entryIndicesList[keySet.positionOf(keyBlock, rawIndex)].add(i);
        }
        SqlMap resultMap = this.mapValueBuilder.build(keySet.size(), (keyBuilder, valueBuilder) -> {
            for (int i = 0; i < keySet.size(); ++i) {
                IntList indexList = this.entryIndicesList[i];
                SqlRow keyEntry = mapEntryType.getObject(mapEntries, indexList.getInt(0));
                keyType.appendTo(keyEntry.getRawFieldBlock(0), keyEntry.getRawIndex(), keyBuilder);
                ((ArrayBlockBuilder)valueBuilder).buildEntry(elementBuilder -> {
                    IntListIterator intListIterator = indexList.iterator();
                    while (intListIterator.hasNext()) {
                        int entryIndex = (Integer)intListIterator.next();
                        SqlRow valueEntry = mapEntryType.getObject(mapEntries, entryIndex);
                        valueType.appendTo(valueEntry.getRawFieldBlock(1), valueEntry.getRawIndex(), elementBuilder);
                    }
                });
            }
        });
        this.clearEntryIndices(keySet.size());
        return resultMap;
    }

    private void clearEntryIndices(int entryCount) {
        Verify.verify((entryCount <= this.entryIndicesList.length ? 1 : 0) != 0);
        for (int i = 0; i < entryCount; ++i) {
            this.entryIndicesList[i].clear();
        }
    }

    private void initializeEntryIndicesList(int entryCount) {
        this.entryIndicesList = new IntList[entryCount];
        for (int i = 0; i < this.entryIndicesList.length; ++i) {
            this.entryIndicesList[i] = new IntArrayList();
        }
    }
}

