/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.base.Preconditions;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesIndexComparator;
import io.trino.operator.window.FrameInfo;
import io.trino.operator.window.Framing;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.WindowFrameType;
import java.util.function.Predicate;

public class RangeFraming
implements Framing {
    private final FrameInfo frameInfo;
    private final PagesIndexComparator startComparator;
    private final PagesIndexComparator endComparator;
    private final PagesIndex pagesIndex;
    private final PagesHashStrategy peerGroupHashStrategy;
    private final int partitionStart;
    private final int partitionEnd;
    private Framing.Range recentRange;

    public RangeFraming(FrameInfo frameInfo, int partitionStart, int partitionEnd, PagesIndexComparator startComparator, PagesIndexComparator endComparator, PagesIndex pagesIndex, PagesHashStrategy peerGroupHashStrategy, Framing.Range initialRange) {
        Preconditions.checkArgument((frameInfo.getType() == WindowFrameType.RANGE ? 1 : 0) != 0, (String)"Frame must be of type RANGE, actual: %s", (Object)((Object)frameInfo.getType()));
        this.frameInfo = frameInfo;
        this.partitionStart = partitionStart;
        this.partitionEnd = partitionEnd;
        this.startComparator = startComparator;
        this.endComparator = endComparator;
        this.pagesIndex = pagesIndex;
        this.peerGroupHashStrategy = peerGroupHashStrategy;
        this.recentRange = initialRange;
    }

    @Override
    public Framing.Range getRange(int currentPosition, int currentGroup, int peerGroupStart, int peerGroupEnd) {
        Framing.Range range = this.getFrameRange(currentPosition, peerGroupStart, peerGroupEnd);
        if (this.emptyFrame(range)) {
            this.recentRange = this.nearestValidFrame(range);
            return new Framing.Range(-1, -1);
        }
        this.recentRange = range;
        return range;
    }

    private Framing.Range getFrameRange(int currentPosition, int peerGroupStart, int peerGroupEnd) {
        if (this.frameInfo.getStartType() == FrameBoundType.UNBOUNDED_PRECEDING && this.frameInfo.getEndType() == FrameBoundType.UNBOUNDED_FOLLOWING) {
            return new Framing.Range(0, this.partitionEnd - this.partitionStart - 1);
        }
        if (this.frameInfo.getStartType() == FrameBoundType.CURRENT_ROW && this.frameInfo.getEndType() == FrameBoundType.CURRENT_ROW || this.frameInfo.getStartType() == FrameBoundType.CURRENT_ROW && this.frameInfo.getEndType() == FrameBoundType.UNBOUNDED_FOLLOWING || this.frameInfo.getStartType() == FrameBoundType.UNBOUNDED_PRECEDING && this.frameInfo.getEndType() == FrameBoundType.CURRENT_ROW) {
            if (currentPosition == this.partitionStart || this.pagesIndex.positionNotDistinctFromPosition(this.peerGroupHashStrategy, currentPosition - 1, currentPosition)) {
                return this.recentRange;
            }
            return new Framing.Range(this.frameInfo.getStartType() == FrameBoundType.UNBOUNDED_PRECEDING ? 0 : peerGroupStart - this.partitionStart, this.frameInfo.getEndType() == FrameBoundType.UNBOUNDED_FOLLOWING ? this.partitionEnd - this.partitionStart - 1 : peerGroupEnd - this.partitionStart - 1);
        }
        if (this.pagesIndex.isNull(this.frameInfo.getSortKeyChannel(), currentPosition)) {
            return new Framing.Range(this.frameInfo.getStartType() == FrameBoundType.UNBOUNDED_PRECEDING ? 0 : peerGroupStart - this.partitionStart, this.frameInfo.getEndType() == FrameBoundType.UNBOUNDED_FOLLOWING ? this.partitionEnd - this.partitionStart - 1 : peerGroupEnd - this.partitionStart - 1);
        }
        int frameStart = this.frameInfo.getStartType() == FrameBoundType.UNBOUNDED_PRECEDING ? 0 : (this.frameInfo.getStartType() == FrameBoundType.CURRENT_ROW ? peerGroupStart - this.partitionStart : (this.frameInfo.getStartType() == FrameBoundType.PRECEDING ? this.getFrameStartPreceding(currentPosition) : this.getFrameStartFollowing(currentPosition)));
        int frameEnd = this.frameInfo.getEndType() == FrameBoundType.UNBOUNDED_FOLLOWING ? this.partitionEnd - this.partitionStart - 1 : (this.frameInfo.getEndType() == FrameBoundType.CURRENT_ROW ? peerGroupEnd - this.partitionStart - 1 : (this.frameInfo.getEndType() == FrameBoundType.PRECEDING ? this.getFrameEndPreceding(currentPosition) : this.getFrameEndFollowing(currentPosition)));
        return new Framing.Range(frameStart, frameEnd);
    }

    private int getFrameStartPreceding(int currentPosition) {
        int sortKeyChannel = this.frameInfo.getSortKeyChannelForStartComparison();
        FrameInfo.Ordering ordering = this.frameInfo.getOrdering().get();
        int recent = this.recentRange.getStart();
        if (this.pagesIndex.isNull(this.frameInfo.getSortKeyChannel(), this.partitionStart + recent)) {
            return currentPosition - this.partitionStart;
        }
        return this.seek(currentPosition, this.startComparator, sortKeyChannel, recent, -1, ordering == FrameInfo.Ordering.DESCENDING, 0, p -> false);
    }

    private int getFrameStartFollowing(int currentPosition) {
        int recent;
        int sortKeyChannel = this.frameInfo.getSortKeyChannelForStartComparison();
        FrameInfo.Ordering ordering = this.frameInfo.getOrdering().get();
        int position = recent = this.recentRange.getStart();
        if (recent == 0 && this.pagesIndex.isNull(this.frameInfo.getSortKeyChannel(), this.partitionStart)) {
            position = currentPosition - this.partitionStart;
        }
        while (this.pagesIndex.isNull(this.frameInfo.getSortKeyChannel(), this.partitionStart + position)) {
            --position;
        }
        return this.seek(currentPosition, this.startComparator, sortKeyChannel, position, -1, ordering == FrameInfo.Ordering.DESCENDING, 0, p -> p >= this.partitionEnd - this.partitionStart || this.pagesIndex.isNull(sortKeyChannel, this.partitionStart + p));
    }

    private int getFrameEndPreceding(int currentPosition) {
        int sortKeyChannel = this.frameInfo.getSortKeyChannelForEndComparison();
        FrameInfo.Ordering ordering = this.frameInfo.getOrdering().get();
        int position = this.recentRange.getEnd();
        while (this.pagesIndex.isNull(this.frameInfo.getSortKeyChannel(), this.partitionStart + position)) {
            ++position;
        }
        return this.seek(currentPosition, this.endComparator, sortKeyChannel, position, 1, ordering == FrameInfo.Ordering.ASCENDING, this.partitionEnd - 1 - this.partitionStart, p -> p < 0 || this.pagesIndex.isNull(sortKeyChannel, this.partitionStart + p));
    }

    private int getFrameEndFollowing(int currentPosition) {
        int recent;
        FrameInfo.Ordering ordering = this.frameInfo.getOrdering().get();
        int sortKeyChannel = this.frameInfo.getSortKeyChannelForEndComparison();
        int position = recent = this.recentRange.getEnd();
        if (this.pagesIndex.isNull(this.frameInfo.getSortKeyChannel(), this.partitionStart + recent)) {
            position = currentPosition - this.partitionStart;
        }
        return this.seek(currentPosition, this.endComparator, sortKeyChannel, position, 1, ordering == FrameInfo.Ordering.ASCENDING, this.partitionEnd - 1 - this.partitionStart, p -> false);
    }

    private int seek(int currentPosition, PagesIndexComparator comparator, int sortKeyChannel, int position, int step, boolean reverse, int limit, Predicate<Integer> bound) {
        int newComparison;
        int comparison = this.compare(comparator, this.partitionStart + position, currentPosition, reverse);
        while (comparison < 0) {
            if (bound.test(position -= step)) {
                return position;
            }
            comparison = this.compare(comparator, this.partitionStart + position, currentPosition, reverse);
        }
        while (position != limit && !this.pagesIndex.isNull(sortKeyChannel, this.partitionStart + position + step) && (newComparison = this.compare(comparator, this.partitionStart + position + step, currentPosition, reverse)) >= 0) {
            position += step;
        }
        return position;
    }

    private int compare(PagesIndexComparator comparator, int left, int right, boolean reverse) {
        int result = comparator.compareTo(this.pagesIndex, left, right);
        if (reverse) {
            return -result;
        }
        return result;
    }

    private boolean emptyFrame(Framing.Range range) {
        return range.getStart() > range.getEnd() || range.getStart() >= this.partitionEnd - this.partitionStart || range.getEnd() < 0;
    }

    private Framing.Range nearestValidFrame(Framing.Range range) {
        return new Framing.Range(Math.min(this.partitionEnd - this.partitionStart - 1, range.getStart()), Math.max(0, range.getEnd()));
    }
}

