/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.inject.Inject;
import io.trino.sql.ExpressionFormatter;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.Expression;
import java.io.IOException;

public final class ExpressionSerialization {
    private ExpressionSerialization() {
    }

    public static class ExpressionDeserializer
    extends JsonDeserializer<Expression> {
        private final SqlParser sqlParser;

        @Inject
        public ExpressionDeserializer(SqlParser sqlParser) {
            this.sqlParser = sqlParser;
        }

        public Expression deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return IrUtils.rewriteIdentifiersToSymbolReferences(this.sqlParser.createExpression((String)jsonParser.readValueAs(String.class)));
        }
    }

    public static class ExpressionSerializer
    extends JsonSerializer<Expression> {
        public void serialize(Expression expression, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(ExpressionFormatter.formatExpression((Expression)expression));
        }
    }
}

