/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import io.trino.server.ui.MultipartUiCookie;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;

public final class OAuthWebUiCookie {
    public static final String OAUTH2_COOKIE = "__Secure-Trino-OAuth2-Token";
    private static final MultipartUiCookie MULTIPART_COOKIE = new MultipartUiCookie("__Secure-Trino-OAuth2-Token", "/ui/");

    private OAuthWebUiCookie() {
    }

    public static NewCookie[] create(String token, Instant tokenExpiration) {
        return MULTIPART_COOKIE.create(token, tokenExpiration, true);
    }

    public static Optional<String> read(Map<String, Cookie> availableCookies) {
        return MULTIPART_COOKIE.read(availableCookies);
    }

    public static NewCookie[] delete(Map<String, Cookie> availableCookies) {
        return MULTIPART_COOKIE.delete(availableCookies, true);
    }
}

