/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.errorprone.annotations.FormatMethod;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.analyzer.ExpressionTreeUtils;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.QualifiedName;

public final class SemanticExceptions {
    private SemanticExceptions() {
    }

    public static TrinoException missingAttributeException(Expression node, QualifiedName name) {
        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)node, "Column '%s' cannot be resolved", name);
    }

    public static TrinoException ambiguousAttributeException(Expression node, QualifiedName name) {
        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_NAME, (Node)node, "Column '%s' is ambiguous", name);
    }

    @FormatMethod
    public static TrinoException semanticException(ErrorCodeSupplier code, Node node, String format, Object ... args) {
        return SemanticExceptions.semanticException(code, node, null, format, args);
    }

    @FormatMethod
    public static TrinoException semanticException(ErrorCodeSupplier code, Node node, Throwable cause, String format, Object ... args) {
        throw new TrinoException(code, ExpressionTreeUtils.extractLocation(node), String.format(format, args), cause);
    }
}

