/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.NoOpSymbolResolver;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.RowDataType;
import io.trino.sql.tree.SymbolReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class IrUtils {
    private IrUtils() {
    }

    public static List<Expression> extractConjuncts(Expression expression) {
        return IrUtils.extractPredicates(LogicalExpression.Operator.AND, expression);
    }

    public static List<Expression> extractDisjuncts(Expression expression) {
        return IrUtils.extractPredicates(LogicalExpression.Operator.OR, expression);
    }

    public static List<Expression> extractPredicates(LogicalExpression expression) {
        return IrUtils.extractPredicates(expression.getOperator(), (Expression)expression);
    }

    public static List<Expression> extractPredicates(LogicalExpression.Operator operator, Expression expression) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        IrUtils.extractPredicates(operator, expression, (ImmutableList.Builder<Expression>)resultBuilder);
        return resultBuilder.build();
    }

    private static void extractPredicates(LogicalExpression.Operator operator, Expression expression, ImmutableList.Builder<Expression> resultBuilder) {
        LogicalExpression logicalExpression;
        if (expression instanceof LogicalExpression && (logicalExpression = (LogicalExpression)expression).getOperator() == operator) {
            for (Expression term : logicalExpression.getTerms()) {
                IrUtils.extractPredicates(operator, term, resultBuilder);
            }
        } else {
            resultBuilder.add((Object)expression);
        }
    }

    public static Expression and(Expression ... expressions) {
        return IrUtils.and(Arrays.asList(expressions));
    }

    public static Expression and(Collection<Expression> expressions) {
        return IrUtils.logicalExpression(LogicalExpression.Operator.AND, expressions);
    }

    public static Expression or(Expression ... expressions) {
        return IrUtils.or(Arrays.asList(expressions));
    }

    public static Expression or(Collection<Expression> expressions) {
        return IrUtils.logicalExpression(LogicalExpression.Operator.OR, expressions);
    }

    public static Expression logicalExpression(LogicalExpression.Operator operator, Collection<Expression> expressions) {
        Objects.requireNonNull(operator, "operator is null");
        Objects.requireNonNull(expressions, "expressions is null");
        if (expressions.isEmpty()) {
            switch (operator) {
                case AND: {
                    return BooleanLiteral.TRUE_LITERAL;
                }
                case OR: {
                    return BooleanLiteral.FALSE_LITERAL;
                }
            }
            throw new IllegalArgumentException("Unsupported LogicalExpression operator");
        }
        if (expressions.size() == 1) {
            return (Expression)Iterables.getOnlyElement(expressions);
        }
        return new LogicalExpression(operator, (List)ImmutableList.copyOf(expressions));
    }

    public static Expression combinePredicates(Metadata metadata, LogicalExpression.Operator operator, Expression ... expressions) {
        return IrUtils.combinePredicates(metadata, operator, Arrays.asList(expressions));
    }

    public static Expression combinePredicates(Metadata metadata, LogicalExpression.Operator operator, Collection<Expression> expressions) {
        if (operator == LogicalExpression.Operator.AND) {
            return IrUtils.combineConjuncts(metadata, expressions);
        }
        return IrUtils.combineDisjuncts(metadata, expressions);
    }

    public static Expression combineConjuncts(Metadata metadata, Expression ... expressions) {
        return IrUtils.combineConjuncts(metadata, Arrays.asList(expressions));
    }

    public static Expression combineConjuncts(Metadata metadata, Collection<Expression> expressions) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> conjuncts = expressions.stream().flatMap(e -> IrUtils.extractConjuncts(e).stream()).filter(e -> !e.equals((Object)BooleanLiteral.TRUE_LITERAL)).collect(Collectors.toList());
        conjuncts = IrUtils.removeDuplicates(metadata, conjuncts);
        if (conjuncts.contains(BooleanLiteral.FALSE_LITERAL)) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        return IrUtils.and(conjuncts);
    }

    public static Expression combineConjunctsWithDuplicates(Collection<Expression> expressions) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> conjuncts = expressions.stream().flatMap(e -> IrUtils.extractConjuncts(e).stream()).filter(e -> !e.equals((Object)BooleanLiteral.TRUE_LITERAL)).collect(Collectors.toList());
        if (conjuncts.contains(BooleanLiteral.FALSE_LITERAL)) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        return IrUtils.and(conjuncts);
    }

    public static Expression combineDisjuncts(Metadata metadata, Expression ... expressions) {
        return IrUtils.combineDisjuncts(metadata, Arrays.asList(expressions));
    }

    public static Expression combineDisjuncts(Metadata metadata, Collection<Expression> expressions) {
        return IrUtils.combineDisjunctsWithDefault(metadata, expressions, (Expression)BooleanLiteral.FALSE_LITERAL);
    }

    public static Expression combineDisjunctsWithDefault(Metadata metadata, Collection<Expression> expressions, Expression emptyDefault) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> disjuncts = expressions.stream().flatMap(e -> IrUtils.extractDisjuncts(e).stream()).filter(e -> !e.equals((Object)BooleanLiteral.FALSE_LITERAL)).collect(Collectors.toList());
        disjuncts = IrUtils.removeDuplicates(metadata, disjuncts);
        if (disjuncts.contains(BooleanLiteral.TRUE_LITERAL)) {
            return BooleanLiteral.TRUE_LITERAL;
        }
        return disjuncts.isEmpty() ? emptyDefault : IrUtils.or(disjuncts);
    }

    public static Expression filterDeterministicConjuncts(Metadata metadata, Expression expression) {
        return IrUtils.filterConjuncts(metadata, expression, expression1 -> DeterminismEvaluator.isDeterministic(expression1, metadata));
    }

    public static Expression filterNonDeterministicConjuncts(Metadata metadata, Expression expression) {
        return IrUtils.filterConjuncts(metadata, expression, (Predicate<Expression>)Predicates.not(testExpression -> DeterminismEvaluator.isDeterministic(testExpression, metadata)));
    }

    public static Expression filterConjuncts(Metadata metadata, Expression expression, Predicate<Expression> predicate) {
        List<Expression> conjuncts = IrUtils.extractConjuncts(expression).stream().filter(predicate).collect(Collectors.toList());
        return IrUtils.combineConjuncts(metadata, conjuncts);
    }

    @SafeVarargs
    public static Function<Expression, Expression> expressionOrNullSymbols(Predicate<Symbol> ... nullSymbolScopes) {
        return expression -> {
            ImmutableList.Builder resultDisjunct = ImmutableList.builder();
            resultDisjunct.add(expression);
            for (Predicate nullSymbolScope : nullSymbolScopes) {
                List symbols = (List)SymbolsExtractor.extractUnique(expression).stream().filter(nullSymbolScope).collect(ImmutableList.toImmutableList());
                if (symbols.isEmpty()) continue;
                ImmutableList.Builder nullConjuncts = ImmutableList.builder();
                for (Symbol symbol : symbols) {
                    nullConjuncts.add((Object)new IsNullPredicate((Expression)symbol.toSymbolReference()));
                }
                resultDisjunct.add((Object)IrUtils.and((Collection<Expression>)nullConjuncts.build()));
            }
            return IrUtils.or((Collection<Expression>)resultDisjunct.build());
        };
    }

    public static boolean isEffectivelyLiteral(PlannerContext plannerContext, Session session, Expression expression) {
        QualifiedName functionName;
        if (expression instanceof Literal) {
            return true;
        }
        if (expression instanceof Cast) {
            return ((Cast)expression).getExpression() instanceof Literal && IrUtils.constantExpressionEvaluatesSuccessfully(plannerContext, session, expression);
        }
        if (expression instanceof FunctionCall && ResolvedFunction.isResolved(functionName = ((FunctionCall)expression).getName())) {
            ResolvedFunction resolvedFunction = plannerContext.getMetadata().decodeFunction(functionName);
            return "$literal$".equals(resolvedFunction.getSignature().getName().getFunctionName());
        }
        return false;
    }

    private static boolean constantExpressionEvaluatesSuccessfully(PlannerContext plannerContext, Session session, Expression constantExpression) {
        Map<NodeRef<Expression>, Type> types = new IrTypeAnalyzer(plannerContext).getTypes(session, TypeProvider.empty(), constantExpression);
        IrExpressionInterpreter interpreter = new IrExpressionInterpreter(constantExpression, plannerContext, session, types);
        Object literalValue = interpreter.optimize(NoOpSymbolResolver.INSTANCE);
        return !(literalValue instanceof Expression);
    }

    private static List<Expression> removeDuplicates(Metadata metadata, List<Expression> expressions) {
        HashSet<Expression> seen = new HashSet<Expression>();
        ImmutableList.Builder result = ImmutableList.builder();
        for (Expression expression : expressions) {
            if (!DeterminismEvaluator.isDeterministic(expression, metadata)) {
                result.add((Object)expression);
                continue;
            }
            if (seen.contains(expression)) continue;
            result.add((Object)expression);
            seen.add(expression);
        }
        return result.build();
    }

    public static Expression rewriteIdentifiersToSymbolReferences(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteIdentifier(Identifier node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return new SymbolReference(node.getValue());
            }

            public Expression rewriteLambdaExpression(LambdaExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return new LambdaExpression(node.getArguments(), treeRewriter.rewrite(node.getBody(), (Object)context));
            }

            public Expression rewriteGenericDataType(GenericDataType node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return node;
            }

            public Expression rewriteRowDataType(RowDataType node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return node;
            }
        }, (Expression)expression);
    }
}

