/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class PartialTranslator {
    private PartialTranslator() {
    }

    public static Map<NodeRef<Expression>, ConnectorExpression> extractPartialTranslations(Expression inputExpression, Session session, IrTypeAnalyzer typeAnalyzer, TypeProvider typeProvider, PlannerContext plannerContext) {
        Objects.requireNonNull(inputExpression, "inputExpression is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        Objects.requireNonNull(typeProvider, "typeProvider is null");
        HashMap<NodeRef<Expression>, ConnectorExpression> partialTranslations = new HashMap<NodeRef<Expression>, ConnectorExpression>();
        new Visitor(session, typeAnalyzer.getTypes(session, typeProvider, inputExpression), partialTranslations, plannerContext).process((Node)inputExpression);
        return ImmutableMap.copyOf(partialTranslations);
    }

    private static class Visitor
    extends AstVisitor<Void, Void> {
        private final Map<NodeRef<Expression>, ConnectorExpression> translatedSubExpressions;
        private final ConnectorExpressionTranslator.SqlToConnectorExpressionTranslator translator;

        Visitor(Session session, Map<NodeRef<Expression>, Type> types, Map<NodeRef<Expression>, ConnectorExpression> translatedSubExpressions, PlannerContext plannerContext) {
            Objects.requireNonNull(types, "types is null");
            this.translatedSubExpressions = Objects.requireNonNull(translatedSubExpressions, "translatedSubExpressions is null");
            this.translator = new ConnectorExpressionTranslator.SqlToConnectorExpressionTranslator(session, types, plannerContext);
        }

        public Void visitExpression(Expression node, Void context) {
            Optional result = (Optional)this.translator.process((Node)node);
            if (result.isPresent()) {
                this.translatedSubExpressions.put((NodeRef<Expression>)NodeRef.of((Node)node), (ConnectorExpression)result.get());
            } else {
                node.getChildren().forEach(arg_0 -> ((Visitor)this).process(arg_0));
            }
            return null;
        }

        public Void visitLambdaExpression(LambdaExpression functionCall, Void context) {
            return null;
        }
    }
}

