/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.WhenClause;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class CanonicalizeExpressionRewriter {
    public static Expression canonicalizeExpression(Expression expression, IrTypeAnalyzer typeAnalyzer, TypeProvider types, PlannerContext plannerContext, Session session) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(session, plannerContext, typeAnalyzer, types), (Expression)expression);
    }

    private CanonicalizeExpressionRewriter() {
    }

    public static Expression rewrite(Expression expression, Session session, PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer, TypeProvider types) {
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(session, plannerContext, typeAnalyzer, types), (Expression)expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Session session;
        private final PlannerContext plannerContext;
        private final IrTypeAnalyzer typeAnalyzer;
        private final TypeProvider types;

        public Visitor(Session session, PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer, TypeProvider types) {
            this.session = session;
            this.plannerContext = plannerContext;
            this.typeAnalyzer = typeAnalyzer;
            this.types = types;
        }

        public Expression rewriteComparisonExpression(ComparisonExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (this.isConstant(node.getLeft()) && !this.isConstant(node.getRight())) {
                node = new ComparisonExpression(node.getOperator().flip(), node.getRight(), node.getLeft());
            }
            return treeRewriter.defaultRewrite((Expression)node, (Object)context);
        }

        public Expression rewriteArithmeticBinary(ArithmeticBinaryExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if ((node.getOperator() == ArithmeticBinaryExpression.Operator.MULTIPLY || node.getOperator() == ArithmeticBinaryExpression.Operator.ADD) && this.isConstant(node.getLeft()) && !this.isConstant(node.getRight())) {
                node = new ArithmeticBinaryExpression(node.getOperator(), node.getRight(), node.getLeft());
            }
            return treeRewriter.defaultRewrite((Expression)node, (Object)context);
        }

        public Expression rewriteIsNotNullPredicate(IsNotNullPredicate node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getValue(), (Object)context);
            return new NotExpression((Expression)new IsNullPredicate(value));
        }

        public Expression rewriteIfExpression(IfExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression condition = treeRewriter.rewrite(node.getCondition(), (Object)context);
            Expression trueValue = treeRewriter.rewrite(node.getTrueValue(), (Object)context);
            Optional<Expression> falseValue = node.getFalseValue().map(value -> treeRewriter.rewrite(value, (Object)context));
            return new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause(condition, trueValue)), falseValue);
        }

        public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression argument;
            Type argumentType;
            CatalogSchemaFunctionName functionName = ResolvedFunction.extractFunctionName(node.getName());
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName("date")) && node.getArguments().size() == 1 && ((argumentType = this.typeAnalyzer.getType(this.session, this.types, argument = (Expression)node.getArguments().get(0))) instanceof TimestampType || argumentType instanceof TimestampWithTimeZoneType || argumentType instanceof VarcharType)) {
                return new Cast(treeRewriter.rewrite(argument, (Object)context), TypeSignatureTranslator.toSqlType((Type)DateType.DATE));
            }
            return treeRewriter.defaultRewrite((Expression)node, (Object)context);
        }

        private boolean isConstant(Expression expression) {
            return IrUtils.isEffectivelyLiteral(this.plannerContext, this.session, expression);
        }
    }
}

