/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.spi.type.RowType;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.DefaultExpressionTraversalVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class DereferencePushdown {
    private DereferencePushdown() {
    }

    public static Set<SubscriptExpression> extractRowSubscripts(Collection<Expression> expressions, boolean allowOverlap, Session session, IrTypeAnalyzer typeAnalyzer, TypeProvider types) {
        Set symbolReferencesAndRowSubscripts;
        Set candidateExpressions = symbolReferencesAndRowSubscripts = expressions.stream().flatMap(expression -> DereferencePushdown.getSymbolReferencesAndRowSubscripts(expression, session, typeAnalyzer, types).stream()).collect(Collectors.toSet());
        if (!allowOverlap) {
            candidateExpressions = symbolReferencesAndRowSubscripts.stream().filter(expression -> !DereferencePushdown.prefixExists(expression, symbolReferencesAndRowSubscripts)).collect(Collectors.toSet());
        }
        return candidateExpressions.stream().filter(SubscriptExpression.class::isInstance).map(SubscriptExpression.class::cast).collect(Collectors.toSet());
    }

    public static boolean exclusiveDereferences(Set<Expression> projections, Session session, IrTypeAnalyzer typeAnalyzer, TypeProvider types) {
        return projections.stream().allMatch(expression -> expression instanceof SymbolReference || expression instanceof SubscriptExpression && DereferencePushdown.isRowSubscriptChain((SubscriptExpression)expression, session, typeAnalyzer, types) && !DereferencePushdown.prefixExists(expression, projections));
    }

    public static Symbol getBase(SubscriptExpression expression) {
        return (Symbol)Iterables.getOnlyElement(SymbolsExtractor.extractAll((Expression)expression));
    }

    private static List<Expression> getSymbolReferencesAndRowSubscripts(Expression expression, final Session session, final IrTypeAnalyzer typeAnalyzer, final TypeProvider types) {
        ImmutableList.Builder builder = ImmutableList.builder();
        new DefaultExpressionTraversalVisitor<ImmutableList.Builder<Expression>>(){

            protected Void visitSubscriptExpression(SubscriptExpression node, ImmutableList.Builder<Expression> context) {
                if (DereferencePushdown.isRowSubscriptChain(node, session, typeAnalyzer, types)) {
                    context.add((Object)node);
                }
                return null;
            }

            protected Void visitSymbolReference(SymbolReference node, ImmutableList.Builder<Expression> context) {
                context.add((Object)node);
                return null;
            }

            protected Void visitLambdaExpression(LambdaExpression node, ImmutableList.Builder<Expression> context) {
                return null;
            }
        }.process((Node)expression, (Object)builder);
        return builder.build();
    }

    private static boolean isRowSubscriptChain(SubscriptExpression expression, Session session, IrTypeAnalyzer typeAnalyzer, TypeProvider types) {
        if (!(typeAnalyzer.getType(session, types, expression.getBase()) instanceof RowType)) {
            return false;
        }
        return expression.getBase() instanceof SymbolReference || expression.getBase() instanceof SubscriptExpression && DereferencePushdown.isRowSubscriptChain((SubscriptExpression)expression.getBase(), session, typeAnalyzer, types);
    }

    private static boolean prefixExists(Expression expression, Set<Expression> expressions) {
        Expression current = expression;
        while (current instanceof SubscriptExpression) {
            if (!expressions.contains(current = ((SubscriptExpression)current).getBase())) continue;
            return true;
        }
        Verify.verify((boolean)(current instanceof SymbolReference));
        return false;
    }
}

